/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.map.MapNotFoundException;
import org.opennms.web.map.MapsException;
import org.opennms.web.map.MapsManagementException;
import org.opennms.web.map.config.MapPropertiesFactory;
import org.opennms.web.map.db.DbElement;
import org.opennms.web.map.db.DbMap;
import org.opennms.web.map.db.LinkInfo;
import org.opennms.web.map.db.Manager;
import org.opennms.web.map.db.datasources.DataSourceInterface;
import org.opennms.web.map.view.Command;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VElementInfo;
import org.opennms.web.map.view.VLink;
import org.opennms.web.map.view.VMap;
import org.opennms.web.map.view.VMapInfo;
import org.opennms.web.map.view.VProperties;

public class ManagerDefaultImpl
implements org.opennms.web.map.view.Manager {
    Manager dbManager = null;
    MapPropertiesFactory mapsPropertiesFactory = null;
    DataSourceInterface dataSource = null;
    private GroupDao m_groupDao;
    String filter = null;
    VMap sessionMap = null;
    VMap searchMap = null;
    boolean adminMode = false;
    private ThreadCategory log = null;
    private List<VElementInfo> elemInfo = new ArrayList<VElementInfo>();
    private List<VMapInfo> mapInfo = new ArrayList<VMapInfo>();
    private HashMap<String, Command> commandmap = new HashMap();

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    public Manager getDbManager() {
        return this.dbManager;
    }

    public void setDbManager(Manager dbManager) {
        this.dbManager = dbManager;
    }

    public MapPropertiesFactory getMapsPropertiesFactory() {
        return this.mapsPropertiesFactory;
    }

    public void setMapsPropertiesFactory(MapPropertiesFactory mapsPropertiesFactory) {
        this.mapsPropertiesFactory = mapsPropertiesFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCategories() throws MapsException {
        ArrayList<String> categories = new ArrayList<String>();
        try {
            CategoryFactory.init();
        }
        catch (Throwable e) {
            throw new MapsException("Error while getting categories.", e);
        }
        CatFactory cf = CategoryFactory.getInstance();
        cf.getReadLock().lock();
        try {
            this.log.debug("Get categories:");
            for (Categorygroup cg : cf.getConfig().getCategorygroupCollection()) {
                for (Category category : cg.getCategories().getCategoryCollection()) {
                    String categoryName = this.unescapeHtmlChars(category.getLabel());
                    this.log.debug(categoryName);
                    categories.add(categoryName);
                }
            }
        }
        finally {
            cf.getReadLock().unlock();
        }
        return categories;
    }

    public ManagerDefaultImpl() throws MapsException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating ManagerDefaultImpl");
        }
    }

    @Override
    public VMap openMap() throws MapNotFoundException {
        if (this.sessionMap != null) {
            return this.sessionMap;
        }
        throw new MapNotFoundException();
    }

    @Override
    public void clearMap() throws MapNotFoundException, MapsException {
        if (this.sessionMap == null) {
            throw new MapNotFoundException();
        }
        this.sessionMap.removeAllLinks();
        this.sessionMap.removeAllElements();
    }

    @Override
    public void deleteMap() throws MapNotFoundException, MapsException {
        this.deleteMap(this.sessionMap.getId());
    }

    @Override
    public void closeMap() {
        this.sessionMap = null;
    }

    @Override
    public VMap openMap(int id, String user, boolean refreshElems) throws MapsManagementException, MapNotFoundException, MapsException {
        if (id == -3) {
            this.sessionMap = this.searchMap;
            return this.sessionMap;
        }
        List<VMapInfo> visibleMaps = this.getMapsMenuByuser(user);
        for (VMapInfo mapMenu : visibleMaps) {
            if (mapMenu.getId() != id) continue;
            this.sessionMap = this.open(id, refreshElems);
            return this.sessionMap;
        }
        throw new MapNotFoundException();
    }

    @Override
    public VMap newMap(String owner, String userModifies, int width, int height) {
        VMap m = new VMap("NewMap");
        m.setOwner(owner);
        m.setUserLastModifies(userModifies);
        m.setWidth(width);
        m.setHeight(height);
        m.setId(-2);
        m.setBackground(this.mapsPropertiesFactory.getDefaultBackgroundColor());
        m.setAccessMode("RW");
        m.setType("U");
        this.sessionMap = m;
        return m;
    }

    public VMap openMap(int id, boolean refreshElems) throws MapsManagementException, MapNotFoundException, MapsException {
        return this.open(id, refreshElems);
    }

    private VMap open(int id, boolean refreshElems) throws MapsManagementException, MapNotFoundException, MapsException {
        VMap retVMap = null;
        DbMap m = this.dbManager.getMap(id);
        if (m == null) {
            throw new MapNotFoundException("Map with id " + id + " doesn't exist.");
        }
        retVMap = new VMap(id, m.getName(), m.getBackground(), m.getOwner(), m.getAccessMode(), m.getUserLastModifies(), m.getScale(), m.getOffsetX(), m.getOffsetY(), m.getType(), m.getWidth(), m.getHeight());
        retVMap.setCreateTime(m.getCreateTime());
        retVMap.setLastModifiedTime(m.getLastModifiedTime());
        DbElement[] mapElems = this.dbManager.getElementsOfMap(id);
        VElement elem = null;
        if (mapElems != null) {
            for (DbElement mapElem : mapElems) {
                elem = new VElement(mapElem);
                elem.setSeverity(this.mapsPropertiesFactory.getIndeterminateSeverity().getId());
                elem.setStatus(this.mapsPropertiesFactory.getUnknownStatus().getId());
                elem.setAvail(this.mapsPropertiesFactory.getDisabledAvail().getMin());
                this.log.debug("openMap: adding element to map with label: " + elem.getLabel());
                retVMap.addElement(elem);
            }
        }
        if (refreshElems) {
            this.log.debug("Starting refreshing elems for map with id " + id);
            for (VElement changedElem : this.localRefreshElements(retVMap.getElements().values())) {
                retVMap.removeElement(changedElem.getId(), changedElem.getType());
                retVMap.addElement(changedElem);
            }
        }
        this.log.debug("Starting adding links for map with id " + id);
        retVMap.addLinks(this.getLinks(retVMap.getElements().values()));
        this.log.debug("Ending adding links for map with id " + id);
        this.sessionMap = retVMap;
        return retVMap;
    }

    private List<VElement> localRefreshElements(Collection<VElement> mapElements) throws MapsException {
        ArrayList<VElement> elems = new ArrayList<VElement>();
        Vector<Integer> deletedNodeids = this.dbManager.getDeletedNodes();
        Map<Integer, AlarmInfo> outagedNodes = this.getAlarmedNodes();
        Map<Integer, Double> avails = this.dbManager.getAvails(mapElements.toArray(new VElement[0]));
        HashSet<Integer> nodesBySource = new HashSet();
        if (this.dataSource != null) {
            nodesBySource = this.dbManager.getNodeIdsBySource(this.filter);
        }
        for (VElement mapElement : mapElements) {
            elems.add(this.refresh(mapElement, nodesBySource, deletedNodeids, outagedNodes, avails));
        }
        return elems;
    }

    public VMapInfo getMapMenu(int mapId) throws MapNotFoundException, MapsException {
        VMapInfo m = null;
        m = this.dbManager.getMapMenu(mapId);
        if (m == null) {
            throw new MapNotFoundException("No Maps found.");
        }
        return m;
    }

    public VMap[] getMapsLike(String likeLabel, boolean refreshElems) throws MapsException {
        VMap[] retVMap = null;
        DbMap[] m = this.dbManager.getMapsLike(likeLabel);
        if (m == null) {
            throw new MapNotFoundException("Maps with label like " + likeLabel + " don't exist.");
        }
        retVMap = new VMap[m.length];
        for (int i = 0; i < m.length; ++i) {
            retVMap[i] = this.openMap(m[i].getId(), refreshElems);
        }
        return retVMap;
    }

    public VMap[] getMapsByName(String mapName, boolean refreshElems) throws MapNotFoundException, MapsException {
        VMap[] retVMap = null;
        DbMap[] m = this.dbManager.getMapsByName(mapName);
        if (m == null) {
            throw new MapNotFoundException("Maps with name " + mapName + " don't exist.");
        }
        retVMap = new VMap[m.length];
        for (int i = 0; i < m.length; ++i) {
            retVMap[i] = this.openMap(m[i].getId(), refreshElems);
        }
        return retVMap;
    }

    public VMap[] getAllMaps(boolean refreshElems) throws MapNotFoundException, MapsException {
        VMap[] retVMap = null;
        DbMap[] m = this.dbManager.getAllMaps();
        if (m == null) {
            throw new MapNotFoundException("No Maps found.");
        }
        retVMap = new VMap[m.length];
        for (int i = 0; i < m.length; ++i) {
            retVMap[i] = this.openMap(m[i].getId(), refreshElems);
        }
        return retVMap;
    }

    public VMapInfo[] getAllMapMenus() throws MapsException {
        VMapInfo[] m = null;
        m = this.dbManager.getAllMapMenus();
        return m;
    }

    public VMapInfo[] getMapsMenuByName(String mapName) throws MapNotFoundException, MapsException {
        VMapInfo[] retVMap = null;
        retVMap = this.dbManager.getMapsMenuByName(mapName);
        if (retVMap == null) {
            throw new MapNotFoundException("Maps with name " + mapName + " don't exist.");
        }
        return retVMap;
    }

    @Override
    public VMapInfo getDefaultMapsMenu(String user) throws MapsException {
        for (Group group : this.getGroupDao().findGroupsForUser(user)) {
            this.log.debug("getDefaultMapsMenu: found group: " + group.getName() + " for user:" + user);
            if (group.getDefaultMap() == null) continue;
            this.log.debug("getDefaultMapsMenu: found default map: " + group.getDefaultMap() + " for group: " + group.getName());
            VMapInfo[] vmapsinfo = this.dbManager.getMapsMenuByName(group.getDefaultMap());
            if (vmapsinfo != null) {
                this.log.debug("getDefaultMapsMenu: found " + vmapsinfo.length + " maps. Verify access ");
                for (int i = 0; i < vmapsinfo.length; ++i) {
                    if (vmapsinfo[i].getOwner().equals(user)) {
                        this.log.info("getDefaultMapsMenu: found! user: " + user + " owns the map");
                        return vmapsinfo[i];
                    }
                    DbMap map = this.dbManager.getMap(vmapsinfo[i].getId());
                    this.log.debug("getDefaultMapsMenu: map: " + map.getId() + " mapName: " + map.getName() + " Access: " + map.getAccessMode() + " Group: " + map.getGroup());
                    if (map.getAccessMode().trim().toUpperCase().equals("RW".toUpperCase()) || map.getAccessMode().trim().toUpperCase().equals("RO".toUpperCase()) || map.getAccessMode().trim().toUpperCase().equals("RWRO".toUpperCase()) && map.getGroup().equals(group.getName())) {
                        this.log.info("getDefaultMapsMenu: found! user: " + user + " has access to map: " + map.getName() + " with id: " + map.getId());
                        return vmapsinfo[i];
                    }
                    this.log.info("getDefaultMapsMenu: access is denied for default map: " + group.getDefaultMap() + " to group: " + group.getName());
                }
                continue;
            }
            this.log.info("getDefaultMapsMenu: no maps found for default map: " + group.getDefaultMap() + " for group: " + group.getName());
        }
        return new VMapInfo(-2, "no default map found", user);
    }

    @Override
    public List<VMapInfo> getVisibleMapsMenu(String user) throws MapsException {
        return this.getMapsMenuByuser(user);
    }

    private List<VMapInfo> getMapsMenuByuser(String user) throws MapsException {
        VMapInfo[] mapsbyowner;
        ArrayList<VMapInfo> maps = new ArrayList<VMapInfo>();
        ArrayList<Integer> mapsIds = new ArrayList<Integer>();
        VMapInfo[] mapsbyother = this.dbManager.getMapsMenuByOther();
        if (mapsbyother != null) {
            for (VMapInfo element : mapsbyother) {
                maps.add(element);
                mapsIds.add(element.getId());
            }
        }
        if ((mapsbyowner = this.dbManager.getMapsMenuByOwner(user)) != null) {
            for (int i = 0; i < mapsbyowner.length; ++i) {
                if (mapsIds.contains(mapsbyowner[i].getId())) continue;
                maps.add(mapsbyowner[i]);
                mapsIds.add(mapsbyowner[i].getId());
            }
        }
        Iterator ite = this.getGroupDao().findGroupsForUser(user).iterator();
        while (ite.hasNext()) {
            VMapInfo[] mapsbygroup = this.dbManager.getMapsMenuByGroup(((Group)ite.next()).getName());
            if (mapsbygroup == null) continue;
            for (int i = 0; i < mapsbygroup.length; ++i) {
                if (mapsIds.contains(mapsbygroup[i].getId())) continue;
                maps.add(mapsbygroup[i]);
                mapsIds.add(mapsbygroup[i].getId());
            }
        }
        this.mapInfo = maps;
        return this.mapInfo;
    }

    public List<VMapInfo> getMapsMenuTreeByName(String mapName) throws MapNotFoundException, MapsException {
        ArrayList<VMapInfo> mapsInTreesList = new ArrayList<VMapInfo>();
        VMapInfo[] mapsMenu = null;
        try {
            mapsMenu = this.getMapsMenuByName(mapName);
        }
        catch (MapNotFoundException mnf) {
            // empty catch block
        }
        if (mapsMenu != null) {
            for (VMapInfo element : mapsMenu) {
                int i;
                Map<Integer, Set<Integer>> parent_child = this.dbManager.getMapsStructure();
                ArrayList<Integer> childList = new ArrayList<Integer>();
                this.preorderVisit(new Integer(element.getId()), childList, parent_child);
                for (i = 0; i < childList.size(); ++i) {
                    this.preorderVisit((Integer)childList.get(i), childList, parent_child);
                }
                for (i = 0; i < childList.size(); ++i) {
                    mapsInTreesList.add(this.getMapMenu((Integer)childList.get(i)));
                }
            }
        }
        return mapsInTreesList;
    }

    private void preorderVisit(Integer rootElem, List<Integer> treeElems, Map<Integer, Set<Integer>> maps) {
        Set<Integer> childs = maps.get(rootElem);
        if (!treeElems.contains(rootElem)) {
            treeElems.add(rootElem);
        }
        if (childs != null) {
            for (Integer child : childs) {
                if (!treeElems.contains(child)) {
                    treeElems.add(child);
                }
                this.preorderVisit(child, treeElems, maps);
            }
        }
    }

    public VElement newElement(int mapId, int elementId, String type, int x, int y) throws MapsException {
        VElement velem = this.newElement(mapId, elementId, type);
        velem.setX(x);
        velem.setY(y);
        return velem;
    }

    public VElement newElement(int elementId, String type, int x, int y) throws MapsException {
        if (this.sessionMap == null) {
            throw new MapNotFoundException("session map in null");
        }
        return this.newElement(this.sessionMap.getId(), elementId, type, x, y);
    }

    @Override
    public VElement newElement(int mapId, int elementId, String type) throws MapsException {
        VElement velem = new VElement(this.dbManager.newElement(elementId, mapId, type));
        if (velem.isNode()) {
            velem.setIcon(this.getIconBySysoid(velem.getSysoid()));
        } else if (velem.isMap()) {
            velem.setIcon(this.mapsPropertiesFactory.getDefaultMapIcon());
        }
        velem.setSeverity(this.mapsPropertiesFactory.getIndeterminateSeverity().getId());
        velem.setAvail(this.mapsPropertiesFactory.getUndefinedAvail().getMin());
        velem.setStatus(this.mapsPropertiesFactory.getUnknownStatus().getId());
        this.log.debug("Adding velement to map " + velem.toString());
        return velem;
    }

    private String getIconBySysoid(String sysoid) throws MapsException {
        try {
            Map iconsBySysoid = this.mapsPropertiesFactory.getIconsBySysoid();
            if (iconsBySysoid != null) {
                this.log.debug("getIconBySysoid: sysoid = " + sysoid);
                for (String key : iconsBySysoid.keySet()) {
                    this.log.debug("getIconBySysoid: key = " + key);
                    if (!key.equals(sysoid)) continue;
                    this.log.debug("getIconBySysoid: iconBySysoid = " + (String)iconsBySysoid.get(key));
                    return (String)iconsBySysoid.get(key);
                }
            }
        }
        catch (Throwable e) {
            this.log.error("Exception while getting icons by sysoid");
            throw new MapsException(e);
        }
        return this.mapsPropertiesFactory.getDefaultNodeIcon();
    }

    @Override
    public VElement newElement(int mapId, int elementId, String type, String iconname, int x, int y) throws MapsException {
        VElement velem = this.newElement(mapId, elementId, type);
        if (iconname == null) {
            iconname = type == "M" ? this.mapsPropertiesFactory.getDefaultMapIcon() : this.mapsPropertiesFactory.getDefaultNodeIcon();
        }
        velem.setIcon(iconname);
        velem.setX(x);
        velem.setY(y);
        return velem;
    }

    public VElement newElement(int mapId, int elementId, String type, String iconname) throws MapsException {
        VElement elem = this.newElement(mapId, elementId, type);
        elem.setIcon(iconname);
        return elem;
    }

    public synchronized void deleteMap(VMap map) throws MapsException, MapNotFoundException {
        this.deleteMap(map.getId());
        this.deleteFromMapInfo(map.getId());
    }

    private void deleteFromMapInfo(int mapId) {
        ArrayList<VMapInfo> mapinfolist = new ArrayList<VMapInfo>();
        for (VMapInfo vmapinfo : this.mapInfo) {
            if (vmapinfo.getId() == mapId) continue;
            mapinfolist.add(vmapinfo);
        }
        this.mapInfo.clear();
        this.mapInfo.addAll(mapinfolist);
    }

    public synchronized void deleteMap(int mapId) throws MapsException {
        if (this.sessionMap == null) {
            throw new MapNotFoundException("session map in null");
        }
        if (this.sessionMap.getId() != mapId) {
            throw new MapsException("No current session map: cannot delete map with id " + mapId);
        }
        if (this.dbManager.deleteMap(mapId) == 0) {
            throw new MapNotFoundException("Map with id " + mapId + " doesn't exist or is automatic map");
        }
        this.sessionMap = null;
    }

    public synchronized void deleteMaps(VMap[] maps) throws MapsException {
        for (VMap map : maps) {
            this.deleteMap(map);
        }
    }

    public synchronized void deleteMaps(int[] maps) throws MapsException {
        for (int map : maps) {
            this.deleteMap(map);
        }
    }

    @Override
    public synchronized int save(VMap map) throws MapsException {
        ArrayList<DbElement> dbe = new ArrayList<DbElement>();
        for (VElement velem : map.getElements().values()) {
            dbe.add(new DbElement(velem));
        }
        return this.dbManager.saveMap(map, dbe);
    }

    public synchronized void deleteAllNodeElements() throws MapsException {
        this.dbManager.deleteNodeTypeElementsFromAllMaps();
    }

    public synchronized void deleteAllMapElements() throws MapsException {
        this.dbManager.deleteMapTypeElementsFromAllMaps();
    }

    @Override
    public VMap reloadMap(VMap map) throws MapsException {
        DbElement[] elems = this.dbManager.getElementsOfMap(map.getId());
        List<VElement> velems = new ArrayList<VElement>(elems.length);
        for (int i = 0; i < elems.length; ++i) {
            velems.add(new VElement(elems[i]));
        }
        velems = this.localRefreshElements(velems);
        map.removeAllLinks();
        map.removeAllElements();
        map.addElements(velems);
        map.addLinks(this.getLinks(map.getElements().values()));
        return map;
    }

    @Override
    public VMap refreshMap(VMap map) throws MapsException {
        if (map == null) {
            throw new MapNotFoundException("map is null");
        }
        Collection<VElement> velems = map.getElements().values();
        velems = this.localRefreshElements(velems);
        for (VElement mapElement : velems) {
            map.addElement(mapElement);
        }
        map.removeAllLinks();
        map.addLinks(this.getLinks(map.getElements().values()));
        return map;
    }

    @Override
    public boolean foundLoopOnMaps(VMap parentMap, int mapId) throws MapsException {
        Map<Integer, Set<Integer>> maps = this.dbManager.getMapsStructure();
        Set<Integer> childSet = new TreeSet<Integer>();
        for (VElement elem : parentMap.getElements().values()) {
            if (!elem.getType().equals("M")) continue;
            childSet.add(new Integer(elem.getId()));
        }
        this.log.debug("List of sub-maps before preorder visit " + childSet.toString());
        maps.put(new Integer(parentMap.getId()), childSet);
        while (childSet.size() > 0) {
            childSet = this.preorderVisit(childSet, maps);
            this.log.debug("List of sub-maps  " + childSet.toString());
            if (!childSet.contains(new Integer(mapId))) continue;
            return true;
        }
        return false;
    }

    private Set<Integer> preorderVisit(Set<Integer> treeElems, Map<Integer, Set<Integer>> maps) {
        TreeSet<Integer> childset = new TreeSet<Integer>();
        Iterator<Integer> it = treeElems.iterator();
        while (it.hasNext()) {
            Set<Integer> curset = maps.get(it.next());
            if (curset == null) continue;
            childset.addAll(curset);
        }
        return childset;
    }

    public Set<Integer> getNodeidsOnElement(VElement velem) throws MapsException {
        DbElement elem = new DbElement(velem);
        return this.dbManager.getNodeidsOnElement(elem);
    }

    @Override
    public List<VElementInfo> getElementInfo() throws MapsException {
        this.elemInfo = this.dbManager.getAllElementInfo();
        return this.elemInfo;
    }

    public Manager getDataAccessManager() {
        return this.dbManager;
    }

    private String getSeverityLabel(int severity) throws MapsException {
        return OnmsSeverity.get((int)severity).getLabel();
    }

    private VElement refresh(VElement mapElement, Set<Integer> nodesBySource, Vector<Integer> deletedNodeids, Map<Integer, AlarmInfo> outagedNodes, Map<Integer, Double> avails) throws MapsException {
        VElement ve = mapElement.clone();
        if (this.log.isDebugEnabled()) {
            this.log.debug("refresh: parsing VElement ID " + ve.getId() + ve.getType() + ", label:" + ve.getLabel() + " with node by sources: " + nodesBySource.toString() + " deletedNodeids: " + deletedNodeids.toString() + " outagedNode: " + outagedNodes.keySet().toString());
        }
        if (ve.isNode()) {
            return this.refreshNodeElement(ve, nodesBySource, deletedNodeids, outagedNodes, avails);
        }
        return this.refreshMapElement(ve, nodesBySource, deletedNodeids, outagedNodes, avails);
    }

    private VElement refreshNodeElement(VElement ve, Set<Integer> nodesBySource, Vector<Integer> deletedNodeids, Map<Integer, AlarmInfo> outagedNodes, Map<Integer, Double> avails) throws MapsException {
        if (deletedNodeids.contains(new Integer(ve.getId()))) {
            ve.setAvail(this.mapsPropertiesFactory.getUndefinedAvail().getMin());
            ve.setStatus(this.mapsPropertiesFactory.getUnknownStatus().getId());
            ve.setSeverity(this.mapsPropertiesFactory.getIndeterminateSeverity().getId());
            this.log.warn("refresh: The node with id=" + ve.getId() + " has been deleted");
            return ve;
        }
        ve.setAvail(this.mapsPropertiesFactory.getDisabledAvail().getMin());
        ve.setStatus(this.mapsPropertiesFactory.getDefaultStatus().getId());
        ve.setSeverity(this.mapsPropertiesFactory.getDefaultSeverity().getId());
        if (nodesBySource.contains(new Integer(ve.getId()))) {
            Integer id = new Integer(ve.getId());
            this.log.debug("refresh: getting status from alternative source " + this.dataSource.getClass().getName());
            int status = this.mapsPropertiesFactory.getStatus(this.dataSource.getStatus(id));
            this.log.debug("refresh: got status from alternative source. Value is " + status);
            if (status >= 0) {
                ve.setStatus(status);
            }
            int sev = this.mapsPropertiesFactory.getSeverity(this.dataSource.getSeverity(id));
            this.log.debug("refresh: got severity from alternative source. Value is " + sev);
            if (sev >= 0) {
                ve.setSeverity(sev);
            }
            if (this.mapsPropertiesFactory.isAvailEnabled()) {
                double avail = this.dataSource.getAvailability(id);
                this.log.debug("refresh: got availability from alternative source. Value is " + avail);
                if (avail >= 0.0) {
                    ve.setAvail(avail);
                }
            }
            return ve;
        }
        AlarmInfo oi = outagedNodes.get(new Integer(ve.getId()));
        if (oi != null) {
            ve.setStatus(oi.getStatus());
            ve.setSeverity(oi.getSeverity());
        }
        if (this.mapsPropertiesFactory.isAvailEnabled() && new Integer(ve.getId()) != null && avails.get(new Integer(ve.getId())) != null) {
            ve.setAvail(avails.get(new Integer(ve.getId())));
        }
        return ve;
    }

    private VElement refreshMapElement(VElement ve, Set<Integer> nodesBySource, Vector<Integer> deletedNodeids, Map<Integer, AlarmInfo> outagedNodes, Map<Integer, Double> avails) throws MapsException {
        if (this.dbManager.isElementDeleted(ve.getId(), ve.getType())) {
            ve.setAvail(this.mapsPropertiesFactory.getUndefinedAvail().getMin());
            ve.setStatus(this.mapsPropertiesFactory.getUnknownStatus().getId());
            ve.setSeverity(this.mapsPropertiesFactory.getIndeterminateSeverity().getId());
            this.log.warn("refresh: The map with id=" + ve.getId() + " was deleted");
            return ve;
        }
        ve.setStatus(-1);
        Set<Integer> nodesonve = this.getNodeidsOnElement(ve);
        this.log.debug("refresh: found nodes on Map element :" + nodesonve.toString());
        if (nodesonve.size() == 0) {
            return ve;
        }
        for (Integer nextNodeId : nodesonve) {
            this.log.debug("refresh: Iterating on Map nodes with nodeid = " + nextNodeId);
            double avail = 100 / nodesonve.size();
            int status = this.mapsPropertiesFactory.getDefaultStatus().getId();
            int severity = this.mapsPropertiesFactory.getDefaultSeverity().getId();
            if (deletedNodeids.contains(nextNodeId)) {
                severity = this.mapsPropertiesFactory.getIndeterminateSeverity().getId();
                status = this.mapsPropertiesFactory.getUnknownStatus().getId();
            } else if (nodesBySource.contains(nextNodeId)) {
                int srcstatus = this.mapsPropertiesFactory.getStatus(this.dataSource.getStatus(nextNodeId));
                if (srcstatus >= 0) {
                    status = srcstatus;
                }
                this.log.debug("refresh: got status from alternative source. Value is " + srcstatus);
                int srcseverity = this.mapsPropertiesFactory.getSeverity(this.dataSource.getSeverity(nextNodeId));
                if (srcseverity >= 0) {
                    severity = srcseverity;
                }
                this.log.debug("refresh: got severity from alternative source. Value is " + srcseverity);
                if (this.mapsPropertiesFactory.isAvailEnabled()) {
                    double srcavail = this.dataSource.getAvailability(nextNodeId);
                    if (srcavail >= 0.0) {
                        avail = srcavail / (double)nodesonve.size();
                    }
                    this.log.debug("refresh: got availability from alternative source. Value is " + srcavail);
                }
            } else {
                AlarmInfo oi = outagedNodes.get(nextNodeId);
                if (oi != null) {
                    status = oi.getStatus();
                    severity = oi.getSeverity();
                }
                if (this.mapsPropertiesFactory.isAvailEnabled() && nextNodeId != null && avails.get(nextNodeId) != null) {
                    avail = avails.get(nextNodeId) / (double)nodesonve.size();
                }
            }
            ve = this.recalculateMapElementStatus(ve, severity, status, avail);
        }
        return this.recalculateSeverity(ve, nodesonve.size());
    }

    private VElement recalculateSeverity(VElement ve, int size) {
        if (this.mapsPropertiesFactory.getSeverityMapAs().equalsIgnoreCase("avg")) {
            ve.setSeverity(new BigDecimal(ve.getSeverity() / size + 0).intValue());
        }
        if (!this.mapsPropertiesFactory.isAvailEnabled()) {
            ve.setAvail(this.mapsPropertiesFactory.getDisabledAvail().getMin());
        }
        return ve;
    }

    private VElement recalculateMapElementStatus(VElement ve, int severity, int status, double avail) {
        this.log.debug("recalculateMapElementStatus: previuos severity =  " + ve.getSeverity());
        this.log.debug("recalculateMapElementStatus: previous status = " + ve.getStatus());
        this.log.debug("recalculateMapElementStatus: previuos avail = " + ve.getAvail());
        this.log.debug("recalculateMapElementStatus: current node severity =  " + severity);
        this.log.debug("recalculateMapElementStatus: current node status = " + status);
        this.log.debug("recalculateMapElementStatus: current node avail = " + avail);
        if (ve.getStatus() == -1) {
            ve.setStatus(status);
            ve.setSeverity(severity);
            ve.setAvail(avail);
            this.log.debug("recalculateMapElementStatus: first iteration setting the upper map status to first node status");
        } else {
            String calculateSeverityAs = this.mapsPropertiesFactory.getSeverityMapAs();
            this.log.debug("recalculateMapElementStatus: calculate severity as: " + calculateSeverityAs);
            if (calculateSeverityAs.equalsIgnoreCase("avg")) {
                ve.setSeverity(severity + ve.getSeverity());
                if (ve.getStatus() > status) {
                    ve.setStatus(status);
                }
            } else if (calculateSeverityAs.equalsIgnoreCase("worst")) {
                if (ve.getSeverity() > severity) {
                    ve.setSeverity(severity);
                }
                if (ve.getStatus() > status) {
                    ve.setStatus(status);
                }
            } else if (calculateSeverityAs.equalsIgnoreCase("best")) {
                if (ve.getSeverity() < severity) {
                    ve.setSeverity(severity);
                }
                if (ve.getStatus() < status) {
                    ve.setStatus(status);
                }
            }
            ve.setAvail(ve.getAvail() + avail);
        }
        this.log.debug("recalculateMapElementStatus: updated severity =  " + ve.getSeverity());
        this.log.debug("recalculateMapElementStatus: updated status = " + ve.getStatus());
        this.log.debug("recalculateMapElementStatus: updated avail = " + ve.getAvail());
        return ve;
    }

    private Map<Integer, AlarmInfo> getAlarmedNodes() throws MapsException {
        HashMap<Integer, AlarmInfo> alarmedNodes = new HashMap<Integer, AlarmInfo>();
        this.log.debug("Getting alarmed elems.");
        Iterator<VElementInfo> ite = this.dbManager.getAlarmedElements().iterator();
        this.log.debug("Alarmed elems obtained.");
        while (ite.hasNext()) {
            AlarmInfo alarminfo;
            VElementInfo veleminfo = ite.next();
            int alarmStatus = this.mapsPropertiesFactory.getStatus(veleminfo.getUei());
            int alarmSeverity = this.mapsPropertiesFactory.getSeverity(this.getSeverityLabel(veleminfo.getSeverity()));
            if (this.log.isInfoEnabled()) {
                this.log.info("parsing alarmed node with nodeid: " + veleminfo.getId() + " severity: " + veleminfo.getSeverity() + " severity label: " + this.getSeverityLabel(veleminfo.getSeverity()));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("parsing alarmed node with nodeid: " + veleminfo.getId() + " status: " + veleminfo.getUei() + " severity label: " + this.getSeverityLabel(veleminfo.getSeverity()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("local alarmed node status/severity " + alarmStatus + "/" + alarmSeverity);
            }
            if ((alarminfo = (AlarmInfo)alarmedNodes.get(new Integer(veleminfo.getId()))) != null) {
                if (alarminfo.getStatus() > alarmStatus) {
                    alarminfo.setStatus(alarmStatus);
                    alarminfo.setSeverity(alarmSeverity);
                }
            } else {
                int curStatus = alarmStatus;
                int curSeverity = alarmSeverity;
                alarminfo = new AlarmInfo(curStatus, curSeverity);
            }
            alarmedNodes.put(new Integer(veleminfo.getId()), alarminfo);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("global element node status/severity " + alarmStatus + "/" + alarmSeverity);
        }
        return alarmedNodes;
    }

    private int getLinkTypeId(LinkInfo linkinfo) {
        if (linkinfo.linktypeid > 0) {
            return linkinfo.linktypeid;
        }
        return this.mapsPropertiesFactory.getLinkTypeId(linkinfo.snmpiftype, linkinfo.snmpifspeed);
    }

    private List<VLink> getLinks(Collection<VElement> elems) throws MapsException {
        if (elems == null) {
            return null;
        }
        String multilinkStatus = this.mapsPropertiesFactory.getMultilinkStatus();
        ArrayList<VLink> links = new ArrayList<VLink>();
        HashMap singlevlinkmap = new HashMap();
        HashMap<String, VLink> multivlinkmap = new HashMap<String, VLink>();
        HashMap<String, Integer> numberofsinglelinksmap = new HashMap<String, Integer>();
        HashMap<Integer, HashSet<VElement>> node2Element = new HashMap<Integer, HashSet<VElement>>();
        HashSet<Integer> allNodes = new HashSet<Integer>();
        for (VElement ve : elems) {
            for (Integer nodeid : this.getNodeidsOnElement(ve)) {
                allNodes.add(nodeid);
                HashSet<VElement> elements = (HashSet<VElement>)node2Element.get(nodeid);
                if (elements == null) {
                    elements = new HashSet<VElement>();
                }
                elements.add(ve);
                node2Element.put(nodeid, elements);
            }
        }
        for (LinkInfo linfo : this.dbManager.getLinksOnElements(allNodes)) {
            this.log.debug("Found link: node1:" + linfo.nodeid + " node2: " + linfo.nodeparentid);
            this.log.debug("Getting linkinfo for nodeid " + linfo.nodeid);
            for (VElement first : (Set)node2Element.get(linfo.nodeid)) {
                this.log.debug("Getting linkinfo for nodeid " + linfo.nodeparentid);
                for (VElement second : (Set)node2Element.get(linfo.nodeparentid)) {
                    if (first.hasSameIdentifier(second)) continue;
                    int status = this.getLinkStatus(linfo);
                    String statusString = this.getLinkStatusString(status);
                    VLink vlink = new VLink(first.getId(), first.getType(), second.getId(), second.getType(), this.getLinkTypeId(linfo));
                    vlink.setLinkStatusString(statusString);
                    vlink.increaseStatusMapLinks(statusString);
                    Set<Integer> nodeids = vlink.getNodeids();
                    nodeids.add(linfo.nodeid);
                    nodeids.add(linfo.nodeparentid);
                    vlink.setNodeids(nodeids);
                    this.log.debug("adding new link as single link: " + vlink.toString());
                    List<VLink> templinks = null;
                    templinks = singlevlinkmap.containsKey(vlink.getId()) ? (List)singlevlinkmap.get(vlink.getId()) : new ArrayList<VLink>();
                    templinks.add(vlink);
                    singlevlinkmap.put(vlink.getId(), templinks);
                    int numberofelement = 1;
                    if (numberofsinglelinksmap.containsKey(vlink.getIdWithoutLinkType())) {
                        numberofelement = (Integer)numberofsinglelinksmap.get(vlink.getIdWithoutLinkType());
                        ++numberofelement;
                    }
                    numberofsinglelinksmap.put(vlink.getIdWithoutLinkType(), numberofelement);
                    this.log.debug("updated link counter between elements: " + vlink.getIdWithoutLinkType() + " Found #" + numberofelement);
                    VLink vmultilink = new VLink(first.getId(), first.getType(), second.getId(), second.getType(), this.getLinkTypeId(linfo));
                    vmultilink.setLinkStatusString(statusString);
                    vmultilink.increaseStatusMapLinks(statusString);
                    if (multivlinkmap.containsKey(vmultilink.getId())) {
                        VLink alreadyIn = (VLink)multivlinkmap.get(vmultilink.getId());
                        int numberOfLinks = alreadyIn.increaseLinks();
                        this.log.debug("Updated " + numberOfLinks + " on Link: " + alreadyIn.getId());
                        int numberOfLinkwithStatus = alreadyIn.increaseStatusMapLinks(statusString);
                        this.log.debug("Updated Status Map: found: " + numberOfLinkwithStatus + " links with Status: " + statusString);
                        if (multilinkStatus.equals("best") && status < this.getLinkStatusInt(alreadyIn.getLinkStatusString()) || multilinkStatus.equals("worst") && status > this.getLinkStatusInt(alreadyIn.getLinkStatusString())) {
                            this.log.debug("Upgrading with Link info becouse multilink.status=" + multilinkStatus);
                            this.log.debug("updating existing the link " + alreadyIn.toString() + " with status " + alreadyIn.getLinkStatusString());
                            this.log.debug("setting link properties: " + vmultilink.toString() + " with new found status " + vmultilink.getLinkStatusString());
                            alreadyIn.setLinkStatusString(statusString);
                        }
                        nodeids = alreadyIn.getNodeids();
                        nodeids.add(linfo.nodeid);
                        nodeids.add(linfo.nodeparentid);
                        alreadyIn.setNodeids(nodeids);
                        this.log.debug("updating multi link: " + alreadyIn.toString());
                        multivlinkmap.put(alreadyIn.getId(), alreadyIn);
                        continue;
                    }
                    Set<Integer> vmnodeids = vmultilink.getNodeids();
                    vmnodeids.add(linfo.nodeid);
                    vmnodeids.add(linfo.nodeparentid);
                    vmultilink.setNodeids(vmnodeids);
                    this.log.debug("adding multi link: " + vmultilink.toString());
                    multivlinkmap.put(vmultilink.getId(), vmultilink);
                }
            }
        }
        int maxlinks = this.mapsPropertiesFactory.getMaxLinks();
        for (String elid : numberofsinglelinksmap.keySet()) {
            this.log.debug("parsing link between element: " + elid + " with #links " + numberofsinglelinksmap.get(elid));
            if ((Integer)numberofsinglelinksmap.get(elid) <= maxlinks) {
                for (String linkid : singlevlinkmap.keySet()) {
                    if (linkid.indexOf(elid) == -1) continue;
                    this.log.debug("adding single links for " + linkid + " Adding links # " + ((List)singlevlinkmap.get(linkid)).size());
                    links.addAll((Collection)singlevlinkmap.get(linkid));
                }
                continue;
            }
            for (String linkid : multivlinkmap.keySet()) {
                if (linkid.indexOf(elid) == -1) continue;
                this.log.debug("adding multi link for : " + linkid);
                links.add((VLink)multivlinkmap.get(linkid));
            }
        }
        this.log.debug("Found links #" + links.size());
        for (VLink vlink : links) {
            this.log.debug(vlink.toString());
        }
        return links;
    }

    private String getLinkStatusString(int linkStatus) {
        if (linkStatus == 0) {
            return "up";
        }
        if (linkStatus == 1) {
            return "down";
        }
        if (linkStatus == 2) {
            return "admindown";
        }
        if (linkStatus == 3) {
            return "testing";
        }
        if (linkStatus == -100) {
            return "good";
        }
        if (linkStatus == 1000) {
            return "bad";
        }
        if (linkStatus == 1004) {
            return "unknown";
        }
        return "unknown";
    }

    private int getLinkStatusInt(String linkStatus) {
        if (linkStatus.equals("up")) {
            return 0;
        }
        if (linkStatus.equals("down")) {
            return 1;
        }
        if (linkStatus.equals("admindown")) {
            return 2;
        }
        if (linkStatus.equals("testing")) {
            return 3;
        }
        if (linkStatus.equals("good")) {
            return -100;
        }
        if (linkStatus.equals("bad")) {
            return 1000;
        }
        return 1004;
    }

    private int getLinkStatus(LinkInfo linfo) {
        if (linfo.status.equalsIgnoreCase("G")) {
            return -100;
        }
        if (linfo.status.equalsIgnoreCase("B")) {
            return 1000;
        }
        if (linfo.status.equalsIgnoreCase("X")) {
            return 2;
        }
        if (linfo.status.equalsIgnoreCase("U")) {
            return 1004;
        }
        if (linfo.snmpifoperstatus == 1 && linfo.snmpifadminstatus == 1) {
            return 0;
        }
        if (linfo.snmpifoperstatus == 2 && linfo.snmpifadminstatus == 1) {
            return 1;
        }
        return linfo.snmpifadminstatus;
    }

    private String unescapeHtmlChars(String input) {
        return input == null ? null : input.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    public GroupDao getGroupDao() {
        return this.m_groupDao;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    private VElement getElement(int mapId, int elementId, String type) throws MapsException {
        return new VElement(this.dbManager.getElement(elementId, mapId, type));
    }

    @Override
    public VMap searchMap(String owner, String userModifies, int width, int height, List<VElement> elems) throws MapsException {
        VMap m = new VMap("SearchMap");
        m.setOwner(owner);
        m.setUserLastModifies(userModifies);
        m.setWidth(width);
        m.setHeight(height);
        m.setId(-3);
        m.setBackground(this.mapsPropertiesFactory.getDefaultBackgroundColor());
        m.setAccessMode("RW");
        m.setType("U");
        m.addElements(elems);
        m.addLinks(this.getLinks(elems));
        this.sessionMap = m;
        this.searchMap = m;
        return m;
    }

    @Override
    public Map<String, Set<Integer>> getNodeLabelToMaps(String user) throws MapsException {
        HashMap<Integer, String> maps = new HashMap<Integer, String>();
        for (VMapInfo mapinfo : this.mapInfo) {
            maps.put(new Integer(mapinfo.getId()), mapinfo.getName());
        }
        HashMap<Integer, String> elemInfoMap = new HashMap<Integer, String>();
        for (VElementInfo elem : this.elemInfo) {
            elemInfoMap.put(elem.getId(), elem.getLabel());
        }
        DbElement[] elems = this.dbManager.getAllElements();
        HashMap<String, Set<Integer>> nodelabelMap = new HashMap<String, Set<Integer>>();
        for (int i = 0; i < elems.length; ++i) {
            DbElement elem = elems[i];
            Integer mapId = new Integer(elem.getMapId());
            if (!maps.containsKey(mapId)) continue;
            String label = elem.getLabel();
            this.log.debug("getNodeLabelToMaps: found element with label: " + label);
            Set mapids = null;
            mapids = nodelabelMap.containsKey(label) ? (Set)nodelabelMap.get(label) : new TreeSet();
            mapids.add(mapId);
            nodelabelMap.put(label, mapids);
            if (elem.isMap()) {
                String mapName = (String)maps.get(elem.getId());
                if (mapName.equals(label)) continue;
                label = mapName;
                this.log.debug("getNodeLabelToMaps: found map with name: " + label);
            } else {
                String nodename = (String)elemInfoMap.get(elem.getId());
                if (label.equals(nodename)) continue;
                label = nodename;
                this.log.debug("getNodeLabelToMaps: found node with name: " + label);
            }
            mapids = nodelabelMap.containsKey(label) ? (Set)nodelabelMap.get(label) : new TreeSet();
            mapids.add(mapId);
            nodelabelMap.put(label, mapids);
        }
        return nodelabelMap;
    }

    @Override
    public VProperties getProperties(boolean isUserAdmin) throws MapsException {
        VProperties inObj = new VProperties();
        inObj.setAvailEnabled(this.mapsPropertiesFactory.isAvailEnabled());
        inObj.setDoubleClickEnabled(this.mapsPropertiesFactory.isDoubleClickEnabled());
        inObj.setContextMenuEnabled(this.mapsPropertiesFactory.isContextMenuEnabled());
        inObj.setReload(this.mapsPropertiesFactory.isReload());
        inObj.setContextMenu(this.mapsPropertiesFactory.getContextMenu());
        inObj.setLinks(this.mapsPropertiesFactory.getLinks());
        inObj.setLinkStatuses(this.mapsPropertiesFactory.getLinkStatuses());
        inObj.setStatuses(this.mapsPropertiesFactory.getStatuses());
        inObj.setSeverities(this.mapsPropertiesFactory.getSeverities());
        inObj.setAvails(this.mapsPropertiesFactory.getAvails());
        inObj.setIcons(this.mapsPropertiesFactory.getIcons());
        inObj.setBackgroundImages(this.mapsPropertiesFactory.getBackgroundImages());
        inObj.setMapElementDimensions(this.mapsPropertiesFactory.getMapElementDimensions());
        inObj.setDefaultNodeIcon(this.mapsPropertiesFactory.getDefaultNodeIcon());
        inObj.setDefaultMapIcon(this.mapsPropertiesFactory.getDefaultMapIcon());
        inObj.setDefaultBackgroundColor(this.mapsPropertiesFactory.getDefaultBackgroundColor());
        inObj.setUserAdmin(isUserAdmin);
        inObj.setCategories(this.getCategories());
        inObj.setUnknownstatusid(this.mapsPropertiesFactory.getUnknownStatusId());
        inObj.setDefaultMapElementDimension(this.mapsPropertiesFactory.getDefaultMapElementDimension());
        inObj.setMaxLinks(this.mapsPropertiesFactory.getMaxLinks());
        inObj.setSummaryLink(this.mapsPropertiesFactory.getSummaryLink());
        inObj.setSummaryLinkColor(this.mapsPropertiesFactory.getSummaryLinkColor());
        inObj.setUseSemaphore(this.mapsPropertiesFactory.isUseSemaphore());
        inObj.setMultilinkStatus(this.mapsPropertiesFactory.getMultilinkStatus());
        inObj.setMultilinkIgnoreColor(this.mapsPropertiesFactory.getMultilinkIgnoreColor());
        return inObj;
    }

    @Override
    public VMap addElements(VMap map, List<VElement> velems) throws MapsException {
        map.removeAllLinks();
        for (VElement ve : velems) {
            this.log.debug("adding map element to map with id: " + ve.getId() + ve.getType());
            try {
                VElement hve;
                String type = "H";
                if (ve.isMap()) {
                    type = "W";
                }
                if ((hve = this.getElement(map.getId(), ve.getId(), type)).getLabel() != null) {
                    ve.setLabel(hve.getLabel());
                    this.log.debug("preserving label map is hidden: label found: " + hve.getLabel());
                }
            }
            catch (Throwable e) {
                this.log.debug("No Hidden Element found for id: " + ve.getId() + ve.getType());
            }
            map.addElement(ve);
        }
        map.addLinks(this.getLinks(map.getElements().values()));
        return map;
    }

    @Override
    public void reloadConfig() throws MapsException {
        try {
            this.mapsPropertiesFactory.reload(true);
        }
        catch (FileNotFoundException e) {
            throw new MapsException((Throwable)e);
        }
        catch (IOException e) {
            throw new MapsException((Throwable)e);
        }
    }

    @Override
    public String execCommand(Command command) {
        String key = UUID.randomUUID().toString();
        this.commandmap.put(key, command);
        return key;
    }

    @Override
    public Command getCommand(String id) {
        return this.commandmap.get(id);
    }

    @Override
    public void removeCommand(String id) {
        this.commandmap.remove(id);
    }

    @Override
    public boolean checkCommandExecution() {
        ArrayList<String> keytoremove = new ArrayList<String>();
        for (String key : this.commandmap.keySet()) {
            Command c = this.commandmap.get(key);
            if (c.runned() && !c.scheduledToRemove()) {
                c.scheduleToRemove();
            }
            if (!c.runned() || !c.scheduledToRemove()) continue;
            keytoremove.add(key);
        }
        for (String key : keytoremove) {
            this.commandmap.remove(key);
        }
        return this.commandmap.size() <= 5;
    }

    private class AlarmInfo {
        int status;
        int severity;

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        AlarmInfo(int status, int severity) {
            this.status = status;
            this.severity = severity;
        }
    }
}

