/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class LoadMapsController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        this.log.debug("Loading Maps");
        String user = request.getRemoteUser();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            bw.write(ResponseAssembler.getLoadMapsResponse(this.manager.getVisibleMapsMenu(user)));
        }
        catch (Throwable e) {
            this.log.error("Error while loading visible maps for user:" + user, e);
            bw.write(ResponseAssembler.getMapErrorResponse("LoadMaps"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

