/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.WebSecurityUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class ExecCommandController
implements Controller {
    ThreadCategory log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        int timeOut = 1;
        int numberOfRequest = 10;
        int packetSize = 56;
        String hopAddress = null;
        String command = request.getParameter("command");
        if (command == null) {
            throw new IllegalArgumentException("Command is required");
        }
        String commandToExec = command;
        String address = request.getParameter("address");
        if (address == null) {
            throw new IllegalArgumentException("Address is required");
        }
        String numericoutput = request.getParameter("numericOutput");
        if (numericoutput != null && numericoutput.equals("true")) {
            commandToExec = commandToExec + " -n ";
        }
        if (command.equals("ping")) {
            String solaris;
            String packetsize;
            String numberofrequest;
            String timeout = request.getParameter("timeOut");
            if (timeout != null) {
                timeOut = WebSecurityUtils.safeParseInt((String)timeout);
            }
            if ((numberofrequest = request.getParameter("numberOfRequest")) != null) {
                numberOfRequest = WebSecurityUtils.safeParseInt((String)numberofrequest);
            }
            if ((packetsize = request.getParameter("packetSize")) != null) {
                packetSize = WebSecurityUtils.safeParseInt((String)packetsize);
            }
            commandToExec = (solaris = request.getParameter("solaris")) != null && solaris.equals("true") ? commandToExec + " -I " + timeOut + " " + address + " " + packetSize + " " + numberOfRequest : commandToExec + " -c " + numberOfRequest + " -i " + timeOut + " -s " + packetSize + " " + address;
        } else if (command.equals("traceroute")) {
            hopAddress = request.getParameter("hopAddress");
            commandToExec = hopAddress != null ? commandToExec + " -g " + hopAddress + " " + address : commandToExec + " " + address;
        } else {
            if (!command.equals("ipmitool")) throw new IllegalStateException("Command " + command + " not supported.");
            String ipmiCommand = request.getParameter("ipmiCommand");
            String ipmiUserName = request.getParameter("ipmiUser");
            String ipmiPassword = request.getParameter("ipmiPassword");
            String ipmiProtocol = request.getParameter("ipmiProtocol");
            if (ipmiCommand == null || ipmiUserName == null || ipmiPassword == null) throw new IllegalStateException("IPMITool requires Protocol, Command, Usernane and Password");
            commandToExec = commandToExec + " -I " + ipmiProtocol + " -U " + ipmiUserName + " -P " + ipmiPassword + " -H " + address + " " + ipmiCommand;
        }
        this.log.info("Executing " + commandToExec);
        response.setBufferSize(0);
        response.setContentType("text/html");
        response.setHeader("pragma", "no-Cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "no-Cache");
        final OutputStreamWriter os = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        os.write("<html>");
        try {
            String comm;
            final Command p = new Command(commandToExec);
            String string = comm = command.startsWith("ping") ? "Ping" : null;
            if (comm == null) {
                comm = command.startsWith("traceroute") ? "Trace Route" : "";
            }
            os.write("<head><title>" + comm + " " + address + " | OpenNMS Web Console</title>" + "</head>" + "<div width='100%' align='right'>" + "<input type='button' value='Close' onclick='window.close();'/>" + "</div>" + "<h3><font face='courier,arial'>Executing " + comm + " for the IP address " + address + "</h3>");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String s = null;
                        while ((s = p.getBufferedReader().readLine()) != null) {
                            os.write(s);
                            os.write("<br>");
                            os.flush();
                        }
                    }
                    catch (IOException io) {
                        ExecCommandController.this.log.warn(io.getMessage());
                    }
                }
            }, this.getClass().getSimpleName()).start();
            try {
                p.waitFor();
                return null;
            }
            catch (Throwable e) {
                this.log.warn(e.getMessage());
            }
            return null;
        }
        catch (Throwable e) {
            this.log.error("An error occourred while executing command.", e);
            os.write("An error occourred.");
            return null;
        }
        finally {
            os.write("</font><br></html>");
            os.flush();
            os.close();
        }
    }

    private class Command {
        private BufferedReader out;
        private Process p;

        public Command(String command) throws IOException, IllegalStateException {
            if (!(command.startsWith("traceroute") || command.startsWith("ping") || command.startsWith("ipmitool"))) {
                throw new IllegalStateException("Command " + command + " not supported.");
            }
            this.p = Runtime.getRuntime().exec(command);
            this.out = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        }

        public BufferedReader getBufferedReader() {
            return this.out;
        }

        public void waitFor() throws InterruptedException {
            this.p.waitFor();
        }
    }
}

