/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsRestrictions;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.web.api.Util;
import org.opennms.web.element.AtInterface;
import org.opennms.web.element.Interface;
import org.opennms.web.element.IpRouteInterface;
import org.opennms.web.element.LinkInterface;
import org.opennms.web.element.NetworkElementFactoryInterface;
import org.opennms.web.element.Service;
import org.opennms.web.element.StpInterface;
import org.opennms.web.element.StpNode;
import org.opennms.web.element.Vlan;
import org.opennms.web.svclayer.AggregateStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class NetworkElementFactory
implements InitializingBean,
NetworkElementFactoryInterface {
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monSvcDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    protected Map<String, Integer> serviceName2IdMap;
    protected Map<Integer, String> serviceId2NameMap;
    private static final Comparator<Interface> INTERFACE_COMPARATOR = new InterfaceComparator();

    public static NetworkElementFactoryInterface getInstance(ServletContext servletContext) {
        return NetworkElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static NetworkElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (NetworkElementFactoryInterface)appContext.getBean(NetworkElementFactoryInterface.class);
    }

    @Override
    public String getNodeLabel(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)nodeId));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return node.getLabel();
        }
        return null;
    }

    @Override
    public String getIpPrimaryAddress(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId), (Criterion)Restrictions.eq((String)"isSnmpPrimary", (Object)PrimaryType.PRIMARY)));
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ifaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
            return InetAddressUtils.str((InetAddress)iface.getIpAddress());
        }
        return null;
    }

    @Override
    public OnmsNode getNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)nodeId));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode onmsNode = (OnmsNode)nodes.get(0);
            return onmsNode;
        }
        return null;
    }

    @Override
    public List<OnmsNode> getAllNodes() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D")));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"type"), (Criterion)Restrictions.ne((String)"type", (Object)"D"))));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class, "node");
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesWithService(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "svc");
        criteria.createAlias("svc.serviceType", "svcType").add((Criterion)Restrictions.eq((String)"svcType.id", (Object)serviceId));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddr(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("snmpInterfaces", "snmpIfaces", 1);
        criteria.createAlias("arpInterfaces", "arpIfaces", 1);
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"snmpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"arpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE)));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrAtInterface(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("arpInterfaces", "arpIfaces");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"arpIfaces.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithPhysAddrFromSnmpInterface(String macAddr) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpIface");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIface.physAddr", (String)macAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIfAlias(String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpIface");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public String getHostname(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add(Restrictions.isNotNull((String)"ipHostName"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List ipIfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ipIfaces.size() > 0) {
            OnmsIpInterface iface = (OnmsIpInterface)ipIfaces.get(0);
            return iface.getIpHostName();
        }
        return null;
    }

    @Override
    public Integer getIfIndex(int ipinterfaceid) {
        SingleResultQuerier querier = new SingleResultQuerier(Vault.getDataSource(), "SELECT ifindex FROM IPINTERFACE WHERE ID = ?");
        querier.execute(new Object[]{ipinterfaceid});
        Integer result = (Integer)querier.getResult();
        if (result != null) {
            return result;
        }
        return -1;
    }

    @Override
    public Integer getIfIndex(int nodeID, String ipaddr) {
        SingleResultQuerier querier = new SingleResultQuerier(Vault.getDataSource(), "SELECT ifindex FROM IPINTERFACE WHERE Nodeid = " + nodeID + " and ipaddr = '" + ipaddr + "'");
        querier.execute(new Object[0]);
        Integer result = (Integer)querier.getResult();
        if (result != null) {
            return result;
        }
        return -1;
    }

    @Override
    public Interface getInterface(int ipInterfaceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)ipInterfaceId));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (ifaces.size() > 0) {
            return this.onmsIpInterface2Interface((OnmsIpInterface)ifaces.get(0));
        }
        return null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.setFetchMode("snmpInterface", FetchMode.JOIN);
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? this.onmsIpInterface2Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getInterface(int nodeId, String ipAddress, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add((Criterion)Restrictions.eq((String)"snmpIface.ifIndex", (Object)ifIndex));
        List ifaces = this.m_ipInterfaceDao.findMatching(criteria);
        return ifaces.size() > 0 ? this.onmsIpInterface2Interface((OnmsIpInterface)ifaces.get(0)) : null;
    }

    @Override
    public Interface getSnmpInterface(int nodeId, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        List snmpIfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (snmpIfaces.size() > 0) {
            return this.onmsSnmpInterface2Interface((OnmsSnmpInterface)snmpIfaces.get(0));
        }
        return null;
    }

    @Override
    public Interface[] getInterfacesWithIpAddress(String ipAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getInterfacesWithIfAlias(int nodeId, String ifAlias) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add(Restrictions.ilike((String)"snmpIface.ifAlias", (String)ifAlias, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.createAlias("snmpInterface", "snmpIface");
        criteria.createAlias("node.assetRecord", "assetRecord");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllSnmpInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.addOrder(Order.asc((String)"ifIndex"));
        return this.onmsSnmpInterfaces2InterfaceArray(this.m_snmpInterfaceDao.findMatching(criteria));
    }

    private Interface[] onmsSnmpInterfaces2InterfaceArray(List<OnmsSnmpInterface> snmpIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsSnmpInterface snmpIface : snmpIfaces) {
            intfs.add(this.onmsSnmpInterface2Interface(snmpIface));
        }
        return intfs.toArray(new Interface[intfs.size()]);
    }

    @Override
    public Interface[] getActiveInterfacesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllInterfaces() {
        return this.getAllInterfaces(true);
    }

    @Override
    public Interface[] getAllInterfaces(boolean includeSnmp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        if (!includeSnmp) {
            return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.onmsIpInterfaces2InterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Interface[] getAllManagedIpInterfaces(boolean includeSNMP) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        criteria.add((Criterion)Restrictions.ne((String)"ipAddress", (Object)InetAddressUtils.addr((String)"0.0.0.0")));
        criteria.add(Restrictions.isNotNull((String)"ipAddress"));
        criteria.addOrder(Order.asc((String)"ipHostName"));
        criteria.addOrder(Order.asc((String)"node.id"));
        criteria.addOrder(Order.asc((String)"ipAddress"));
        if (!includeSNMP) {
            return this.onmsIpInterfaces2InterfaceArray(this.m_ipInterfaceDao.findMatching(criteria));
        }
        return this.onmsIpInterfaces2InterfaceArrayWithSnmpData(this.m_ipInterfaceDao.findMatching(criteria));
    }

    @Override
    public Service getService(int nodeId, String ipAddress, int serviceId) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface", 1);
        criteria.createAlias("ipInterface.node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        List monSvcs = this.m_monSvcDao.findMatching(criteria);
        if (monSvcs.size() > 0) {
            return this.onmsMonitoredService2Service((OnmsMonitoredService)monSvcs.get(0));
        }
        return null;
    }

    @Override
    public Service getService(int ifServiceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface", 1);
        criteria.createAlias("ipInterface.node", "node", 1);
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)ifServiceId));
        criteria.addOrder(Order.asc((String)"status"));
        List monSvcs = this.m_monSvcDao.findMatching(criteria);
        if (monSvcs.size() > 0) {
            return this.onmsMonitoredService2Service((OnmsMonitoredService)monSvcs.get(0));
        }
        return null;
    }

    @Override
    public Service[] getAllServices() {
        return this.onmsMonitoredServices2ServiceArray(this.m_monSvcDao.findAll());
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress) {
        return this.getServicesOnInterface(nodeId, ipAddress, false);
    }

    @Override
    public Service[] getServicesOnInterface(int nodeId, String ipAddress, boolean includeDeletions) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddress)));
        if (!includeDeletions) {
            criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        }
        return this.onmsMonitoredServices2ServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.snmpInterface", "snmpIface", 1);
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        return this.onmsMonitoredServices2ServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    @Override
    public Service[] getServicesOnNode(int nodeId, int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class);
        criteria.createAlias("ipInterface", "ipInterface");
        criteria.createAlias("ipInterface.node", "node");
        criteria.createAlias("ipInterface.snmpInterface", "snmpInterface", 1);
        criteria.createAlias("serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        return this.onmsMonitoredServices2ServiceArray(this.m_monSvcDao.findMatching(criteria));
    }

    public AtInterface getAtInterfaceForOnmsNode(OnmsNode onmsNode, String ipAddr) {
        for (OnmsArpInterface iface : onmsNode.getArpInterfaces()) {
            String ifaceAddress = iface.getIpAddress();
            if (ifaceAddress == null || !ifaceAddress.equals(ipAddr)) continue;
            return new AtInterface(onmsNode.getId(), iface.getSourceNode().getId(), iface.getIfIndex(), iface.getIpAddress(), iface.getPhysAddr(), iface.getLastPoll().toString(), iface.getStatus().getCharCode());
        }
        return null;
    }

    protected static Interface[] rs2Interfaces(ResultSet rs) throws SQLException {
        ArrayList<Interface> intfs = new ArrayList<Interface>();
        while (rs.next()) {
            Object element = null;
            Interface intf = new Interface();
            intf.m_id = rs.getInt("id");
            intf.m_nodeId = rs.getInt("nodeid");
            intf.m_ifIndex = rs.getInt("ifIndex");
            intf.m_ipStatus = rs.getInt("ipStatus");
            intf.m_ipHostName = rs.getString("ipHostname");
            intf.m_ipAddr = rs.getString("ipAddr");
            element = rs.getString("isManaged");
            if (element != null) {
                intf.m_isManaged = ((String)element).charAt(0);
            }
            if ((element = rs.getTimestamp("ipLastCapsdPoll")) != null) {
                intf.m_ipLastCapsdPoll = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    protected static Interface[] rs2SnmpInterfaces(ResultSet rs) throws SQLException {
        ArrayList<Interface> intfs = new ArrayList<Interface>();
        while (rs.next()) {
            Interface intf = new Interface();
            intf.m_nodeId = rs.getInt("nodeid");
            intf.m_ipAddr = rs.getString("ipaddr");
            intf.m_snmpIfIndex = rs.getInt("snmpifindex");
            intf.m_snmpIpAdEntNetMask = rs.getString("snmpIpAdEntNetMask");
            intf.m_snmpPhysAddr = rs.getString("snmpPhysAddr");
            intf.m_snmpIfDescr = rs.getString("snmpIfDescr");
            intf.m_snmpIfName = rs.getString("snmpIfName");
            intf.m_snmpIfType = rs.getInt("snmpIfType");
            intf.m_snmpIfOperStatus = rs.getInt("snmpIfOperStatus");
            intf.m_snmpIfSpeed = rs.getLong("snmpIfSpeed");
            intf.m_snmpIfAdminStatus = rs.getInt("snmpIfAdminStatus");
            intf.m_snmpIfAlias = rs.getString("snmpIfAlias");
            Object element = rs.getString("snmpPoll");
            if (element != null) {
                intf.m_isSnmpPoll = ((String)element).charAt(0);
            }
            if ((element = rs.getTimestamp("snmpLastCapsdPoll")) != null) {
                intf.m_snmpLastCapsdPoll = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = rs.getTimestamp("snmpLastSnmpPoll")) != null) {
                intf.m_snmpLastSnmpPoll = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void augmentInterfacesWithSnmpData(Interface[] intfs, Connection conn) throws SQLException {
        if (intfs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i].getIfIndex() == 0) continue;
            try {
                PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM SNMPINTERFACE WHERE NODEID=? AND SNMPIFINDEX=?");
                d.watch((Object)pstmt);
                pstmt.setInt(1, intfs[i].getNodeId());
                pstmt.setInt(2, intfs[i].getIfIndex());
                ResultSet rs = pstmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    intfs[i].m_snmpIfIndex = rs.getInt("snmpifindex");
                    intfs[i].m_snmpIpAdEntNetMask = rs.getString("snmpIpAdEntNetMask");
                    intfs[i].m_snmpPhysAddr = rs.getString("snmpPhysAddr");
                    intfs[i].m_snmpIfDescr = rs.getString("snmpIfDescr");
                    intfs[i].m_snmpIfName = rs.getString("snmpIfName");
                    intfs[i].m_snmpIfType = rs.getInt("snmpIfType");
                    intfs[i].m_snmpIfOperStatus = rs.getInt("snmpIfOperStatus");
                    intfs[i].m_snmpIfSpeed = rs.getLong("snmpIfSpeed");
                    intfs[i].m_snmpIfAdminStatus = rs.getInt("snmpIfAdminStatus");
                    intfs[i].m_snmpIfAlias = rs.getString("snmpIfAlias");
                    Object element = rs.getString("snmpPoll");
                    if (element != null) {
                        intfs[i].m_isSnmpPoll = ((String)element).charAt(0);
                    }
                    if ((element = rs.getTimestamp("snmpLastCapsdPoll")) != null) {
                        intfs[i].m_snmpLastCapsdPoll = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
                    }
                    if ((element = rs.getTimestamp("snmpLastSnmpPoll")) != null) {
                        intfs[i].m_snmpLastSnmpPoll = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
                    }
                }
                pstmt = conn.prepareStatement("SELECT issnmpprimary FROM ipinterface WHERE nodeid=? AND ifindex=? AND ipaddr=?");
                d.watch((Object)pstmt);
                pstmt.setInt(1, intfs[i].getNodeId());
                pstmt.setInt(2, intfs[i].getIfIndex());
                pstmt.setString(3, intfs[i].getIpAddress());
                rs = pstmt.executeQuery();
                d.watch((Object)rs);
                if (!rs.next()) continue;
                intfs[i].m_isSnmpPrimary = rs.getString("issnmpprimary");
                continue;
            }
            finally {
                d.cleanUp();
            }
        }
    }

    protected static Service[] rs2Services(ResultSet rs) throws SQLException {
        ArrayList<Service> services = new ArrayList<Service>();
        while (rs.next()) {
            Service service = new Service();
            Object element = null;
            service.setId(rs.getInt("id"));
            service.setNodeId(rs.getInt("nodeid"));
            service.setIpAddress(InetAddressUtils.normalize((String)rs.getString("ipaddr")));
            element = rs.getTimestamp("lastgood");
            if (element != null) {
                service.setLastGood(Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime())));
            }
            service.setServiceId(rs.getInt("serviceid"));
            service.setServiceName(rs.getString("servicename"));
            element = rs.getTimestamp("lastfail");
            if (element != null) {
                service.setLastFail(Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime())));
            }
            service.setNotify(rs.getString("notify"));
            element = rs.getString("status");
            if (element != null) {
                service.setStatus(((String)element).charAt(0));
            }
            services.add(service);
        }
        return services.toArray(new Service[services.size()]);
    }

    private Service[] onmsMonitoredServices2ServiceArray(List<OnmsMonitoredService> monSvcs) {
        LinkedList<Service> svcs = new LinkedList<Service>();
        for (OnmsMonitoredService monSvc : monSvcs) {
            Service service = this.onmsMonitoredService2Service(monSvc);
            svcs.add(service);
        }
        return svcs.toArray(new Service[svcs.size()]);
    }

    private Service onmsMonitoredService2Service(OnmsMonitoredService monSvc) {
        Service service = new Service();
        service.setId(monSvc.getId());
        service.setNodeId(monSvc.getNodeId());
        service.setIpAddress(InetAddressUtils.str((InetAddress)monSvc.getIpAddress()));
        service.setServiceId(monSvc.getServiceId());
        service.setServiceName(monSvc.getServiceName());
        if (monSvc.getLastGood() != null) {
            service.setLastGood(monSvc.getLastGood().toString());
        }
        if (monSvc.getLastFail() != null) {
            service.setLastFail(monSvc.getLastFail().toString());
        }
        service.setNotify(monSvc.getNotify());
        if (monSvc.getStatus() != null) {
            service.setStatus(monSvc.getStatus().charAt(0));
        }
        return service;
    }

    @Override
    public String getServiceNameFromId(int serviceId) {
        if (this.serviceId2NameMap == null) {
            this.createServiceIdNameMaps();
        }
        String serviceName = this.serviceId2NameMap.get(new Integer(serviceId));
        return serviceName;
    }

    @Override
    public int getServiceIdFromName(String serviceName) {
        Integer value;
        if (serviceName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int serviceId = -1;
        if (this.serviceName2IdMap == null) {
            this.createServiceIdNameMaps();
        }
        if ((value = this.serviceName2IdMap.get(serviceName)) != null) {
            serviceId = value;
        }
        return serviceId;
    }

    @Override
    public Map<Integer, String> getServiceIdToNameMap() {
        if (this.serviceId2NameMap == null) {
            this.createServiceIdNameMaps();
        }
        return new HashMap<Integer, String>(this.serviceId2NameMap);
    }

    @Override
    public Map<String, Integer> getServiceNameToIdMap() {
        if (this.serviceName2IdMap == null) {
            this.createServiceIdNameMaps();
        }
        return new HashMap<String, Integer>(this.serviceName2IdMap);
    }

    protected void createServiceIdNameMaps() {
        HashMap<Integer, String> idMap = new HashMap<Integer, String>();
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        List services = this.getServiceTypeDao().findAll();
        for (OnmsServiceType servType : services) {
            idMap.put(servType.getId(), servType.getName());
            nameMap.put(servType.getName(), servType.getId());
        }
        this.serviceId2NameMap = idMap;
        this.serviceName2IdMap = nameMap;
    }

    @Override
    public List<OnmsNode> getNodesLikeAndIpLike(String nodeLabel, String iplike, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.add(Restrictions.ilike((String)"label", (Object)nodeLabel));
        nodeCrit.createCriteria("ipInterfaces").add(OnmsRestrictions.ipLike((String)iplike)).createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getNodesLike(String nodeLabel, int serviceId) {
        if (nodeLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("ipInterfaces", "iface");
        criteria.createAlias("iface.monitoredServices", "monSvcs");
        criteria.createAlias("monSvcs.serviceType", "serviceType");
        criteria.add(Restrictions.ilike((String)"label", (String)nodeLabel, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.addOrder(Order.asc((String)"label"));
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesWithIpLike(String iplike, int serviceId) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createAlias("assetRecord", "assetRecord");
        nodeCrit.createCriteria("ipInterfaces", "iface").createAlias("monitoredServices", "monSvcs").createAlias("monSvcs.serviceType", "serviceType").add(OnmsRestrictions.ipLike((String)iplike)).add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.addOrder(Order.asc((String)"label"));
        nodeCrit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(nodeCrit);
    }

    @Override
    public List<OnmsNode> getAllNodes(int serviceId) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("ipInterfaces", "ipInterfaces");
        criteria.createAlias("ipInterfaces.monitoredServices", "monSvcs");
        criteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.add((Criterion)Restrictions.eq((String)"monSvcs.serviceType.id", (Object)serviceId));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    @Override
    public List<OnmsNode> getNodesFromPhysaddr(String AtPhysAddr) {
        if (AtPhysAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("assetRecord", "assetRecord");
        criteria.createAlias("arpInterfaces", "arpInterfaces");
        criteria.add(Restrictions.ilike((String)"arpInterfaces.physAddr", (String)AtPhysAddr, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.ne((String)"arpInterfaces.status", (Object)OnmsArpInterface.StatusType.DELETED));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.m_nodeDao.findMatching(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtInterface getAtInterface(int nodeID, String ipaddr, ServletContext servletContext) throws SQLException {
        if (ipaddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        AtInterface[] nodes = null;
        AtInterface node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM ATINTERFACE WHERE NODEID = ? AND IPADDR = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setString(2, ipaddr);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2AtInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        if (nodes.length > 0) {
            return nodes[0];
        }
        return node;
    }

    @Override
    public AtInterface getAtInterface(int nodeId, String ipAddr) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        return this.getAtInterfaceForOnmsNode(node, ipAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IpRouteInterface[] getIpRoute(int nodeID) {
        IpRouteInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM IPROUTEINTERFACE WHERE NODEID = ? AND STATUS != 'D' ORDER BY ROUTEDEST");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2IpRouteInterface(rs);
        }
        catch (SQLException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred getting the IP Route for node %d", (Object[])new Object[]{nodeID});
            IpRouteInterface[] ipRouteInterfaceArray = null;
            return ipRouteInterfaceArray;
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    @Override
    public boolean isParentNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        List dlis = this.m_dataLinkInterfaceDao.findMatching(criteria);
        return dlis.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBridgeNode(int nodeID) throws SQLException {
        boolean isPN = false;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM STPNODE WHERE NODEID = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                isPN = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return isPN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRouteInfoNode(int nodeID) throws SQLException {
        boolean isRI = false;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM IPROUTEINTERFACE WHERE NODEID = ? AND STATUS != 'D' ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            int count = rs.getInt(1);
            if (count > 0) {
                isRI = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return isRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Integer> getLinkedNodeIdOnNode(int nodeID) throws SQLException {
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        Integer node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Integer element;
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
            stmt = conn.prepareStatement("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getLinkedNodeIdOnNode(int nodeID, Connection conn) throws SQLException {
        TreeSet<Integer> nodes = new TreeSet<Integer>();
        Integer node = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Integer element;
            PreparedStatement stmt = conn.prepareStatement("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
            stmt = conn.prepareStatement("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEPARENTID = ? AND STATUS != 'D'");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                element = new Integer(rs.getInt("parentid"));
                if (element != null) {
                    node = element;
                }
                nodes.add(node);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getLinkedNodeIdOnNodes(Set<Integer> nodeIds, Connection conn) throws SQLException {
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        if (nodeIds == null || nodeIds.size() == 0) {
            return new TreeSet<Integer>();
        }
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            StringBuffer query = new StringBuffer("SELECT distinct(nodeparentid) as parentid FROM DATALINKINTERFACE WHERE NODEID IN (");
            Iterator<Integer> it = nodeIds.iterator();
            StringBuffer nodesStrBuff = new StringBuffer("");
            while (it.hasNext()) {
                nodesStrBuff.append(it.next().toString());
                if (!it.hasNext()) continue;
                nodesStrBuff.append(", ");
            }
            query.append(nodesStrBuff);
            query.append(") AND STATUS != 'D'");
            PreparedStatement stmt = conn.prepareStatement(query.toString());
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt("parentid")));
            }
            query = new StringBuffer("SELECT distinct(nodeid) as parentid FROM DATALINKINTERFACE WHERE NODEID IN (");
            query.append(nodesStrBuff);
            query.append(") AND STATUS != 'D'");
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt("parentid")));
            }
        }
        finally {
            d.cleanUp();
        }
        return new TreeSet<Integer>(nodes);
    }

    @Override
    public List<LinkInterface> getDataLinksOnNode(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        criteria.addOrder(Order.asc((String)"ifIndex"));
        List<LinkInterface> ifaces = this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId);
        criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        ifaces.addAll(this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId));
        return ifaces;
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int nodeId, String ipAddress) {
        Interface iface = this.getInterface(nodeId, ipAddress);
        if (iface != null && new Integer(iface.getIfIndex()) != null && iface.getIfIndex() > 0) {
            return this.getDataLinksOnInterface(nodeId, iface.getIfIndex());
        }
        return new ArrayList<LinkInterface>();
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int id) {
        Interface iface = this.getInterface(id);
        if (iface != null && new Integer(iface.getIfIndex()) != null && iface.getIfIndex() > 0) {
            return this.getDataLinksOnInterface(iface.getNodeId(), iface.getIfIndex());
        }
        return new ArrayList<LinkInterface>();
    }

    @Override
    public List<LinkInterface> getDataLinksOnInterface(int nodeId, int ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        List<LinkInterface> ifaces = this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId);
        criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"parentIfIndex", (Object)ifIndex));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        criteria.addOrder(Order.asc((String)"parentIfIndex"));
        ifaces.addAll(this.getDataLinkInterface(this.m_dataLinkInterfaceDao.findMatching(criteria), nodeId));
        return ifaces;
    }

    private List<LinkInterface> getDataLinkInterface(List<DataLinkInterface> dlifaces, int nodeId) {
        ArrayList<LinkInterface> lifaces = new ArrayList<LinkInterface>();
        for (DataLinkInterface dliface : dlifaces) {
            if (dliface.getNode().getId() == nodeId) {
                lifaces.add(this.createLinkInterface(dliface, false));
                continue;
            }
            if (dliface.getNodeParentId() != nodeId) continue;
            lifaces.add(this.createLinkInterface(dliface, true));
        }
        return lifaces;
    }

    private LinkInterface createLinkInterface(DataLinkInterface dliface, boolean isParent) {
        Integer nodeid = dliface.getNode().getId();
        Integer linkedNodeid = dliface.getNodeParentId();
        Integer ifindex = dliface.getIfIndex();
        Integer linkedIfindex = dliface.getParentIfIndex();
        if (isParent) {
            nodeid = dliface.getNodeParentId();
            linkedNodeid = dliface.getNode().getId();
            ifindex = dliface.getParentIfIndex();
            linkedIfindex = dliface.getIfIndex();
        }
        Interface iface = this.getInterfaceForLink(nodeid, ifindex);
        Interface linkedIface = this.getInterfaceForLink(linkedNodeid, linkedIfindex);
        return new LinkInterface(nodeid, ifindex, linkedNodeid, linkedIfindex, iface, linkedIface, Util.formatDateToUIString((java.util.Date)dliface.getLastPollTime()), dliface.getStatus().charAt(0), dliface.getLinkTypeId());
    }

    private Interface getInterfaceForLink(int nodeid, int ifindex) {
        Interface iface = null;
        if (ifindex > 0) {
            iface = this.getSnmpInterface(nodeid, ifindex);
            OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
            criteria.add(Restrictions.sqlRestriction((String)("nodeid = " + nodeid + " and ifindex = " + ifindex)));
            ArrayList<String> addresses = new ArrayList<String>();
            for (OnmsIpInterface onmsIpInterface : this.m_ipInterfaceDao.findMatching(criteria)) {
                addresses.add(onmsIpInterface.getIpAddress().getHostAddress());
            }
            if (addresses.size() > 0) {
                if (iface == null) {
                    iface = new Interface();
                    iface.m_nodeId = nodeid;
                    iface.m_ifIndex = ifindex;
                }
                iface.setIpaddresses(addresses);
            } else if (iface != null) {
                iface.setIpaddresses(addresses);
            }
        }
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vlan[] getVlansOnNode(int nodeID) throws SQLException {
        Vlan[] vlans = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT * from vlan WHERE status != 'D' AND nodeid = ? order by vlanid;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            vlans = NetworkElementFactory.rs2Vlan(rs);
        }
        finally {
            d.cleanUp();
        }
        return vlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StpInterface[] getStpInterface(int nodeID) throws SQLException {
        StpInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT DISTINCT(stpnode.nodeid) AS droot, stpinterfacedb.* FROM ((SELECT DISTINCT(stpnode.nodeid) AS dbridge, stpinterface.* FROM stpinterface LEFT JOIN stpnode ON SUBSTR(stpportdesignatedbridge,5,16) = stpnode.basebridgeaddress AND stpportdesignatedbridge != '0000000000000000'WHERE stpinterface.status != 'D' AND stpinterface.nodeid = ?) AS stpinterfacedb LEFT JOIN stpnode ON SUBSTR(stpportdesignatedroot, 5, 16) = stpnode.basebridgeaddress) order by stpinterfacedb.stpvlan, stpinterfacedb.ifindex;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StpInterface[] getStpInterface(int nodeID, int ifindex) throws SQLException {
        StpInterface[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            String sqlQuery = "SELECT DISTINCT(stpnode.nodeid) AS droot, stpinterfacedb.* FROM ((SELECT DISTINCT(stpnode.nodeid) AS dbridge, stpinterface.* FROM stpinterface LEFT JOIN stpnode ON SUBSTR(stpportdesignatedbridge,5,16) = stpnode.basebridgeaddress AND stpportdesignatedbridge != '0000000000000000'WHERE stpinterface.status != 'D' AND stpinterface.nodeid = ? AND stpinterface.ifindex = ?) AS stpinterfacedb LEFT JOIN stpnode ON SUBSTR(stpportdesignatedroot, 5, 16) = stpnode.basebridgeaddress) order by stpinterfacedb.stpvlan, stpinterfacedb.ifindex;";
            PreparedStatement stmt = conn.prepareStatement(sqlQuery);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpInterface(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StpNode[] getStpNode(int nodeID) throws SQLException {
        StpNode[] nodes = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select distinct(e2.nodeid) as stpdesignatedrootnodeid, e1.* from (stpnode e1 left join stpnode e2 on substr(e1.stpdesignatedroot, 5, 16) = e2.basebridgeaddress) where e1.nodeid = ? AND e1.status != 'D' ORDER BY e1.basevlan");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            nodes = NetworkElementFactory.rs2StpNode(rs);
        }
        finally {
            d.cleanUp();
        }
        return nodes;
    }

    private static AtInterface[] rs2AtInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<AtInterface> atIfs = new ArrayList<AtInterface>();
        while (rs.next()) {
            Object element = new Integer(rs.getInt("nodeId"));
            int nodeId = (Integer)element;
            element = rs.getString("ipaddr");
            String ipaddr = (String)element;
            element = rs.getString("atphysaddr");
            String physaddr = (String)element;
            element = rs.getTimestamp("lastpolltime");
            String lastPollTime = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            element = new Integer(rs.getInt("sourcenodeID"));
            int sourcenodeid = (Integer)element;
            element = new Integer(rs.getInt("ifindex"));
            int ifindex = (Integer)element;
            element = rs.getString("status");
            char status = ((String)element).charAt(0);
            atIfs.add(new AtInterface(nodeId, sourcenodeid, ifindex, ipaddr, physaddr, lastPollTime, status));
        }
        return atIfs.toArray(new AtInterface[atIfs.size()]);
    }

    private static IpRouteInterface[] rs2IpRouteInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<IpRouteInterface> ipRtIfs = new ArrayList<IpRouteInterface>();
        while (rs.next()) {
            IpRouteInterface ipRtIf = new IpRouteInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            ipRtIf.m_nodeId = (Integer)element;
            element = rs.getString("routedest");
            ipRtIf.m_routedest = (String)element;
            element = rs.getString("routemask");
            ipRtIf.m_routemask = (String)element;
            element = rs.getString("routenexthop");
            ipRtIf.m_routenexthop = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                ipRtIf.m_lastPollTime = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("routeifindex"))) != null) {
                ipRtIf.m_routeifindex = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric1"))) != null) {
                ipRtIf.m_routemetric1 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric2"))) != null) {
                ipRtIf.m_routemetric2 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric3"))) != null) {
                ipRtIf.m_routemetric4 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric4"))) != null) {
                ipRtIf.m_routemetric4 = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("routemetric5"))) != null) {
                ipRtIf.m_routemetric5 = (Integer)element;
            }
            ipRtIf.m_routetype = (element = new Integer(rs.getInt("routetype"))) != null && (Integer)element > 0 ? (Integer)element : 1;
            element = new Integer(rs.getInt("routeproto"));
            if (element != null) {
                ipRtIf.m_routeproto = (Integer)element;
            }
            ipRtIf.m_status = (element = rs.getString("status")) != null ? ((String)element).charAt(0) : (char)75;
            ipRtIfs.add(ipRtIf);
        }
        return ipRtIfs.toArray(new IpRouteInterface[ipRtIfs.size()]);
    }

    private static StpInterface[] rs2StpInterface(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<StpInterface> stpIfs = new ArrayList<StpInterface>();
        while (rs.next()) {
            StpInterface stpIf = new StpInterface();
            Object element = new Integer(rs.getInt("nodeId"));
            stpIf.m_nodeId = (Integer)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                stpIf.m_lastPollTime = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("bridgeport"))) != null) {
                stpIf.m_bridgeport = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                stpIf.m_ifindex = (Integer)element;
            }
            element = rs.getString("stpportdesignatedroot");
            stpIf.m_stpdesignatedroot = (String)element;
            element = new Integer(rs.getInt("stpportdesignatedcost"));
            if (element != null) {
                stpIf.m_stpportdesignatedcost = (Integer)element;
            }
            element = rs.getString("stpportdesignatedbridge");
            stpIf.m_stpdesignatedbridge = (String)element;
            element = rs.getString("stpportdesignatedport");
            stpIf.m_stpdesignatedport = (String)element;
            element = new Integer(rs.getInt("stpportpathcost"));
            if (element != null) {
                stpIf.m_stpportpathcost = (Integer)element;
            }
            stpIf.m_stpportstate = (element = new Integer(rs.getInt("stpportstate"))) != null && (Integer)element > 0 ? (Integer)element : 1;
            element = new Integer(rs.getInt("stpvlan"));
            if (element != null) {
                stpIf.m_stpvlan = (Integer)element;
            }
            stpIf.m_status = (element = rs.getString("status")) != null ? ((String)element).charAt(0) : (char)75;
            element = new Integer(rs.getInt("dbridge"));
            if (element != null) {
                stpIf.m_stpbridgenodeid = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("droot"))) != null) {
                stpIf.m_stprootnodeid = (Integer)element;
            }
            stpIf.m_ipaddr = stpIf.get_ifindex() == -1 ? NetworkElementFactory.getIpAddress(stpIf.get_nodeId()) : NetworkElementFactory.getIpAddress(stpIf.get_nodeId(), stpIf.get_ifindex());
            stpIfs.add(stpIf);
        }
        return stpIfs.toArray(new StpInterface[stpIfs.size()]);
    }

    private static StpNode[] rs2StpNode(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<StpNode> stpNodes = new ArrayList<StpNode>();
        while (rs.next()) {
            StpNode stpNode = new StpNode();
            Object element = new Integer(rs.getInt("nodeId"));
            stpNode.m_nodeId = (Integer)element;
            element = rs.getString("basebridgeaddress");
            stpNode.m_basebridgeaddress = (String)element;
            element = rs.getString("stpdesignatedroot");
            stpNode.m_stpdesignatedroot = (String)element;
            element = rs.getTimestamp("lastpolltime");
            if (element != null) {
                stpNode.m_lastPollTime = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            }
            if ((element = new Integer(rs.getInt("basenumports"))) != null) {
                stpNode.m_basenumports = (Integer)element;
            }
            stpNode.m_basetype = (element = new Integer(rs.getInt("basetype"))) != null && (Integer)element > 0 ? (Integer)element : 1;
            element = new Integer(rs.getInt("basevlan"));
            if (element != null) {
                stpNode.m_basevlan = (Integer)element;
            }
            if ((element = rs.getString("basevlanname")) != null) {
                stpNode.m_basevlanname = (String)element;
            }
            if ((element = new Integer(rs.getInt("stppriority"))) != null) {
                stpNode.m_stppriority = (Integer)element;
            }
            stpNode.m_stpprotocolspecification = (element = new Integer(rs.getInt("stpprotocolspecification"))) != null && (Integer)element > 0 ? (Integer)element : 1;
            element = new Integer(rs.getInt("stprootcost"));
            if (element != null) {
                stpNode.m_stprootcost = (Integer)element;
            }
            if ((element = new Integer(rs.getInt("stprootport"))) != null) {
                stpNode.m_stprootport = (Integer)element;
            }
            stpNode.m_status = (element = rs.getString("status")) != null ? ((String)element).charAt(0) : (char)75;
            element = new Integer(rs.getInt("stpdesignatedrootnodeid"));
            if (element != null) {
                stpNode.m_stprootnodeid = (Integer)element;
            }
            stpNodes.add(stpNode);
        }
        return stpNodes.toArray(new StpNode[stpNodes.size()]);
    }

    private static Vlan[] rs2Vlan(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<Vlan> vlan = new ArrayList<Vlan>();
        while (rs.next()) {
            Object element = new Integer(rs.getInt("nodeId"));
            int nodeId = (Integer)element;
            element = rs.getInt("vlanId");
            int vlanid = (Integer)element;
            element = rs.getString("vlanname");
            String vlanname = (String)element;
            element = rs.getTimestamp("lastpolltime");
            String lastpolltime = Util.formatDateToUIString((java.util.Date)new Date(((Timestamp)element).getTime()));
            element = new Integer(rs.getInt("vlantype"));
            int vlantype = 0;
            if (element != null) {
                vlantype = (Integer)element;
            }
            element = new Integer(rs.getInt("vlanstatus"));
            int vlanstatus = 0;
            if (element != null) {
                vlanstatus = (Integer)element;
            }
            element = rs.getString("status");
            char status = ((String)element).charAt(0);
            vlan.add(new Vlan(nodeId, vlanid, vlanname, vlantype, vlanstatus, lastpolltime, status));
        }
        return vlan.toArray(new Vlan[vlan.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIpAddress(int nodeid) throws SQLException {
        String ipaddr = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(IPADDR) FROM IPINTERFACE WHERE NODEID = ?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
            }
        }
        finally {
            d.cleanUp();
        }
        return ipaddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIpAddress(int nodeid, int ifindex) throws SQLException {
        String ipaddr = null;
        DBUtils d = new DBUtils(NetworkElementFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT(IPADDR) FROM IPINTERFACE WHERE NODEID = ? AND IFINDEX = ? ");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setInt(2, ifindex);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
            }
        }
        finally {
            d.cleanUp();
        }
        return ipaddr;
    }

    @Override
    public List<Integer> getNodeIdsWithIpLike(String iplike) {
        if (iplike == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OnmsCriteria nodeCrit = new OnmsCriteria(OnmsNode.class);
        nodeCrit.createCriteria("ipInterfaces", "iface").add(OnmsRestrictions.ipLike((String)iplike));
        nodeCrit.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        nodeCrit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        List nodes = this.m_nodeDao.findMatching(nodeCrit);
        for (OnmsNode node : nodes) {
            nodeIds.add(node.getId());
        }
        return nodeIds;
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(TransactionTemplate transTemplate, final String[] categories1, final boolean onlyNodesWithDownAggregateStatus) {
        return (List)transTemplate.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus arg0) {
                return NetworkElementFactory.this.getNodesWithCategories(categories1, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories, boolean onlyNodesWithDownAggregateStatus) {
        List<OnmsNode> ourNodes = this.getNodesInCategories(categories);
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(new HashSet<OnmsNode>(ourNodes));
            ourNodes = as.getDownNodes();
        }
        return ourNodes;
    }

    private List<OnmsNode> getNodesInCategories(String[] categoryStrings) {
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>();
        for (String categoryString : categoryStrings) {
            OnmsCategory category = this.getCategoryDao().findByName(categoryString);
            if (category == null) {
                throw new IllegalArgumentException("The Category " + categoryString + " does not exist");
            }
            categories.add(category);
        }
        return this.m_nodeDao.findAllByCategoryList(categories);
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(TransactionTemplate transTemplate, final String[] categories1, final String[] categories2, final boolean onlyNodesWithDownAggregateStatus) {
        return (List)transTemplate.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus status) {
                return NetworkElementFactory.this.getNodesWithCategories(categories1, categories2, onlyNodesWithDownAggregateStatus);
            }
        });
    }

    @Override
    public List<OnmsNode> getNodesWithCategories(String[] categories1, String[] categories2, boolean onlyNodesWithDownAggregateStatus) {
        ArrayList<OnmsCategory> c1 = new ArrayList<OnmsCategory>(categories1.length);
        for (String category : categories1) {
            c1.add(this.getCategoryDao().findByName(category));
        }
        ArrayList<OnmsCategory> c2 = new ArrayList<OnmsCategory>(categories2.length);
        for (String category : categories2) {
            c2.add(this.getCategoryDao().findByName(category));
        }
        List<OnmsNode> ourNodes1 = this.getNodesInCategories(categories1);
        List<OnmsNode> ourNodes2 = this.getNodesInCategories(categories2);
        HashSet<Integer> n2id = new HashSet<Integer>(ourNodes2.size());
        for (OnmsNode n2 : ourNodes2) {
            n2id.add(n2.getId());
        }
        List<OnmsNode> ourNodes = new ArrayList<OnmsNode>();
        for (OnmsNode n1 : ourNodes1) {
            if (!n2id.contains(n1.getId())) continue;
            ourNodes.add(n1);
        }
        if (onlyNodesWithDownAggregateStatus) {
            AggregateStatus as = new AggregateStatus(ourNodes);
            ourNodes = as.getDownNodes();
        }
        return ourNodes;
    }

    private Interface onmsIpInterface2Interface(OnmsIpInterface ipIface) {
        Interface intf = new Interface();
        intf.m_id = ipIface.getId();
        if (ipIface.getNode() != null) {
            intf.m_nodeId = ipIface.getNode().getId();
        }
        if (ipIface.getSnmpInterface() != null) {
            intf.m_ifIndex = ipIface.getIfIndex();
        }
        intf.m_ipHostName = ipIface.getIpHostName();
        intf.m_ipAddr = InetAddressUtils.str((InetAddress)ipIface.getIpAddress());
        intf.m_isManaged = ipIface.getIsManaged().charAt(0);
        if (ipIface.getIpLastCapsdPoll() != null) {
            intf.m_ipLastCapsdPoll = Util.formatDateToUIString((java.util.Date)ipIface.getIpLastCapsdPoll());
        }
        return intf;
    }

    private Interface[] onmsIpInterfaces2InterfaceArray(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            intfs.add(this.onmsIpInterface2Interface(iface));
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    private Interface[] onmsIpInterfaces2InterfaceArrayWithSnmpData(List<OnmsIpInterface> ipIfaces) {
        LinkedList<Interface> intfs = new LinkedList<Interface>();
        for (OnmsIpInterface iface : ipIfaces) {
            Interface intf = this.onmsIpInterface2Interface(iface);
            if (iface.getSnmpInterface() != null) {
                java.util.Date snmpPoll;
                java.util.Date capsdPoll;
                OnmsSnmpInterface snmpIface = iface.getSnmpInterface();
                intf.m_snmpIfIndex = snmpIface.getIfIndex();
                intf.m_snmpIpAdEntNetMask = InetAddressUtils.str((InetAddress)snmpIface.getNetMask());
                intf.m_snmpPhysAddr = snmpIface.getPhysAddr();
                intf.m_snmpIfDescr = snmpIface.getIfDescr();
                intf.m_snmpIfName = snmpIface.getIfName();
                if (snmpIface.getIfType() != null) {
                    intf.m_snmpIfType = snmpIface.getIfType();
                }
                intf.m_snmpIfOperStatus = snmpIface.getIfOperStatus();
                intf.m_snmpIfSpeed = snmpIface.getIfSpeed();
                if (snmpIface.getIfAdminStatus() != null) {
                    intf.m_snmpIfAdminStatus = snmpIface.getIfAdminStatus();
                }
                intf.m_snmpIfAlias = snmpIface.getIfAlias();
                String element = snmpIface.getPoll();
                if (element != null) {
                    intf.m_isSnmpPoll = element.charAt(0);
                }
                if ((capsdPoll = snmpIface.getLastCapsdPoll()) != null) {
                    intf.m_snmpLastCapsdPoll = Util.formatDateToUIString((java.util.Date)new Date(capsdPoll.getTime()));
                }
                if ((snmpPoll = snmpIface.getLastSnmpPoll()) != null) {
                    intf.m_snmpLastSnmpPoll = Util.formatDateToUIString((java.util.Date)new Date(snmpPoll.getTime()));
                }
            }
            intfs.add(intf);
        }
        Collections.sort(intfs, INTERFACE_COMPARATOR);
        return intfs.toArray(new Interface[intfs.size()]);
    }

    private Interface onmsSnmpInterface2Interface(OnmsSnmpInterface snmpIface) {
        java.util.Date snmpPoll;
        java.util.Date capsdPoll;
        Interface intf = new Interface();
        intf.m_id = snmpIface.getId();
        if (snmpIface.getNode() != null) {
            intf.m_nodeId = snmpIface.getNode().getId();
        }
        intf.m_snmpIfIndex = snmpIface.getIfIndex();
        intf.m_snmpIpAdEntNetMask = InetAddressUtils.str((InetAddress)snmpIface.getNetMask());
        intf.m_snmpPhysAddr = snmpIface.getPhysAddr();
        intf.m_snmpIfDescr = snmpIface.getIfDescr();
        intf.m_snmpIfName = snmpIface.getIfName();
        if (snmpIface.getIfType() != null) {
            intf.m_snmpIfType = snmpIface.getIfType();
        }
        if (snmpIface.getIfOperStatus() != null) {
            intf.m_snmpIfOperStatus = snmpIface.getIfOperStatus();
        }
        if (snmpIface.getIfSpeed() != null) {
            intf.m_snmpIfSpeed = snmpIface.getIfSpeed();
        }
        if (snmpIface.getIfAdminStatus() != null) {
            intf.m_snmpIfAdminStatus = snmpIface.getIfAdminStatus();
        }
        intf.m_snmpIfAlias = snmpIface.getIfAlias();
        String element = snmpIface.getPoll();
        if (element != null) {
            intf.m_isSnmpPoll = element.charAt(0);
        }
        if ((capsdPoll = snmpIface.getLastCapsdPoll()) != null) {
            intf.m_snmpLastCapsdPoll = Util.formatDateToUIString((java.util.Date)new Date(capsdPoll.getTime()));
        }
        if ((snmpPoll = snmpIface.getLastSnmpPoll()) != null) {
            intf.m_snmpLastSnmpPoll = Util.formatDateToUIString((java.util.Date)new Date(snmpPoll.getTime()));
        }
        return intf;
    }

    private void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    private NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    private void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    private IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    private void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    private SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    private void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    private DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    private void setMonSvcDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    private MonitoredServiceDao getMonSvcDao() {
        return this.m_monSvcDao;
    }

    private void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    private ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    private void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    private CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao, (String)"NodeDao must not be null");
        Assert.notNull((Object)this.m_ipInterfaceDao, (String)"IpinterfaceDao must not be null");
    }

    public static class InterfaceComparator
    implements Comparator<Interface> {
        @Override
        public int compare(Interface o1, Interface o2) {
            if (!"0.0.0.0".equals(o1.getIpAddress()) && !"0.0.0.0".equals(o2.getIpAddress())) {
                return new InetAddressComparator().compare(InetAddressUtils.addr((String)o1.getIpAddress()), InetAddressUtils.addr((String)o2.getIpAddress()));
            }
            if (!"0.0.0.0".equals(o1.getIpAddress())) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2.getIpAddress())) {
                return 1;
            }
            return 0;
        }
    }
}

