/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.HashMap;
import java.util.Map;
import org.opennms.web.element.Interface;

public class LinkInterface {
    private final Interface m_iface;
    private final Interface m_linkedInterface;
    private final String m_lastPollTime;
    private final char m_status;
    private final Integer m_linktypeid;
    private final Integer m_nodeId;
    private final Integer m_ifindex;
    private final Integer m_linkedNodeId;
    private final Integer m_linkedIfindex;
    private static final Map<Character, String> statusMap = new HashMap<Character, String>();
    private static final Map<Integer, String> linktypeMap = new HashMap<Integer, String>();

    LinkInterface(Integer nodeid, Integer ifindex, Integer linkedNodeid, Integer linkedIfindex, Interface iface, Interface linkedIface, String lastPollTime, char status, Integer linktypeid) {
        this.m_nodeId = nodeid;
        this.m_ifindex = ifindex;
        this.m_linkedNodeId = linkedNodeid;
        this.m_linkedIfindex = linkedIfindex;
        this.m_iface = iface;
        this.m_linkedInterface = linkedIface;
        this.m_lastPollTime = lastPollTime;
        this.m_status = status;
        this.m_linktypeid = linktypeid;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_iface.getNodeId() + "\n");
        str.append("IfIndex = " + this.m_iface.getIfIndex() + "\n");
        str.append("Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Link Type Id = " + this.m_linktypeid + "\n");
        str.append("Status= " + this.m_status + "\n");
        return str.toString();
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public Integer getIfindex() {
        return this.m_ifindex;
    }

    public Integer getLinkedNodeId() {
        return this.m_linkedNodeId;
    }

    public Integer getLinkedIfindex() {
        return this.m_linkedIfindex;
    }

    public String getLastPollTime() {
        return this.m_lastPollTime;
    }

    public char getStatus() {
        return this.m_status;
    }

    public String getStatusString() {
        if (statusMap.containsKey(Character.valueOf(this.m_status))) {
            return statusMap.get(new Character(this.m_status));
        }
        return null;
    }

    public Integer getLinktypeId() {
        return this.m_linktypeid;
    }

    public String getLinkTypeIdString() {
        if (linktypeMap.containsKey(this.m_linktypeid)) {
            return linktypeMap.get(this.m_linktypeid);
        }
        return null;
    }

    public Interface getLinkedInterface() {
        return this.m_linkedInterface;
    }

    public Interface getInterface() {
        return this.m_iface;
    }

    public boolean hasInterface() {
        return this.m_iface != null;
    }

    public boolean hasLinkedInterface() {
        return this.m_linkedInterface != null;
    }

    static {
        statusMap.put(Character.valueOf('A'), "Active");
        statusMap.put(Character.valueOf('K'), "Unknown");
        statusMap.put(Character.valueOf('D'), "Deleted");
        statusMap.put(Character.valueOf('N'), "Not Active");
        statusMap.put(Character.valueOf('B'), "Bad");
        statusMap.put(Character.valueOf('G'), "Good");
        linktypeMap.put(9999, "Unknown");
        linktypeMap.put(777, "DWO connection");
        linktypeMap.put(1777, "Summary Link");
    }
}

