/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.rt.CustomField;
import org.opennms.netmgt.rt.RTQueue;
import org.opennms.netmgt.rt.RTTicket;
import org.opennms.netmgt.rt.RTUser;
import org.opennms.netmgt.rt.RequestTracker;
import org.opennms.netmgt.rt.RequestTrackerException;
import org.opennms.systemreport.SystemReport;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.FtpSystemReportFormatter;
import org.opennms.web.controller.support.SupportResults;
import org.opennms.web.controller.support.SupportRtConfigDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SupportController
extends AbstractController
implements InitializingBean {
    private SystemReport m_systemReport = null;
    private SupportRtConfigDao m_configDao = null;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        HttpSession session = request.getSession(true);
        SupportResults results = new SupportResults();
        results.setSuccess(false);
        results.setNeedsLogin(false);
        LogUtils.debugf((Object)((Object)this), (String)"operation = %s", (Object[])new Object[]{operation});
        if ("login".equals(operation)) {
            results = this.login(request);
        } else if (session.getAttribute("requestTracker") == null) {
            results.setNeedsLogin(true);
        } else if ("logout".equals(operation)) {
            results = this.logout(request);
        } else if ("createTicket".equals(operation)) {
            results = this.createTicket(request);
        }
        RequestTracker rt = (RequestTracker)session.getAttribute("requestTracker");
        if (!results.getNeedsLogin()) {
            Long queueId;
            if (results.getQueue() == null && (queueId = this.m_configDao.getQueueId()) != null) {
                RTQueue queue = rt.getQueue(queueId.longValue());
                results.setQueue(queue.getName());
            }
            results.setUsername(rt.getUsername());
            results.setLatestTickets(rt.getTicketsForQueue(results.getQueue(), 5L));
        }
        results.setRTUrl(this.m_configDao.getBaseURL());
        return new ModelAndView("/support/index", "results", (Object)results);
    }

    private SupportResults createTicket(HttpServletRequest request) {
        HttpSession session = request.getSession();
        RequestTracker rt = (RequestTracker)session.getAttribute("requestTracker");
        String subject = request.getParameter("subject").trim();
        String body = request.getParameter("text").trim();
        String includeReport = request.getParameter("include-report");
        boolean report = Boolean.parseBoolean(includeReport);
        LogUtils.debugf((Object)((Object)this), (String)"include report?: %s (parsed as %s)", (Object[])new Object[]{includeReport, new Boolean(report)});
        RTUser user = rt.getUserInfo(rt.getUsername());
        String email = user.getEmail();
        if (email == null || "".equals(email)) {
            email = this.m_configDao.getRequestor();
        }
        Long queueId = this.m_configDao.getQueueId();
        RTQueue queue = new RTQueue(0L, "Unknown");
        try {
            queue = rt.getQueue(queueId.longValue());
        }
        catch (RequestTrackerException e) {
            LogUtils.warnf((Object)((Object)this), (String)"Unable to determine queue for queue ID %s", (Object[])new Object[]{queueId.toString()});
        }
        if (report) {
            FtpSystemReportFormatter formatter = new FtpSystemReportFormatter();
            String url = this.m_configDao.getFtpBaseURL() + "/" + queue.getName() + "-" + user.getUsername() + "-" + UUID.randomUUID() + ".zip";
            formatter.setOutput(url);
            formatter.begin();
            for (SystemReportPlugin plugin : this.m_systemReport.getPlugins()) {
                if (plugin.getName().equals("Logs")) continue;
                formatter.write(plugin);
            }
            formatter.end();
            body = body.concat("\n\nSystem report is available at: " + url + "\n");
        }
        SupportResults results = new SupportResults();
        results.setNeedsLogin(false);
        results.setUsername(rt.getUsername());
        results.setQueue(queue.getName());
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        customFields.add(new CustomField(this.m_configDao.getVersionFieldName(), "Version " + Vault.getProperty((String)"version.display"), false));
        customFields.add(new CustomField(this.m_configDao.getOSFieldName(), System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")", false));
        RTTicket ticket = new RTTicket(queue.getName(), email, subject, body, customFields);
        try {
            long id = rt.createTicket(ticket);
            results.setSuccess(true);
            results.setMessage("New ticket created: <a href=\"" + this.m_configDao.getBaseURL() + "/Ticket/Display.html?id=" + id + "\">" + id + "</a>");
        }
        catch (RequestTrackerException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"Unable to create ticket %s", (Object[])new Object[]{ticket});
            results.setSuccess(false);
            results.setMessage("Unable to create ticket: " + e.getLocalizedMessage());
        }
        return results;
    }

    private SupportResults login(HttpServletRequest request) {
        String username = request.getParameter("username").trim();
        String password = request.getParameter("password").trim();
        RequestTracker rt = new RequestTracker(this.m_configDao.getBaseURL(), username, password, this.m_configDao.getTimeout(), this.m_configDao.getRetry());
        LogUtils.debugf((Object)((Object)this), (String)"tracker = %s", (Object[])new Object[]{rt});
        SupportResults results = new SupportResults();
        results.setUsername(username);
        RTQueue queue = null;
        try {
            Long queueId = this.m_configDao.getQueueId();
            if (queueId != null) {
                queue = rt.getQueue(queueId.longValue());
            }
            if (queue == null || !queue.isAccessible()) {
                queue = rt.getFirstPublicQueueForUser(username);
                LogUtils.warnf((Object)((Object)this), (String)"If more than one queue was found for user %s, the first was used.  (%s)", (Object[])new Object[]{username, queue});
                this.m_configDao.setQueueId(queue.getId());
            } else {
                LogUtils.debugf((Object)((Object)this), (String)"Existing queue found in support.properties (%s), will not overwrite.", (Object[])new Object[]{this.m_configDao.getQueueId().toString()});
            }
            this.m_configDao.setUsername(username);
            this.m_configDao.setPassword(password);
            this.m_configDao.save();
            HttpSession session = request.getSession(true);
            session.setAttribute("username", (Object)username);
            session.setAttribute("password", (Object)password);
            session.setAttribute("requestTracker", (Object)rt);
            results.setSuccess(true);
            results.setNeedsLogin(false);
            results.setMessage("Logged in successfully.");
            results.setQueue(queue.getName());
            return results;
        }
        catch (Exception e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)("Unable to log in user " + username), (Object[])new Object[0]);
            results.setSuccess(false);
            results.setNeedsLogin(true);
            results.setMessage("Unable to log in: " + e.getLocalizedMessage());
            return results;
        }
    }

    private SupportResults logout(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        RequestTracker rt = (RequestTracker)session.getAttribute("requestTracker");
        session.setAttribute("requestTracker", null);
        this.m_configDao.setUsername(null);
        this.m_configDao.setPassword(null);
        SupportResults results = new SupportResults();
        try {
            this.m_configDao.save();
            results.setSuccess(true);
            results.setNeedsLogin(true);
        }
        catch (IOException e) {
            LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"Unable to remove username/password from support.properties.", (Object[])new Object[0]);
            results.setSuccess(false);
            results.setUsername(rt.getUsername());
            results.setMessage("Unable to remove username/password from support.properties.");
        }
        return results;
    }

    public void setRtConfigDao(SupportRtConfigDao dao) {
        this.m_configDao = dao;
    }

    public void setSystemReport(SystemReport systemReport) {
        this.m_systemReport = systemReport;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_systemReport);
    }
}

