/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.outage;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageIdNotFoundException;
import org.opennms.web.outage.WebOutageRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class OutageDetailController
extends AbstractController
implements InitializingBean {
    private String m_successView;
    private WebOutageRepository m_webOutageRepository;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int outageId = -1;
        String outageIdString = request.getParameter("id");
        if (outageIdString == null) {
            throw new MissingParameterException("id");
        }
        try {
            outageId = WebSecurityUtils.safeParseInt((String)WebSecurityUtils.sanitizeString((String)outageIdString, (boolean)false));
        }
        catch (NumberFormatException e) {
            throw new OutageIdNotFoundException("The outage id must be an integer.", outageIdString);
        }
        Outage outage = this.m_webOutageRepository.getOutage(outageId);
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("outage", (Object)outage);
        return modelAndView;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webOutageRepository, (String)"webOutageRepository must be set");
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebOutageRepository(WebOutageRepository webOutageRepository) {
        this.m_webOutageRepository = webOutageRepository;
    }
}

