/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.outage;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.NodeFilter;
import org.opennms.web.outage.filter.OutageCriteria;
import org.opennms.web.outage.filter.RecentOutagesFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class NodeOutagesController
extends AbstractController
implements InitializingBean {
    private String m_successView;
    private WebOutageRepository m_webOutageRepository;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String nodeIdString = request.getParameter("node");
        int nodeId = -1;
        if (nodeIdString != null) {
            nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        }
        Outage[] outages = new Outage[]{};
        if (nodeId > 0) {
            ArrayList<OneArgFilter> filters = new ArrayList<OneArgFilter>();
            filters.add(new NodeFilter(nodeId, this.getServletContext()));
            filters.add(new RecentOutagesFilter());
            OutageCriteria criteria = new OutageCriteria(filters.toArray(new Filter[0]), SortStyle.ID, null, -1, -1);
            outages = this.m_webOutageRepository.getMatchingOutages(criteria);
        }
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("nodeId", (Object)nodeId);
        modelAndView.addObject("outages", (Object)outages);
        return modelAndView;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webOutageRepository, (String)"webOutageRepository must be set");
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebOutageRepository(WebOutageRepository webOutageRepository) {
        this.m_webOutageRepository = webOutageRepository;
    }
}

