/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.KscReportEditor;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.svclayer.KscReportService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcViewController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int report_index = -1;
        String override_timespan = null;
        String override_graphtype = null;
        String report_action = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.action.toString()));
        String domain = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.domain.toString()));
        if (report_action == null) {
            throw new MissingParameterException("action", new String[]{"action", "report", "type"});
        }
        String report_type = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.type.toString()));
        if (report_type == null) {
            throw new MissingParameterException("type", new String[]{"action", "report", "type"});
        }
        if (Actions.Customize.toString().equals(report_action) || Actions.Update.toString().equals(report_action)) {
            String r_index = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.report.toString()));
            if (r_index != null && !r_index.equals("null")) {
                report_index = WebSecurityUtils.safeParseInt((String)r_index);
            } else if (domain == null) {
                throw new MissingParameterException("report or domain", new String[]{"report or domain", "type"});
            }
            override_timespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.timespan.toString()));
            if (override_timespan == null || override_timespan.equals("null")) {
                override_timespan = "none";
            }
            if ((override_graphtype = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphtype.toString()))) == null || override_graphtype.equals("null")) {
                override_graphtype = "none";
            }
            if (Actions.Customize.toString().equals(report_action)) {
                KscReportEditor editor = KscReportEditor.getFromSession((HttpSession)request.getSession(), (boolean)false);
                if (report_type.equals("node")) {
                    editor.loadWorkingReport(this.m_kscReportService.buildNodeReport(report_index));
                } else if (report_type.equals("domain")) {
                    editor.loadWorkingReport(this.m_kscReportService.buildDomainReport(domain));
                } else {
                    editor.loadWorkingReport(this.getKscReportFactory(), report_index);
                }
                Report working_report = editor.getWorkingReport();
                for (int i = 0; i < working_report.getGraphCount(); ++i) {
                    Graph working_graph = working_report.getGraph(i);
                    if (!override_timespan.equals("none")) {
                        working_graph.setTimespan(override_timespan);
                    }
                    if (override_graphtype.equals("none")) continue;
                    working_graph.setGraphtype(override_graphtype);
                }
            }
        } else if (!Actions.Exit.toString().equals(report_action)) {
            throw new ServletException("Invalid Parameter contents for report_action");
        }
        if (Actions.Update.toString().equals(report_action)) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customView.htm");
            modelAndView.addObject("type", (Object)report_type);
            if (report_index >= 0) {
                modelAndView.addObject("report", (Object)report_index);
            }
            if (domain != null) {
                modelAndView.addObject("domain", (Object)domain);
            }
            if (override_timespan != null) {
                modelAndView.addObject("timespan", (Object)override_timespan);
            }
            if (override_graphtype != null) {
                modelAndView.addObject("graphtype", (Object)override_graphtype);
            }
            return modelAndView;
        }
        if (Actions.Customize.toString().equals(report_action)) {
            return new ModelAndView("redirect:/KSC/customReport.htm");
        }
        if (Actions.Exit.toString().equals(report_action)) {
            return new ModelAndView("redirect:/KSC/index.htm");
        }
        throw new IllegalArgumentException("Parameter action of '" + report_action + "' is not supported.  Must be one of: Update, Customize, or Exit");
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public static enum Actions {
        Customize,
        Update,
        Exit;

    }

    public static enum Parameters {
        action,
        domain,
        timespan,
        type,
        report,
        graphtype;

    }
}

