/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.event;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.LogUtils;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdListFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class AcknowledgeEventController
extends AbstractController
implements InitializingBean {
    private WebEventRepository m_webEventRepository;
    private String m_redirectView;

    public void setRedirectView(String redirectView) {
        this.m_redirectView = redirectView;
    }

    public void setWebEventRepository(WebEventRepository webEventRepository) {
        this.m_webEventRepository = webEventRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_redirectView, (String)"redirectView must be set");
        Assert.notNull((Object)this.m_webEventRepository, (String)"webEventRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] eventIdStrings = request.getParameterValues("event");
        String action = request.getParameter("actionCode");
        if (eventIdStrings == null) {
            throw new MissingParameterException("event", new String[]{"event", "actionCode"});
        }
        if (action == null) {
            throw new MissingParameterException("actionCode", new String[]{"event", "actionCode"});
        }
        ArrayList<EventIdListFilter> filters = new ArrayList<EventIdListFilter>();
        filters.add(new EventIdListFilter(WebSecurityUtils.safeParseInt((String[])eventIdStrings)));
        EventCriteria criteria = new EventCriteria(filters.toArray(new Filter[0]));
        LogUtils.debugf((Object)((Object)this), (String)"criteria = %s, action = %s", (Object[])new Object[]{criteria, action});
        if (action.equals(AcknowledgeType.ACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.acknowledgeMatchingEvents(request.getRemoteUser(), new Date(), criteria);
        } else if (action.equals(AcknowledgeType.UNACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.unacknowledgeMatchingEvents(criteria);
        } else {
            throw new ServletException("Unknown acknowledge action: " + action);
        }
        String redirectParms = request.getParameter("redirectParms");
        String redirect = request.getParameter("redirect");
        String viewName = redirect != null ? redirect : (redirectParms == null || redirectParms == "" || redirectParms == "null" ? this.m_redirectView : this.m_redirectView + "?" + redirectParms);
        RedirectView view = new RedirectView(viewName, true);
        return new ModelAndView((View)view);
    }
}

