/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jrobin.core.RrdException;
import org.jrobin.core.timespec.TimeParser;
import org.jrobin.core.timespec.TimeSpec;
import org.opennms.web.MissingParameterException;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.graph.GraphResults;
import org.opennms.web.graph.RelativeTimePeriod;
import org.opennms.web.svclayer.GraphResultsService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GraphResultsController
extends AbstractController
implements InitializingBean {
    private GraphResultsService m_graphResultsService;
    private static RelativeTimePeriod[] s_periods = RelativeTimePeriod.getDefaultPeriods();

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] ourRequiredParameters;
        String[] requiredParameters;
        for (String requiredParameter : requiredParameters = new String[]{"resourceId", "reports"}) {
            if (request.getParameter(requiredParameter) != null) continue;
            throw new MissingParameterException(requiredParameter, requiredParameters);
        }
        String[] resourceIds = request.getParameterValues("resourceId");
        String[] reports = request.getParameterValues("reports");
        String start = request.getParameter("start");
        String end = request.getParameter("end");
        String relativeTime = request.getParameter("relativetime");
        String startMonth = request.getParameter("startMonth");
        String startDate = request.getParameter("startDate");
        String startYear = request.getParameter("startYear");
        String startHour = request.getParameter("startHour");
        String endMonth = request.getParameter("endMonth");
        String endDate = request.getParameter("endDate");
        String endYear = request.getParameter("endYear");
        String endHour = request.getParameter("endHour");
        long startLong = 0L;
        long endLong = 0L;
        if (start != null || end != null) {
            ourRequiredParameters = new String[]{"start", "end"};
            if (start == null) {
                throw new MissingParameterException("start", ourRequiredParameters);
            }
            if (end == null) {
                throw new MissingParameterException("end", ourRequiredParameters);
            }
            boolean startIsInteger = false;
            boolean endIsInteger = false;
            try {
                startLong = Long.valueOf(start);
                startIsInteger = true;
                start = "" + startLong / 1000L;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                endLong = Long.valueOf(end);
                endIsInteger = true;
                end = "" + endLong / 1000L;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!endIsInteger || !startIsInteger) {
                TimeParser startParser = new TimeParser(start);
                TimeParser endParser = new TimeParser(end);
                try {
                    TimeSpec specStart = startParser.parse();
                    TimeSpec specEnd = endParser.parse();
                    long[] results = TimeSpec.getTimestamps((TimeSpec)specStart, (TimeSpec)specEnd);
                    startLong = results[0] * 1000L;
                    endLong = results[1] * 1000L;
                }
                catch (RrdException e1) {
                    throw new IllegalArgumentException("Could not parse start '" + start + "' and end '" + end + "' as valid time specifications", e1);
                }
            }
        } else if (startMonth != null || startDate != null || startYear != null || startHour != null || endMonth != null || endDate != null || endYear != null || endHour != null) {
            for (String requiredParameter : ourRequiredParameters = new String[]{"startMonth", "startDate", "startYear", "startHour", "endMonth", "endDate", "endYear", "endHour"}) {
                if (request.getParameter(requiredParameter) != null) continue;
                throw new MissingParameterException(requiredParameter, ourRequiredParameters);
            }
            Calendar startCal = Calendar.getInstance();
            startCal.set(2, WebSecurityUtils.safeParseInt((String)startMonth));
            startCal.set(5, WebSecurityUtils.safeParseInt((String)startDate));
            startCal.set(1, WebSecurityUtils.safeParseInt((String)startYear));
            startCal.set(11, WebSecurityUtils.safeParseInt((String)startHour));
            startCal.set(12, 0);
            startCal.set(13, 0);
            startCal.set(14, 0);
            Calendar endCal = Calendar.getInstance();
            endCal.set(2, WebSecurityUtils.safeParseInt((String)endMonth));
            endCal.set(5, WebSecurityUtils.safeParseInt((String)endDate));
            endCal.set(1, WebSecurityUtils.safeParseInt((String)endYear));
            endCal.set(11, WebSecurityUtils.safeParseInt((String)endHour));
            endCal.set(12, 0);
            endCal.set(13, 0);
            endCal.set(14, 0);
            startLong = startCal.getTime().getTime();
            endLong = endCal.getTime().getTime();
        } else {
            if (relativeTime == null) {
                relativeTime = s_periods[0].getId();
            }
            RelativeTimePeriod period = RelativeTimePeriod.getPeriodByIdOrDefault(s_periods, relativeTime, s_periods[0]);
            long[] times = period.getStartAndEndTimes();
            startLong = times[0];
            endLong = times[1];
        }
        GraphResults model = this.m_graphResultsService.findResults(resourceIds, reports, startLong, endLong, relativeTime);
        ModelAndView modelAndView = new ModelAndView("/graph/results", "results", (Object)model);
        modelAndView.addObject("loggedIn", (Object)(request.getRemoteUser() != null ? 1 : 0));
        return modelAndView;
    }

    public GraphResultsService getGraphResultsService() {
        return this.m_graphResultsService;
    }

    public void setGraphResultsService(GraphResultsService graphResultsService) {
        this.m_graphResultsService = graphResultsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_graphResultsService != null ? 1 : 0) != 0, (String)"graphResultsService property must be set to a non-null value");
    }
}

