/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.acknowledgments.AckService;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmIdListFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DaoWebAlarmRepository
implements WebAlarmRepository {
    @Autowired
    AlarmDao m_alarmDao;
    @Autowired
    AckService m_ackService;

    private OnmsCriteria getOnmsCriteria(AlarmCriteria alarmCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        alarmCriteria.visit(new AlarmCriteria.AlarmCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                if (ackType == AcknowledgeType.ACKNOWLEDGED) {
                    criteria.add(Restrictions.isNotNull((String)"alarmAckUser"));
                } else if (ackType == AcknowledgeType.UNACKNOWLEDGED) {
                    criteria.add(Restrictions.isNull((String)"alarmAckUser"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case COUNT: {
                        criteria.addOrder(Order.desc((String)"counter"));
                        break;
                    }
                    case FIRSTEVENTTIME: {
                        criteria.addOrder(Order.desc((String)"firstEventTime"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"id"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipAddr"));
                        break;
                    }
                    case LASTEVENTTIME: {
                        criteria.addOrder(Order.desc((String)"lastEventTime"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case POLLER: {
                        criteria.addOrder(Order.desc((String)"distPoller"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case SEVERITY: {
                        criteria.addOrder(Order.desc((String)"severity"));
                        break;
                    }
                    case REVERSE_COUNT: {
                        criteria.addOrder(Order.asc((String)"counter"));
                        break;
                    }
                    case REVERSE_FIRSTEVENTTIME: {
                        criteria.addOrder(Order.asc((String)"firstEventTime"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipAddr"));
                        break;
                    }
                    case REVERSE_LASTEVENTTIME: {
                        criteria.addOrder(Order.asc((String)"lastEventTime"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_POLLER: {
                        criteria.addOrder(Order.asc((String)"distPoller"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_SEVERITY: {
                        criteria.addOrder(Order.asc((String)"severity"));
                        break;
                    }
                }
            }
        });
        return criteria;
    }

    private Alarm mapOnmsAlarmToAlarm(OnmsAlarm onmsAlarm) {
        if (onmsAlarm == null) {
            return null;
        }
        Alarm alarm = new Alarm();
        alarm.id = onmsAlarm.getId();
        alarm.uei = onmsAlarm.getUei();
        alarm.dpName = onmsAlarm.getDistPoller() != null ? onmsAlarm.getDistPoller().getName() : "";
        alarm.nodeID = onmsAlarm.getNode() != null ? onmsAlarm.getNode().getId() : 0;
        alarm.ipAddr = onmsAlarm.getIpAddr() == null ? null : InetAddressUtils.toIpAddrString((InetAddress)onmsAlarm.getIpAddr());
        alarm.serviceID = onmsAlarm.getServiceType() != null ? onmsAlarm.getServiceType().getId() : 0;
        alarm.reductionKey = onmsAlarm.getReductionKey();
        alarm.count = onmsAlarm.getCounter();
        alarm.severity = onmsAlarm.getSeverity();
        alarm.lastEventID = onmsAlarm.getLastEvent().getId();
        alarm.firsteventtime = onmsAlarm.getFirstEventTime();
        alarm.lasteventtime = onmsAlarm.getLastEventTime();
        alarm.description = onmsAlarm.getDescription();
        alarm.logMessage = onmsAlarm.getLogMsg();
        alarm.operatorInstruction = onmsAlarm.getOperInstruct();
        alarm.troubleTicket = onmsAlarm.getTTicketId();
        alarm.troubleTicketState = onmsAlarm.getTTicketState();
        alarm.mouseOverText = onmsAlarm.getMouseOverText();
        alarm.suppressedUntil = onmsAlarm.getSuppressedUntil();
        alarm.suppressedUser = onmsAlarm.getSuppressedUser();
        alarm.suppressedTime = onmsAlarm.getSuppressedTime();
        alarm.acknowledgeUser = onmsAlarm.getAckUser();
        alarm.acknowledgeTime = onmsAlarm.getAckTime();
        alarm.parms = onmsAlarm.getEventParms();
        alarm.nodeLabel = onmsAlarm.getNode() != null ? onmsAlarm.getNode().getLabel() : "";
        alarm.serviceName = onmsAlarm.getServiceType() != null ? onmsAlarm.getServiceType().getName() : "";
        return alarm;
    }

    @Override
    @Transactional
    public void acknowledgeAll(String user, Date timestamp) {
        this.acknowledgeMatchingAlarms(user, timestamp, new AlarmCriteria(new Filter[0]));
    }

    @Transactional
    public void acknowledgeAlarms(String user, Date timestamp, int[] alarmIds) {
        this.acknowledgeMatchingAlarms(user, timestamp, new AlarmCriteria(new AlarmIdListFilter(alarmIds)));
    }

    @Override
    @Transactional
    public void acknowledgeMatchingAlarms(String user, Date timestamp, AlarmCriteria criteria) {
        List alarms = this.m_alarmDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.ACKNOWLEDGE);
            this.m_ackService.processAck(ack);
        }
    }

    @Override
    @Transactional
    public void clearAlarms(int[] alarmIds, String user, Date timestamp) {
        List alarms = this.m_alarmDao.findMatching(this.getOnmsCriteria(new AlarmCriteria(new AlarmIdListFilter(alarmIds))));
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.CLEAR);
            this.m_ackService.processAck(ack);
            this.m_alarmDao.update((Object)alarm);
        }
    }

    @Override
    @Transactional
    public int countMatchingAlarms(AlarmCriteria criteria) {
        return this.queryForInt(this.getOnmsCriteria(criteria));
    }

    @Override
    @Transactional
    public int[] countMatchingAlarmsBySeverity(AlarmCriteria criteria) {
        int[] alarmCounts = new int[8];
        for (OnmsSeverity value : OnmsSeverity.values()) {
            alarmCounts[value.getId()] = this.m_alarmDao.countMatching(this.getOnmsCriteria(criteria).add((Criterion)Restrictions.eq((String)"severity", (Object)value)));
        }
        return alarmCounts;
    }

    @Override
    @Transactional
    public void escalateAlarms(int[] alarmIds, String user, Date timestamp) {
        List alarms = this.m_alarmDao.findMatching(this.getOnmsCriteria(new AlarmCriteria(new AlarmIdListFilter(alarmIds))));
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.ESCALATE);
            this.m_ackService.processAck(ack);
        }
    }

    @Override
    @Transactional
    public Alarm getAlarm(int alarmId) {
        return this.mapOnmsAlarmToAlarm((OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId)));
    }

    @Override
    @Transactional
    public Alarm[] getMatchingAlarms(AlarmCriteria criteria) {
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        List onmsAlarms = this.m_alarmDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsAlarm onmsAlarm : onmsAlarms) {
            alarms.add(this.mapOnmsAlarmToAlarm(onmsAlarm));
        }
        return alarms.toArray(new Alarm[0]);
    }

    @Override
    @Transactional
    public void unacknowledgeAll(String user) {
        this.unacknowledgeMatchingAlarms(new AlarmCriteria(new Filter[0]), user);
    }

    @Override
    @Transactional
    public void unacknowledgeMatchingAlarms(AlarmCriteria criteria, String user) {
        List alarms = this.m_alarmDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
            this.m_ackService.processAck(ack);
        }
    }

    private int queryForInt(OnmsCriteria onmsCriteria) {
        return this.m_alarmDao.countMatching(onmsCriteria);
    }

    @Override
    @Transactional
    public void acknowledgeAlarms(int[] alarmIds, String user, Date timestamp) {
        this.acknowledgeMatchingAlarms(user, timestamp, new AlarmCriteria(new AlarmIdListFilter(alarmIds)));
    }

    @Override
    @Transactional
    public void unacknowledgeAlarms(int[] alarmIds, String user) {
        this.unacknowledgeMatchingAlarms(new AlarmCriteria(new AlarmIdListFilter(alarmIds)), user);
    }
}

