/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.alarm.filter.AcknowledgedByFilter;
import org.opennms.web.alarm.filter.AfterFirstEventTimeFilter;
import org.opennms.web.alarm.filter.AfterLastEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeFirstEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeLastEventTimeFilter;
import org.opennms.web.alarm.filter.EventParmLikeFilter;
import org.opennms.web.alarm.filter.ExactUEIFilter;
import org.opennms.web.alarm.filter.IPAddrLikeFilter;
import org.opennms.web.alarm.filter.InterfaceFilter;
import org.opennms.web.alarm.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.alarm.filter.LogMessageSubstringFilter;
import org.opennms.web.alarm.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.alarm.filter.NegativeEventParmLikeFilter;
import org.opennms.web.alarm.filter.NegativeExactUEIFilter;
import org.opennms.web.alarm.filter.NegativeInterfaceFilter;
import org.opennms.web.alarm.filter.NegativeNodeFilter;
import org.opennms.web.alarm.filter.NegativePartialUEIFilter;
import org.opennms.web.alarm.filter.NegativeServiceFilter;
import org.opennms.web.alarm.filter.NegativeSeverityFilter;
import org.opennms.web.alarm.filter.NodeFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.PartialUEIFilter;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;

public abstract class AlarmUtil {
    public static final String ANY_SERVICES_OPTION = "Any";
    public static final String ANY_SEVERITIES_OPTION = "Any";
    public static final String ANY_RELATIVE_TIMES_OPTION = "Any";
    public static final int LAST_HOUR_RELATIVE_TIME = 1;
    public static final int LAST_FOUR_HOURS_RELATIVE_TIME = 2;
    public static final int LAST_EIGHT_HOURS_RELATIVE_TIME = 3;
    public static final int LAST_TWELVE_HOURS_RELATIVE_TIME = 4;
    public static final int LAST_DAY_RELATIVE_TIME = 5;
    public static final int LAST_WEEK_RELATIVE_TIME = 6;
    public static final int LAST_MONTH_RELATIVE_TIME = 7;

    public static Filter getFilter(String filterString, ServletContext servletContext) {
        String value;
        String type;
        if (filterString == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OneArgFilter filter = null;
        StringTokenizer tokens = new StringTokenizer(filterString, "=");
        Object[] tempTokens = filterString.split("=");
        try {
            type = tempTokens[0];
            Object[] values = (String[])ArrayUtils.remove((Object[])tempTokens, (int)0);
            value = StringUtils.join((Object[])values, (String)"=");
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Could not tokenize filter string: " + filterString);
        }
        if (type.equals("severity")) {
            filter = new SeverityFilter(OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)value)));
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("nodenamelike")) {
            filter = new NodeNameLikeFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("service")) {
            filter = new ServiceFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("partialUei")) {
            filter = new PartialUEIFilter(value);
        } else if (type.equals("exactUei")) {
            filter = new ExactUEIFilter(value);
        } else if (type.equals("acknowledgedBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("severitynot")) {
            filter = new NegativeSeverityFilter(OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)value)));
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("interfacenot")) {
            filter = new NegativeInterfaceFilter(value);
        } else if (type.equals("servicenot")) {
            filter = new NegativeServiceFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("partialUeiNot")) {
            filter = new NegativePartialUEIFilter(value);
        } else if (type.equals("exactUeiNot")) {
            filter = new NegativeExactUEIFilter(value);
        } else if (type.equals("acknowledgedByNot")) {
            filter = new NegativeAcknowledgedByFilter(value);
        } else if (type.equals("iplike")) {
            filter = new IPAddrLikeFilter(value);
        } else if (type.equals("msgsub")) {
            filter = new LogMessageSubstringFilter(value);
        } else if (type.equals("msgmatchany")) {
            filter = new LogMessageMatchesAnyFilter(value);
        } else if (type.equals("beforelasteventtime")) {
            filter = new BeforeLastEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("beforefirsteventtime")) {
            filter = new BeforeFirstEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterlasteventtime")) {
            filter = new AfterLastEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterfirsteventtime")) {
            filter = new AfterFirstEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("parmmatchany")) {
            filter = new EventParmLikeFilter(value);
        } else if (type.equals("noparmmatchany")) {
            filter = new NegativeEventParmLikeFilter(value);
        }
        return filter;
    }

    public static String getFilterString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return filter.getDescription();
    }

    public static Filter getRelativeTimeFilter(int relativeTime) {
        AfterLastEventTimeFilter filter = null;
        Calendar now = Calendar.getInstance();
        switch (relativeTime) {
            case 1: {
                now.add(10, -1);
                break;
            }
            case 2: {
                now.add(10, -4);
                break;
            }
            case 3: {
                now.add(10, -8);
                break;
            }
            case 4: {
                now.add(10, -12);
                break;
            }
            case 5: {
                now.add(10, -24);
                break;
            }
            case 6: {
                now.add(10, -168);
                break;
            }
            case 7: {
                now.add(2, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relative time constant: " + relativeTime);
            }
        }
        filter = new AfterLastEventTimeFilter(now.getTime());
        return filter;
    }
}

