/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.admin.nodeManagement.ManagedInterface;
import org.opennms.web.admin.nodeManagement.ManagedService;

public class GetInterfacesServlet
extends HttpServlet {
    private static final long serialVersionUID = 6768576652872631928L;
    private static final String INTERFACE_QUERY = "SELECT ipaddr, isManaged FROM ipinterface WHERE nodeid=? AND ismanaged IN ('M','A','U','F') AND ipaddr <> '0.0.0.0' ORDER BY inet(ipaddr)";
    private static final String SERVICE_QUERY = "SELECT ifservices.serviceid, servicename, status FROM ifservices, service WHERE nodeid=? AND ipaddr=? AND status IN ('A','U','F', 'S', 'R') AND ifservices.serviceid = service.serviceid ORDER BY servicename";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int nodeId = -1;
        String nodeIdString = request.getParameter("node");
        if (nodeIdString == null) {
            throw new ServletException("Missing node Id.");
        }
        HttpSession user = request.getSession(true);
        try {
            nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        }
        catch (NumberFormatException numE) {
            throw new ServletException(numE.getMessage());
        }
        if (nodeId < 0) {
            throw new ServletException("Invalid node ID.");
        }
        try {
            user.setAttribute("interfaces.nodemanagement", this.getInterfaces(user, nodeId));
        }
        catch (SQLException sqlE) {
            throw new ServletException((Throwable)sqlE);
        }
        catch (IllegalStateException illE) {
            throw new ServletException((Throwable)illE);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/nodemanagement/managenode.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ManagedInterface> getInterfaces(HttpSession userSession, int nodeId) throws SQLException {
        Connection connection = null;
        ArrayList<ManagedInterface> allInterfaces = new ArrayList<ManagedInterface>();
        int lineCount = 0;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            PreparedStatement ifaceStmt = connection.prepareStatement(INTERFACE_QUERY);
            d.watch((Object)ifaceStmt);
            ifaceStmt.setInt(1, nodeId);
            ResultSet ifaceResults = ifaceStmt.executeQuery();
            d.watch((Object)ifaceResults);
            while (ifaceResults.next()) {
                ++lineCount;
                ManagedInterface newInterface = new ManagedInterface();
                newInterface.setNodeid(nodeId);
                newInterface.setAddress(ifaceResults.getString(1));
                newInterface.setStatus(ifaceResults.getString(2));
                allInterfaces.add(newInterface);
                PreparedStatement svcStmt = connection.prepareStatement(SERVICE_QUERY);
                d.watch((Object)svcStmt);
                svcStmt.setInt(1, nodeId);
                svcStmt.setString(2, newInterface.getAddress());
                ResultSet svcResults = svcStmt.executeQuery();
                d.watch((Object)svcResults);
                while (svcResults.next()) {
                    ++lineCount;
                    ManagedService newService = new ManagedService();
                    newService.setId(svcResults.getInt(1));
                    newService.setName(svcResults.getString(2));
                    newService.setStatus(svcResults.getString(3));
                    newInterface.addService(newService);
                }
            }
            userSession.setAttribute("lineItems.nodemanagement", (Object)new Integer(lineCount));
        }
        finally {
            d.cleanUp();
        }
        return allInterfaces;
    }
}

