/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;

public class PollerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 2622622848304715121L;
    PollerConfiguration pollerConfig = null;
    CapsdConfiguration capsdConfig = null;
    protected String redirectSuccess;
    HashMap<String, Service> pollerServices = new HashMap();
    HashMap<String, ProtocolPlugin> capsdProtocols = new HashMap();
    List<ProtocolPlugin> capsdColl = new ArrayList<ProtocolPlugin>();
    Package pkg = null;
    Collection<ProtocolPlugin> pluginColl = null;
    Properties props = new Properties();
    PollerConfig pollerFactory = null;
    CapsdConfig capsdFactory = null;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
            PollerConfigFactory.init();
            this.pollerFactory = PollerConfigFactory.getInstance();
            this.pollerConfig = this.pollerFactory.getConfiguration();
            if (this.pollerConfig == null) {
                throw new ServletException("Poller Configuration file is empty");
            }
            CapsdConfigFactory.init();
            this.capsdFactory = CapsdConfigFactory.getInstance();
            this.capsdConfig = this.capsdFactory.getConfiguration();
            if (this.capsdConfig == null) {
                throw new ServletException("Poller Configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void reloadFiles() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
            PollerConfigFactory.init();
            this.pollerFactory = PollerConfigFactory.getInstance();
            this.pollerConfig = this.pollerFactory.getConfiguration();
            if (this.pollerConfig == null) {
                throw new ServletException("Poller Configuration file is empty");
            }
            CapsdConfigFactory.init();
            this.capsdFactory = CapsdConfigFactory.getInstance();
            this.capsdConfig = this.capsdFactory.getConfiguration();
            if (this.capsdConfig == null) {
                throw new ServletException("Poller Configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void initCapsdProtocols() {
        this.pluginColl = this.capsdConfig.getProtocolPluginCollection();
        if (this.pluginColl != null) {
            for (ProtocolPlugin plugin : this.pluginColl) {
                this.capsdColl.add(plugin);
                this.capsdProtocols.put(plugin.getProtocol(), plugin);
            }
        }
    }

    public void initPollerServices() {
        Iterator pkgiter;
        List packageColl = this.pollerConfig.getPackageCollection();
        if (packageColl != null && (pkgiter = packageColl.iterator()).hasNext()) {
            this.pkg = (Package)pkgiter.next();
            List svcColl = this.pkg.getServiceCollection();
            Iterator svcIter = svcColl.iterator();
            Service svcProp = null;
            while (svcIter.hasNext()) {
                svcProp = (Service)svcIter.next();
                this.pollerServices.put(svcProp.getName(), svcProp);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reloadFiles();
        String query = request.getQueryString();
        if (query != null) {
            ArrayList<String> checkedList = new ArrayList<String>();
            ArrayList<String> deleteList = new ArrayList<String>();
            this.props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
            StringTokenizer strTok = new StringTokenizer(query, "&");
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                if (token == null) continue;
                StringTokenizer keyTokens = new StringTokenizer(token, "=");
                String name = null;
                if (keyTokens.hasMoreTokens()) {
                    name = keyTokens.nextToken();
                }
                if (!keyTokens.hasMoreTokens()) continue;
                String checked = keyTokens.nextToken();
                if (name == null) continue;
                if (name.indexOf("delete") == -1) {
                    this.modifyPollerInfo(checked, name);
                    checkedList.add(name);
                    continue;
                }
                String deleteService = name.substring(0, name.indexOf("delete"));
                deleteList.add(deleteService);
            }
            this.adjustNonChecked(checkedList);
            this.deleteThese(deleteList);
            OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), "UTF-8");
            OutputStreamWriter capsd_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME)), "UTF-8");
            try {
                Marshaller.marshal((Object)this.pollerConfig, (Writer)poller_fileWriter);
                Marshaller.marshal((Object)this.capsdConfig, (Writer)capsd_fileWriter);
            }
            catch (MarshalException e) {
                e.printStackTrace();
                throw new ServletException(e.getMessage());
            }
            catch (ValidationException e) {
                e.printStackTrace();
                throw new ServletException(e.getMessage());
            }
        }
        response.sendRedirect(this.redirectSuccess);
    }

    public void deleteCapsdInfo(String name) {
        if (this.capsdProtocols.get(name) != null) {
            ProtocolPlugin tmpproto = this.capsdProtocols.get(name);
            this.capsdProtocols.remove(name);
            this.pluginColl = this.capsdProtocols.values();
            this.capsdColl.remove(tmpproto);
            this.capsdConfig.setProtocolPluginCollection(new ArrayList<ProtocolPlugin>(this.pluginColl));
        }
    }

    public void adjustNonChecked(List<String> checkedList) {
        if (this.pkg != null) {
            List svcColl = this.pkg.getServiceCollection();
            Service svc2 = null;
            if (svcColl != null) {
                for (Service svc2 : svcColl) {
                    if (svc2 == null || checkedList.contains(svc2.getName()) || !svc2.getStatus().equals("on")) continue;
                    svc2.setStatus("off");
                }
            }
        }
    }

    public void deleteThese(List<String> deleteServices) throws IOException {
        ListIterator<String> lstIter = deleteServices.listIterator();
        while (lstIter.hasNext()) {
            String svcname = lstIter.next();
            if (this.pkg == null) continue;
            boolean flag = false;
            List svcColl = this.pkg.getServiceCollection();
            if (svcColl == null) continue;
            Iterator svcIter = svcColl.iterator();
            Service svc = null;
            while (svcIter.hasNext()) {
                svc = (Service)svcIter.next();
                if (svc == null || !svc.getName().equals(svcname)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            this.pkg.removeService(svc);
            this.removeMonitor(svc.getName());
            this.deleteCapsdInfo(svc.getName());
            this.props.remove("service." + svc.getName() + ".protocol");
            this.props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        }
    }

    public void removeMonitor(String service) {
        List monitorColl = this.pollerConfig.getMonitorCollection();
        Monitor newMonitor = new Monitor();
        if (monitorColl != null) {
            for (Monitor mon : monitorColl) {
                if (mon == null || !mon.getService().equals(service)) continue;
                newMonitor.setService(service);
                newMonitor.setClassName(mon.getClassName());
                newMonitor.setParameterCollection(mon.getParameterCollection());
                break;
            }
            monitorColl.remove(newMonitor);
        }
    }

    public void modifyPollerInfo(String bPolled, String protocol) {
        List svcColl;
        if (this.pkg != null && (svcColl = this.pkg.getServiceCollection()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(protocol)) continue;
                svc.setStatus(bPolled);
                break;
            }
        }
    }
}

