/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2006-2011 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2011 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Encapsulates all node filtering functionality.
 *
 * @author ranger
 * @version $Id: $
 * @since 1.8.1
 */
public class NodeNameLikeFilter extends Object implements Filter {
    /** Constant <code>TYPE="nodenamelike"</code> */
    public static final String TYPE = "nodenamelike";

    protected String substring;

    /**
     * <p>Constructor for NodeNameLikeFilter.</p>
     *
     * @param substring a {@link java.lang.String} object.
     */
    public NodeNameLikeFilter(String substring) {
        if (substring == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }

        this.substring = substring;
    }

    /**
     * <p>getSql</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSql() {
        return (" VULNERABILITYID IN (SELECT VULNERABILITYID FROM VULNERABILITIES JOIN NODE ON VULNERABILITIES.NODEID=NODE.NODEID WHERE UPPER(NODE.NODELABEL) LIKE '%" + this.substring.toUpperCase() + "%')");
        // return (" NODE.NODEID=VULNERABILITIES.NODEID AND UPPER(NODE.NODELABEL) LIKE '%" + this.substring.toUpperCase() + "%'");
    }
    
    /**
     * <p>getParamSql</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getParamSql() {
        return (" VULNERABILITYID IN (SELECT VULNERABILITYID FROM VULNERABILITIES JOIN NODE ON (VULNERABILITIES.NODEID=NODE.NODEID) WHERE UPPER(NODE.NODELABEL) LIKE ?)");
        // return (" NODE.NODEID=VULNERABILITIES.NODEID AND UPPER(NODE.NODELABEL) LIKE '%" + this.substring.toUpperCase() + "%'");
    }
    
    /** {@inheritDoc} */
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
    	ps.setString(parameterIndex, this.substring.toUpperCase());
    	return 1;
    }

    /**
     * <p>getDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getDescription() {
        return (TYPE + "=" + this.substring);
    }

    /**
     * <p>getTextDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getTextDescription() {
        return ("node name contains \"" + this.substring + "\"");
    }

    /**
     * <p>toString</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return ("<Vulnerability Node Name Containing Filter: " + this.getDescription() + ">");
    }

    /**
     * <p>Getter for the field <code>substring</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSubstring() {
        return (this.substring);
    }

    /** {@inheritDoc} */
    public boolean equals(Object obj) {
        return (this.toString().equals(obj.toString()));
    }
}
