/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2006-2011 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2011 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Encapsulates all interface filtering functionality.
 *
 * @deprecated This filter is not IPv6 compatible.
 *
 * @author ranger
 * @version $Id: $
 * @since 1.8.1
 */
public class NegativeInterfaceFilter extends Object implements Filter {
    /** Constant <code>TYPE="interfacenot"</code> */
    public static final String TYPE = "interfacenot";

    protected String ipAddress;

    /**
     * <p>Constructor for NegativeInterfaceFilter.</p>
     *
     * @param ipAddress a {@link java.lang.String} object.
     */
    public NegativeInterfaceFilter(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }

        this.ipAddress = ipAddress;
    }

    /**
     * <p>getSql</p>
     *
     * @deprecated This function will produce invalid SQL for some IPv6 addresses.
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSql() {
        return (" (IPADDR<>'" + this.ipAddress + "' OR IPADDR IS NULL)");
    }
    
    /**
     * <p>getParamSql</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getParamSql() {
        return (" (IPADDR<>? OR IPADDR IS NULL)");
    }
    
    /** {@inheritDoc} */
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
    	ps.setString(parameterIndex, this.ipAddress);
    	return 1;
    }

    /**
     * <p>getDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getDescription() {
        return (TYPE + "=" + this.ipAddress);
    }

    /**
     * <p>getTextDescription</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getTextDescription() {
        return ("IP address is not " + this.ipAddress);
    }

    /**
     * <p>toString</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return ("<Vulnerability Negative Interface Filter: " + this.getDescription() + ">");
    }

    /**
     * <p>Getter for the field <code>ipAddress</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getIpAddress() {
        return (this.ipAddress);
    }

    /** {@inheritDoc} */
    public boolean equals(Object obj) {
        return (this.toString().equals(obj.toString()));
    }
}
