/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.web.api.Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="whoamiRestService")
@Path(value="whoami")
public class WhoamiRestService {
    @Autowired
    private UserManager userManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response whoami(@Context SecurityContext securityContext) {
        String userName = securityContext.getUserPrincipal().getName();
        JSONArray userRoles = new JSONArray();
        for (String eachRole : Authentication.getAvailableRoles()) {
            if (!securityContext.isUserInRole(eachRole)) continue;
            userRoles.put((Object)eachRole);
        }
        JSONObject userInfo = new JSONObject();
        userInfo.put("id", (Object)userName);
        userInfo.put("roles", (Object)userRoles);
        userInfo.put("internal", false);
        try {
            OnmsUser onmsUser = this.userManager.getOnmsUser(userName);
            if (onmsUser != null) {
                userInfo.put("internal", true);
                if (!Strings.isNullOrEmpty((String)onmsUser.getEmail())) {
                    userInfo.put("email", (Object)onmsUser.getEmail());
                }
                if (!Strings.isNullOrEmpty((String)onmsUser.getFullName())) {
                    userInfo.put("fullName", (Object)onmsUser.getFullName());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Response.ok().entity((Object)userInfo.toString()).build();
    }
}

