/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsLocationAvailDataPoint;
import org.opennms.netmgt.model.OnmsLocationAvailDefinition;
import org.opennms.netmgt.model.OnmsLocationAvailDefinitionList;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.web.rest.v1.AvailCalculator;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.support.OnmsMonitoringLocationDefinitionList;
import org.opennms.web.rest.v1.support.TimeChunker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="remotePollerAvailabilityService")
@Path(value="remotelocations")
@Transactional
public class RemotePollerAvailabilityService
extends OnmsRestService {
    @Autowired
    MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    LocationMonitorDao m_locationMonitorDao;
    @Autowired
    ApplicationDao m_applicationDao;
    @Autowired
    MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    TransactionTemplate m_transactionTemplate;
    OnmsLocationAvailDefinitionList m_defList = null;
    private Timer m_timer = null;

    protected static TimeChunker getTimeChunkerFromMidnight() {
        Calendar calendar = Calendar.getInstance();
        Date startTime = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0).getTime();
        return new TimeChunker(300000L, startTime, new Date(System.currentTimeMillis()));
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public OnmsMonitoringLocationDefinitionList getRemoteLocationList() {
        List monitors = this.m_monitoringLocationDao.findAll();
        return new OnmsMonitoringLocationDefinitionList(monitors);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="participants")
    public String getParticipants() {
        List nodes = this.m_nodeDao.findAll();
        StringBuilder retVal = new StringBuilder();
        retVal.append("{\"participants\":[");
        for (int i = 0; i < nodes.size(); ++i) {
            OnmsNode node = (OnmsNode)nodes.get(i);
            if (i == 0) {
                retVal.append("{\"name\":\"" + node.getLabel() + "\"}");
                continue;
            }
            retVal.append(",{\"name\":\"" + node.getLabel() + "\"}");
        }
        retVal.append("]}");
        return retVal.toString();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="availability")
    public OnmsLocationAvailDefinitionList getAvailability(@Context UriInfo uriInfo) throws InterruptedException {
        if (this.m_timer == null) {
            MultivaluedMap queryParameters = uriInfo.getQueryParameters();
            this.m_defList = this.getAvailabilityList(RemotePollerAvailabilityService.createTimeChunker((MultivaluedMap<String, String>)queryParameters), this.getSortedApplications(), null, this.getSelectedNodes((MultivaluedMap<String, String>)queryParameters));
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    RemotePollerAvailabilityService.this.m_defList = (OnmsLocationAvailDefinitionList)RemotePollerAvailabilityService.this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<OnmsLocationAvailDefinitionList>(){

                        public OnmsLocationAvailDefinitionList doInTransaction(TransactionStatus status) {
                            return RemotePollerAvailabilityService.this.getAvailabilityList(RemotePollerAvailabilityService.getTimeChunkerFromMidnight(), RemotePollerAvailabilityService.this.getSortedApplications(), null, null);
                        }
                    });
                }
            };
            this.m_timer = new Timer("AvailCalculator-Timer");
            this.m_timer.scheduleAtFixedRate(task, 300000L, 300000L);
        }
        return this.m_defList;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="availability/{location}")
    public OnmsLocationAvailDefinitionList getAvailabilityByLocation(@Context UriInfo uriInfo, @PathParam(value="location") String location) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        OnmsMonitoringLocation locationDefinition = (OnmsMonitoringLocation)this.m_monitoringLocationDao.get((Serializable)((Object)location));
        if (locationDefinition == null) {
            throw RemotePollerAvailabilityService.getException(Response.Status.BAD_REQUEST, "Cannot find location definition: {}", location);
        }
        Collection monitors = this.m_locationMonitorDao.findByLocationDefinition(locationDefinition);
        OnmsLocationAvailDefinitionList availList = this.getAvailabilityList(RemotePollerAvailabilityService.createTimeChunker((MultivaluedMap<String, String>)queryParameters), this.getSortedApplications(), monitors, null);
        return availList;
    }

    private OnmsLocationAvailDefinitionList getAvailabilityList(TimeChunker timeChunker, List<OnmsApplication> sortedApplications, Collection<OnmsLocationMonitor> selectedMonitors, Collection<OnmsNode> selectedNodes) {
        OnmsLocationAvailDefinitionList availList = new OnmsLocationAvailDefinitionList();
        ArrayList<String> names = new ArrayList<String>(sortedApplications.size());
        for (OnmsApplication app : sortedApplications) {
            names.add(app.getName());
        }
        Collection statusesPeriod = this.m_locationMonitorDao.getStatusChangesBetweenForApplications(timeChunker.getStartDate(), timeChunker.getEndDate(), names);
        AvailCalculator availCalc = new AvailCalculator(timeChunker);
        RemotePollerAvailabilityService.removeUnneededMonitors(statusesPeriod, selectedMonitors);
        RemotePollerAvailabilityService.removeUnneededServices(statusesPeriod, selectedNodes);
        for (OnmsLocationSpecificStatus statusChange : statusesPeriod) {
            availCalc.onStatusChange(statusChange);
        }
        int counter = 0;
        for (int i = 0; i < timeChunker.getSegmentCount(); ++i) {
            ++counter;
            TimeChunker.TimeChunk timeChunk = timeChunker.getAt(i);
            OnmsLocationAvailDataPoint point = new OnmsLocationAvailDataPoint();
            point.setTime(timeChunk.getEndDate());
            for (OnmsApplication application : sortedApplications) {
                double percentage = availCalc.getAvailabilityFor(this.m_monitoredServiceDao.findByApplication(application), i);
                String strPercent = new DecimalFormat("0.0").format(percentage * 100.0);
                point.addAvailDefinition(new OnmsLocationAvailDefinition(application.getName(), strPercent));
            }
            availList.add((Object)point);
        }
        System.err.println(new Date() + "After Calculations total loops: " + counter);
        return availList;
    }

    private static void removeUnneededServices(Collection<OnmsLocationSpecificStatus> statusesPeriod, Collection<OnmsNode> selectedNodes) {
        if (selectedNodes != null) {
            ArrayList<OnmsLocationSpecificStatus> unneededStatuses = new ArrayList<OnmsLocationSpecificStatus>();
            for (OnmsLocationSpecificStatus status : statusesPeriod) {
                for (OnmsNode node : selectedNodes) {
                    if (status.getMonitoredService().getNodeId() != node.getId()) continue;
                    unneededStatuses.add(status);
                }
            }
            statusesPeriod.removeAll(unneededStatuses);
        }
    }

    private static void removeUnneededMonitors(Collection<OnmsLocationSpecificStatus> statusesPeriod, Collection<OnmsLocationMonitor> selectedMonitors) {
        if (selectedMonitors != null) {
            ArrayList<OnmsLocationSpecificStatus> unneededStatuses = new ArrayList<OnmsLocationSpecificStatus>();
            for (OnmsLocationSpecificStatus status : statusesPeriod) {
                for (OnmsLocationMonitor monitor : selectedMonitors) {
                    if (status.getLocationMonitor().getId() != monitor.getId()) continue;
                    unneededStatuses.add(status);
                }
            }
            statusesPeriod.removeAll(unneededStatuses);
        }
    }

    private static int getResolution(MultivaluedMap<String, String> params) {
        if (params.containsKey((Object)"resolution")) {
            String resolution = (String)params.getFirst((Object)"resolution");
            if (resolution.equalsIgnoreCase("minute")) {
                return 300000;
            }
            if (resolution.equalsIgnoreCase("hourly")) {
                return 3600000;
            }
            if (resolution.equalsIgnoreCase("daily")) {
                return 86400000;
            }
            return 300000;
        }
        return 300000;
    }

    private static Date getEndTime(MultivaluedMap<String, String> params) {
        if (params.containsKey((Object)"endTime")) {
            String value = (String)params.getFirst((Object)"endTime");
            return new Date(Long.valueOf(value));
        }
        return new Date();
    }

    private static Date getStartTime(MultivaluedMap<String, String> params) {
        if (params.containsKey((Object)"startTime")) {
            String startTime = (String)params.getFirst((Object)"startTime");
            return new Date(Long.valueOf(startTime));
        }
        Calendar calendar = Calendar.getInstance();
        GregorianCalendar previousMidnight = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0);
        if (calendar.getTimeInMillis() - previousMidnight.getTimeInMillis() <= 300000L) {
            ((Calendar)previousMidnight).add(5, -1);
        }
        return previousMidnight.getTime();
    }

    private Collection<OnmsNode> getSelectedNodes(MultivaluedMap<String, String> queryParameters) {
        if (queryParameters.containsKey((Object)"host")) {
            String nodeLabel = (String)queryParameters.getFirst((Object)"host");
            return this.m_nodeDao.findByLabel(nodeLabel);
        }
        return null;
    }

    private static TimeChunker createTimeChunker(MultivaluedMap<String, String> params) {
        Date start = RemotePollerAvailabilityService.getStartTime(params);
        Date end = RemotePollerAvailabilityService.getEndTime(params);
        if (end.getTime() - start.getTime() < 300000L) {
            throw RemotePollerAvailabilityService.getException(Response.Status.BAD_REQUEST, "The endTime has to be after the startTime by 5 minutes.\nCurrently the startTime is {} and endTime is {}.", start.toString(), end.toString());
        }
        TimeChunker timeChunker = new TimeChunker(RemotePollerAvailabilityService.getResolution(params), start, end);
        return timeChunker;
    }

    private List<OnmsApplication> getSortedApplications() {
        List applications = this.m_applicationDao.findAll();
        if (applications.size() == 0) {
            throw RemotePollerAvailabilityService.getException(Response.Status.BAD_REQUEST, "there are no applications", new String[0]);
        }
        ArrayList<OnmsApplication> sortedApplications = new ArrayList<OnmsApplication>(applications);
        Collections.sort(sortedApplications);
        return sortedApplications;
    }
}

