/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.mapper.v2.EventMapper;
import org.opennms.web.rest.model.v2.EventCollectionDTO;
import org.opennms.web.rest.model.v2.EventDTO;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.IpLikeCriteriaBehavior;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestServiceWithDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="events")
@Transactional
public class EventRestService
extends AbstractDaoRestServiceWithDTO<OnmsEvent, EventDTO, SearchBean, Integer, Integer> {
    @Autowired
    private EventDao m_dao;
    @Autowired
    private EventMapper m_eventMapper;

    protected EventDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsEvent> getDaoClass() {
        return OnmsEvent.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass(), Aliases.event.toString());
        builder.alias("alarm", Aliases.alarm.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("distPoller", Aliases.distPoller.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("ipInterfaces"), Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.ipInterface.prop("ipAddress"), (Object)Aliases.event.prop("ipAddr")), Restrictions.isNull((String)Aliases.ipInterface.prop("ipAddress"))}));
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("snmpInterfaces"), Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.snmpInterface.prop("ifIndex"), (Object)Aliases.event.prop("ifIndex")), Restrictions.isNull((String)Aliases.snmpInterface.prop("ifIndex"))}));
        builder.orderBy("eventTime").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<EventDTO> createListWrapper(Collection<EventDTO> list) {
        return new EventCollectionDTO(list);
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.EVENT_SERVICE_PROPERTIES;
    }

    @Override
    protected Map<String, String> getSearchBeanPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("event.uei", "event.eventUei");
        return map;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.EVENT_BEHAVIORS);
        map.put("ipAddr", new IpLikeCriteriaBehavior("ipAddr"));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.event, CriteriaBehaviors.EVENT_BEHAVIORS));
        map.put(Aliases.event.prop("ipAddr"), new IpLikeCriteriaBehavior("ipAddr"));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.alarm, CriteriaBehaviors.ALARM_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.distPoller, CriteriaBehaviors.DIST_POLLER_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.eventParameter, CriteriaBehaviors.EVENT_PARAMETER_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.node, CriteriaBehaviors.NODE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.serviceType, CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.assetRecord, CriteriaBehaviors.ASSET_RECORD_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.ipInterface, CriteriaBehaviors.IP_INTERFACE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.location, CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.category, CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.snmpInterface, CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS));
        return map;
    }

    @Override
    protected OnmsEvent doGet(UriInfo uriInfo, Integer id) {
        return (OnmsEvent)this.getDao().get((Serializable)id);
    }

    @POST
    @Path(value="{tiebreaker: $}")
    @Consumes(value={"application/json", "application/xml"})
    public Response create(Event event) {
        if (event.getTime() == null) {
            event.setTime(new Date());
        }
        if (event.getSource() == null) {
            event.setSource("ReST");
        }
        this.sendEvent(event);
        return Response.noContent().build();
    }

    @Override
    public EventDTO mapEntityToDTO(OnmsEvent entity) {
        return this.m_eventMapper.eventToEventDTO(entity);
    }

    @Override
    public OnmsEvent mapDTOToEntity(EventDTO dto) {
        return this.m_eventMapper.eventDTOToEvent(dto);
    }
}

