/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v1.support.OnmsApplicationList;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="applications")
@Transactional
public class ApplicationRestService
extends AbstractDaoRestService<OnmsApplication, OnmsApplication, Integer, Integer> {
    @Autowired
    private ApplicationDao m_dao;

    protected ApplicationDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsApplication> getDaoClass() {
        return OnmsApplication.class;
    }

    @Override
    protected Class<OnmsApplication> getQueryBeanClass() {
        return OnmsApplication.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsApplication.class);
        builder.orderBy("name").asc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsApplication> createListWrapper(Collection<OnmsApplication> list) {
        return new OnmsApplicationList(list);
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.APPLICATION_SERVICE_PROPERTIES;
    }

    @Override
    protected OnmsApplication doGet(UriInfo uriInfo, Integer id) {
        return (OnmsApplication)this.getDao().get((Serializable)id);
    }

    @Override
    public Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsApplication object) {
        Integer id = (Integer)this.getDao().save((Object)object);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, id)).build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsApplication object) {
        this.getDao().delete((Object)object);
    }
}

