/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.text.ParseException;
import java.time.ZoneId;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.timeformat.api.TimeformatService;
import org.opennms.web.rest.v1.InfoDTO;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.config.DatetimeformatConfig;
import org.opennms.web.rest.v1.config.TicketerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="infoRestService")
@Path(value="info")
@Transactional
public class InfoRestService
extends OnmsRestService {
    @Autowired
    TimeformatService timeformatService;

    @GET
    @Produces(value={"application/json"})
    public Response getInfo(@Context HttpServletRequest httpServletRequest) throws ParseException {
        SystemInfoUtils sysInfoUtils = new SystemInfoUtils();
        InfoDTO info = new InfoDTO();
        info.setDisplayVersion(sysInfoUtils.getDisplayVersion());
        info.setVersion(sysInfoUtils.getVersion());
        info.setPackageName(sysInfoUtils.getPackageName());
        info.setPackageDescription(sysInfoUtils.getPackageDescription());
        info.setTicketerConfig(this.getTicketerConfig());
        info.setDatetimeformatConfig(this.getDateformatConfig(httpServletRequest.getSession(false)));
        return Response.ok().entity((Object)info).build();
    }

    private DatetimeformatConfig getDateformatConfig(HttpSession session) {
        DatetimeformatConfig config = new DatetimeformatConfig();
        config.setZoneId(this.extractUserTimeZoneId(session));
        config.setDatetimeformat(this.timeformatService.getFormatPattern());
        return config;
    }

    private ZoneId extractUserTimeZoneId(HttpSession session) {
        ZoneId zoneId = null;
        if (session != null) {
            zoneId = (ZoneId)session.getAttribute("org.opennms.ui.timezoneid");
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return zoneId;
    }

    private TicketerConfig getTicketerConfig() {
        TicketerConfig ticketerConfig = new TicketerConfig();
        ticketerConfig.setEnabled("true".equalsIgnoreCase(Vault.getProperty((String)"opennms.alarmTroubleTicketEnabled")));
        if (ticketerConfig.isEnabled()) {
            ticketerConfig.setPlugin(System.getProperty("opennms.ticketer.plugin"));
        }
        return ticketerConfig;
    }
}

