/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsOutageCollection;
import org.opennms.netmgt.model.outage.OutageSummaryCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="outageRestService")
@Path(value="outages")
public class OutageRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OutageRestService.class);
    @Autowired
    private OutageDao m_outageDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{outageId}")
    @Transactional
    public Response getOutage(@Context UriInfo uriInfo, @PathParam(value="outageId") String outageId) {
        if ("summaries".equals(outageId)) {
            List collection;
            MultivaluedMap parms = uriInfo.getQueryParameters(true);
            int limit = 10;
            if (parms.containsKey((Object)"limit")) {
                limit = Integer.parseInt((String)parms.getFirst((Object)"limit"));
            }
            return (collection = this.m_outageDao.getNodeOutageSummaries(limit)) == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)new OutageSummaryCollection((Collection)collection)).build();
        }
        OnmsOutage outage = (OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(outageId));
        return outage == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)outage).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_outageDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsOutageCollection getOutages(@Context UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class);
        builder.alias("monitoredService", "monitoredService", Alias.JoinType.LEFT_JOIN);
        builder.alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.node.location", "location", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterface.snmpInterface", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("monitoredService.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceLostEvent", "serviceLostEvent", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceRegainedEvent", "serviceRegainedEvent", Alias.JoinType.LEFT_JOIN);
        OutageRestService.applyQueryFilters((MultivaluedMap<String, String>)uriInfo.getQueryParameters(), builder);
        OnmsOutageCollection coll = new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_outageDao.countMatching(builder.count().toCriteria())));
        return coll;
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Path(value="forNode/{nodeId}")
    public OnmsOutageCollection forNodeId(@Context UriInfo uriInfo, @PathParam(value="nodeId") int nodeId, @DefaultValue(value="604800000") @QueryParam(value="dateRange") long dateRange, @QueryParam(value="start") Long startTs, @QueryParam(value="end") Long endTs) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class);
        builder.eq("node.id", (Object)nodeId);
        builder.alias("monitoredService", "monitoredService");
        builder.alias("monitoredService.ipInterface", "ipInterface");
        builder.alias("monitoredService.ipInterface.node", "node");
        builder.alias("monitoredService.serviceType", "serviceType");
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putAll((Map)uriInfo.getQueryParameters());
        LOG.debug("Processing outages for node {} using {}", (Object)nodeId, (Object)params);
        if (startTs != null && endTs != null) {
            params.remove("start");
            params.remove("end");
            Date start = new Date(startTs);
            Date end = new Date(endTs);
            LOG.debug("Getting all outages from {} to {} for node {}", new Object[]{start, end, nodeId});
            builder.or(new Restriction[]{Restrictions.isNull((String)"ifRegainedService"), Restrictions.and((Restriction[])new Restriction[]{Restrictions.gt((String)"ifLostService", (Object)start), Restrictions.lt((String)"ifLostService", (Object)end)})});
        } else {
            params.remove("dateRange");
            Date start = new Date(System.currentTimeMillis() - dateRange);
            LOG.debug("Getting all outgae from {} to current date for node {}", (Object)start, (Object)nodeId);
            builder.or(new Restriction[]{Restrictions.isNull((String)"ifRegainedService"), Restrictions.gt((String)"ifLostService", (Object)start)});
        }
        OutageRestService.applyQueryFilters(params, builder);
        builder.orderBy("id").desc();
        return new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(builder.toCriteria()));
    }
}

