/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.discovery.DiscoveryTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="discovery")
@Transactional
public class DiscoveryRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryRestService.class);
    @Autowired
    ServiceRegistry serviceRegistry;

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response scan(DiscoveryConfigurationDTO discoveryConfigurationDTO) {
        DiscoveryConfiguration discoveryConfiguration = this.getDiscoveryConfig(discoveryConfigurationDTO);
        DiscoveryTaskExecutor discoveryTaskExecutor = (DiscoveryTaskExecutor)this.serviceRegistry.findProvider(DiscoveryTaskExecutor.class);
        if (discoveryTaskExecutor == null) {
            LOG.warn("No DiscoveryTaskExecutor service is available");
            return Response.serverError().build();
        }
        discoveryTaskExecutor.handleDiscoveryTask(discoveryConfiguration);
        return Response.ok().build();
    }

    private DiscoveryConfiguration getDiscoveryConfig(DiscoveryConfigurationDTO discoveryConfigurationDTO) {
        DiscoveryConfiguration discoveryConfiguration = new DiscoveryConfiguration();
        discoveryConfiguration.setTimeout(discoveryConfigurationDTO.getTimeout());
        discoveryConfiguration.setRetries(discoveryConfigurationDTO.getRetries());
        discoveryConfiguration.setForeignSource(discoveryConfigurationDTO.getForeignSource());
        discoveryConfiguration.setLocation(discoveryConfigurationDTO.getLocation());
        discoveryConfiguration.setChunkSize(discoveryConfigurationDTO.getChunkSize());
        for (DiscoveryConfigurationDTO.SpecificDTO specificDTO : discoveryConfigurationDTO.getSpecificDTOList()) {
            Specific specific = new Specific();
            specific.setAddress(specificDTO.getContent());
            specific.setTimeout(specificDTO.getTimeout());
            specific.setRetries(specificDTO.getRetries());
            specific.setForeignSource(specificDTO.getForeignSource());
            specific.setLocation(specificDTO.getLocation());
            discoveryConfiguration.addSpecific(specific);
        }
        for (DiscoveryConfigurationDTO.IncludeUrlDTO includeUrlDTO : discoveryConfigurationDTO.getIncludeUrlDTOList()) {
            IncludeUrl includeUrl = new IncludeUrl();
            includeUrl.setUrl(includeUrlDTO.getContent());
            includeUrl.setTimeout(includeUrlDTO.getTimeout());
            includeUrl.setRetries(includeUrlDTO.getRetries());
            includeUrl.setForeignSource(includeUrlDTO.getForeignSource());
            includeUrl.setLocation(includeUrlDTO.getLocation());
            discoveryConfiguration.addIncludeUrl(includeUrl);
        }
        for (DiscoveryConfigurationDTO.IncludeRangeDTO includeRangeDTO : discoveryConfigurationDTO.getIncludeRangeDTOList()) {
            IncludeRange includeRange = new IncludeRange();
            includeRange.setBegin(includeRangeDTO.getBegin());
            includeRange.setEnd(includeRangeDTO.getEnd());
            includeRange.setTimeout(includeRangeDTO.getTimeout());
            includeRange.setRetries(includeRangeDTO.getRetries());
            includeRange.setForeignSource(includeRangeDTO.getForeignSource());
            includeRange.setLocation(includeRangeDTO.getLocation());
            discoveryConfiguration.addIncludeRange(includeRange);
        }
        for (DiscoveryConfigurationDTO.ExcludeRangeDTO excludeRangeDTO : discoveryConfigurationDTO.getExcludeRangeDTOList()) {
            ExcludeRange excludeRange = new ExcludeRange();
            excludeRange.setBegin(excludeRangeDTO.getBegin());
            excludeRange.setEnd(excludeRangeDTO.getEnd());
            discoveryConfiguration.addExcludeRange(excludeRange);
        }
        return discoveryConfiguration;
    }

    @XmlRootElement(name="discoveryConfiguration")
    public static class DiscoveryConfigurationDTO {
        private String location = "Default";
        private Integer retries = 1;
        private Long timeout = 2000L;
        private String foreignSource;
        private Integer chunkSize = 100;
        private List<SpecificDTO> specificDTOList = new ArrayList<SpecificDTO>();
        private List<IncludeRangeDTO> includeRangeDTOList = new ArrayList<IncludeRangeDTO>();
        private List<ExcludeRangeDTO> excludeRangeDTOList = new ArrayList<ExcludeRangeDTO>();
        private List<IncludeUrlDTO> includeUrlDTOList = new ArrayList<IncludeUrlDTO>();

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Long timeout) {
            this.timeout = timeout;
        }

        public String getForeignSource() {
            return this.foreignSource;
        }

        public void setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
        }

        public Integer getChunkSize() {
            return this.chunkSize;
        }

        public void setChunkSize(Integer chunkSize) {
            this.chunkSize = chunkSize;
        }

        @XmlElementWrapper(name="specifics")
        @XmlElement(name="specific")
        public List<SpecificDTO> getSpecificDTOList() {
            return this.specificDTOList;
        }

        public void setSpecificDTOList(List<SpecificDTO> specificDTOList) {
            this.specificDTOList = specificDTOList;
        }

        @XmlElementWrapper(name="includeRanges")
        @XmlElement(name="includeRange")
        public List<IncludeRangeDTO> getIncludeRangeDTOList() {
            return this.includeRangeDTOList;
        }

        public void setIncludeRangeDTOList(List<IncludeRangeDTO> includeRangeDTOList) {
            this.includeRangeDTOList = includeRangeDTOList;
        }

        @XmlElementWrapper(name="excludeRanges")
        @XmlElement(name="excludeRange")
        public List<ExcludeRangeDTO> getExcludeRangeDTOList() {
            return this.excludeRangeDTOList;
        }

        public void setExcludeRangeDTOList(List<ExcludeRangeDTO> excludeRangeDTOList) {
            this.excludeRangeDTOList = excludeRangeDTOList;
        }

        @XmlElementWrapper(name="includeUrls")
        @XmlElement(name="includeUrl")
        public List<IncludeUrlDTO> getIncludeUrlDTOList() {
            return this.includeUrlDTOList;
        }

        public void setIncludeUrlDTOList(List<IncludeUrlDTO> includeUrlDTOList) {
            this.includeUrlDTOList = includeUrlDTOList;
        }

        @XmlRootElement
        public static class IncludeUrlDTO {
            private String content;
            private String location = "Default";
            private Integer retries = 1;
            private Long timeout = 2000L;
            private String foreignSource;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public String getLocation() {
                return this.location;
            }

            public void setLocation(String location) {
                this.location = location;
            }

            public Integer getRetries() {
                return this.retries;
            }

            public void setRetries(Integer retries) {
                this.retries = retries;
            }

            public Long getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Long timeout) {
                this.timeout = timeout;
            }

            public String getForeignSource() {
                return this.foreignSource;
            }

            public void setForeignSource(String foreignSource) {
                this.foreignSource = foreignSource;
            }
        }

        @XmlRootElement
        public static class ExcludeRangeDTO {
            private String begin;
            private String end;

            public String getBegin() {
                return this.begin;
            }

            public void setBegin(String begin) {
                this.begin = begin;
            }

            public String getEnd() {
                return this.end;
            }

            public void setEnd(String end) {
                this.end = end;
            }
        }

        @XmlRootElement
        public static class IncludeRangeDTO {
            private String location = "Default";
            private Integer retries = 1;
            private Long timeout = 2000L;
            private String foreignSource;
            private String begin;
            private String end;

            public String getLocation() {
                return this.location;
            }

            public void setLocation(String location) {
                this.location = location;
            }

            public Integer getRetries() {
                return this.retries;
            }

            public void setRetries(Integer retries) {
                this.retries = retries;
            }

            public Long getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Long timeout) {
                this.timeout = timeout;
            }

            public String getForeignSource() {
                return this.foreignSource;
            }

            public void setForeignSource(String foreignSource) {
                this.foreignSource = foreignSource;
            }

            public String getBegin() {
                return this.begin;
            }

            public void setBegin(String begin) {
                this.begin = begin;
            }

            public String getEnd() {
                return this.end;
            }

            public void setEnd(String end) {
                this.end = end;
            }
        }

        @XmlRootElement
        public static class SpecificDTO {
            private String content;
            private String location;
            private Integer retries;
            private Long timeout;
            private String foreignSource;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public String getLocation() {
                return this.location;
            }

            public void setLocation(String location) {
                this.location = location;
            }

            public Integer getRetries() {
                return this.retries;
            }

            public void setRetries(Integer retries) {
                this.retries = retries;
            }

            public Long getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Long timeout) {
                this.timeout = timeout;
            }

            public String getForeignSource() {
                return this.foreignSource;
            }

            public void setForeignSource(String foreignSource) {
                this.foreignSource = foreignSource;
            }
        }
    }
}

