/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.text.ParseException;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.api.RequisitionAccessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="requisitionNamesRestService")
@Path(value="requisitionNames")
public class RequisitionNamesRestService
extends OnmsRestService {
    @Autowired
    private RequisitionAccessService m_accessService;

    @PreDestroy
    protected void tearDown() {
        if (this.m_accessService != null) {
            this.m_accessService.flushAll();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionCollection getRequisitionNames() throws ParseException {
        RequisitionCollection names = new RequisitionCollection();
        this.m_accessService.getRequisitions().forEach(r -> names.add(r.getForeignSource()));
        return names;
    }

    @XmlRootElement(name="foreign-sources")
    public static class RequisitionCollection
    extends JaxbListWrapper<String> {
        @XmlElement(name="foreign-source")
        public List<String> getNames() {
            return this.getObjects();
        }
    }
}

