/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.AssetRecordResource;
import org.opennms.web.rest.v1.HardwareInventoryResource;
import org.opennms.web.rest.v1.OnmsIpInterfaceResource;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.OnmsSnmpInterfaceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="nodeRestService")
@Path(value="nodes")
@Transactional
public class NodeRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestService.class);
    @Autowired
    private MonitoringLocationDao m_locationDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsNodeList getNodes(@Context UriInfo uriInfo) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        String type = (String)params.getFirst((Object)"type");
        CriteriaBuilder builder = NodeRestService.getCriteriaBuilder((MultivaluedMap<String, String>)params);
        Criteria crit = null;
        if (params.size() == 1 && params.getFirst((Object)"nodeId") != null && ((String)params.getFirst((Object)"nodeId")).contains(",")) {
            ArrayList<Integer> nodeIds = new ArrayList<Integer>();
            for (String id : ((String)params.getFirst((Object)"nodeId")).split(",")) {
                nodeIds.add(Integer.valueOf(id));
            }
            crit = NodeRestService.filterForNodeIds(builder, nodeIds).toCriteria();
        } else if (params.getFirst((Object)"filterRule") != null) {
            Set<Integer> filteredNodeIds = this.m_filterDao.getNodeMap((String)params.getFirst((Object)"filterRule")).keySet();
            if (filteredNodeIds.size() < 1) {
                OnmsNodeList coll = new OnmsNodeList(Collections.emptyList());
                coll.setTotalCount(Integer.valueOf(0));
                return coll;
            }
            params.remove((Object)"filterRule");
            CriteriaBuilder filterRuleCriteriaBuilder = NodeRestService.getCriteriaBuilder((MultivaluedMap<String, String>)params);
            crit = NodeRestService.filterForNodeIds(filterRuleCriteriaBuilder, filteredNodeIds).toCriteria();
        } else {
            NodeRestService.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
            builder.orderBy("label").asc();
            crit = builder.toCriteria();
            if (type == null) {
                ArrayList<Restriction> restrictions = new ArrayList<Restriction>(crit.getRestrictions());
                restrictions.add(Restrictions.ne((String)"type", (Object)"D"));
                crit.setRestrictions(restrictions);
            }
        }
        OnmsNodeList coll = new OnmsNodeList((Collection)this.m_nodeDao.findMatching(crit));
        crit.setLimit(null);
        crit.setOffset(null);
        crit.setOrders(new ArrayList());
        coll.setTotalCount(Integer.valueOf(this.m_nodeDao.countMatching(crit)));
        return coll;
    }

    private static CriteriaBuilder filterForNodeIds(CriteriaBuilder builder, Collection<Integer> nodeIds) {
        return builder.ne("type", (Object)"D").in("id", nodeIds).distinct();
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{nodeCriteria}")
    public OnmsNode getNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.NOT_FOUND, "Node {} was not found.", nodeCriteria);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addNode(@Context UriInfo uriInfo, OnmsNode node) {
        this.writeLock();
        try {
            if (node.getLocation() == null) {
                OnmsMonitoringLocation location = this.m_locationDao.getDefaultLocation();
                LOG.debug("addNode: Assigning new node to default location: {}", (Object)location.getLocationName());
                node.setLocation(location);
            }
            if (node.getType() == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node type must be set.", new String[0]);
            }
            if (node.getAssetRecord() != null && node.getAssetRecord().getNode() == null) {
                node.getAssetRecord().setNode(node);
            }
            LOG.debug("addNode: Adding node {}", (Object)node);
            this.m_nodeDao.save((Object)node);
            this.sendEvent("uei.opennms.org/nodes/nodeAdded", node.getId(), node.getLabel());
            Response response = Response.created((URI)uriInfo.getRequestUriBuilder().path(node.getNodeId()).build(new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{nodeCriteria}")
    public Response updateNode(@PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            if (node.getAssetRecord().getGeolocation() == null) {
                node.getAssetRecord().setGeolocation(new OnmsGeolocation());
            }
            LOG.debug("updateNode: updating node {}", (Object)node);
            boolean modified = false;
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)node);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                LOG.debug("updateNode: node {} updated", (Object)node);
                this.m_nodeDao.saveOrUpdate((Object)node);
                response = Response.noContent().build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{nodeCriteria}")
    public Response deleteNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            LOG.debug("deleteNode: deleting node {}", (Object)nodeCriteria);
            Event e = EventUtils.createDeleteNodeEvent((String)"OpenNMS.REST", (long)node.getId().intValue(), (long)-1L);
            this.sendEvent(e);
            Response response = Response.accepted().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Path(value="{nodeCriteria}/ipinterfaces")
    public OnmsIpInterfaceResource getIpInterfaceResource(@Context ResourceContext context) {
        return (OnmsIpInterfaceResource)context.getResource(OnmsIpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/snmpinterfaces")
    public OnmsSnmpInterfaceResource getSnmpInterfaceResource(@Context ResourceContext context) {
        return (OnmsSnmpInterfaceResource)context.getResource(OnmsSnmpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/assetRecord")
    public AssetRecordResource getAssetRecordResource(@Context ResourceContext context) {
        return (AssetRecordResource)context.getResource(AssetRecordResource.class);
    }

    @Path(value="{nodeCriteria}/hardwareInventory")
    public HardwareInventoryResource getHardwareInventoryResource(@Context ResourceContext context) {
        return (HardwareInventoryResource)context.getResource(HardwareInventoryResource.class);
    }

    @GET
    @Path(value="/{nodeCriteria}/categories")
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection getCategoriesForNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
        }
        return new OnmsCategoryCollection((Collection)node.getCategories());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public OnmsCategory getCategoryForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
        }
        OnmsCategory cat = NodeRestService.getCategory(node, categoryName);
        if (cat == null) {
            throw NodeRestService.getException(Response.Status.NOT_FOUND, "Can't find category {} for node {}.", categoryName, nodeCriteria);
        }
        return cat;
    }

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/{nodeCriteria}/categories")
    public Response addCategoryToNode(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, OnmsCategory category) {
        if (category == null) {
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Category must not be null.", new String[0]);
        }
        return this.addCategoryToNode(uriInfo, nodeCriteria, category.getName());
    }

    @POST
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response addCategoryToNode(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsCategory found = this.m_categoryDao.findByName(categoryName);
            if (found == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Category {} was not found.", categoryName);
            }
            if (!node.getCategories().contains(found)) {
                LOG.debug("addCategory: Adding category {} to node {}", (Object)found, (Object)nodeCriteria);
                node.addCategory(found);
                this.m_nodeDao.save((Object)node);
                Response response = Response.created((URI)NodeRestService.getRedirectUri(uriInfo, categoryName)).build();
                return response;
            }
            throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Category '{}' already added to node '{}'", categoryName, nodeCriteria);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response updateCategoryForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsCategory category = NodeRestService.getCategory(node, categoryName);
            if (category == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Category {} not found on node {}", categoryName, nodeCriteria);
            }
            LOG.debug("updateCategory: updating category {}", (Object)category);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)category);
            boolean updated = false;
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                updated = true;
            }
            if (updated) {
                LOG.debug("updateCategory: category {} updated", (Object)category);
                this.m_categoryDao.saveOrUpdate((Object)category);
            } else {
                LOG.debug("updateCategory: no fields updated in category {}", (Object)category);
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{nodeCriteria}/categories/{categoryName}")
    public Response removeCategoryFromNode(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsCategory category = NodeRestService.getCategory(node, categoryName);
            if (category == null) {
                throw NodeRestService.getException(Response.Status.BAD_REQUEST, "Category {} not found on node {}", categoryName, nodeCriteria);
            }
            LOG.debug("deleteCaegory: deleting category {} from node {}", (Object)categoryName, (Object)nodeCriteria);
            node.getCategories().remove(category);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private static OnmsCategory getCategory(OnmsNode node, String categoryName) {
        for (OnmsCategory category : node.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }

    private void sendEvent(Event event) {
        try {
            this.m_eventProxy.send(event);
        }
        catch (EventProxyException e) {
            throw NodeRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Cannot send event {} : {}", event.getUei(), e.getMessage());
        }
    }

    private void sendEvent(String uei, int nodeId, String nodeLabel) {
        try {
            EventBuilder bldr = new EventBuilder(uei, "ReST");
            bldr.setNodeid((long)nodeId);
            bldr.addParam("nodelabel", nodeLabel);
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            throw NodeRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Cannot send event {} : {}", uei, e.getMessage());
        }
    }

    private static CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("categories", "category", Alias.JoinType.LEFT_JOIN);
        builder.alias("assetRecord", "assetRecord", Alias.JoinType.LEFT_JOIN);
        builder.alias("location", "location", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces.monitoredServices.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        NodeRestService.applyQueryFilters(params, builder);
        return builder;
    }
}

