/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ScanReportDao;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v1.support.ScanReportList;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="scanreports")
@Transactional
public class ScanReportRestService
extends AbstractDaoRestService<ScanReport, ScanReport, String, String> {
    @Autowired
    private ScanReportDao m_dao;

    protected ScanReportDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<ScanReport> getDaoClass() {
        return ScanReport.class;
    }

    @Override
    protected Class<ScanReport> getQueryBeanClass() {
        return ScanReport.class;
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(ScanReport.class);
        builder.orderBy("timestamp").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<ScanReport> createListWrapper(Collection<ScanReport> list) {
        return new ScanReportList(list);
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.SCAN_REPORT_SERVICE_PROPERTIES;
    }

    @GET
    @Path(value="{id}/logs")
    @Produces(value={"text/plain"})
    public Response getLogs(@PathParam(value="id") String id) {
        ScanReport report = (ScanReport)this.getDao().get((Serializable)((Object)id));
        if (report == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (report.getLog() == null || report.getLog().getLogText() == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)report.getLog().getLogText()).build();
    }

    @Override
    protected ScanReport doGet(UriInfo uriInfo, String id) {
        return (ScanReport)this.getDao().get((Serializable)((Object)id));
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, String key, ScanReport targetObject) {
        if (!key.equals(targetObject.getId())) {
            throw this.getException(Response.Status.BAD_REQUEST, "The ID of the object doesn't match the ID of the path: {} != {}", targetObject.getId(), key);
        }
        this.getDao().saveOrUpdate((Object)targetObject);
        return Response.noContent().build();
    }
}

