/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.support.SearchPropertyBuilder;

public abstract class SearchProperties {
    private static final Map<String, String> ONMS_SEVERITIES = Arrays.stream(OnmsSeverity.values()).collect(Collectors.toMap(s -> String.valueOf(s.getId()), OnmsSeverity::getLabel));
    static final SortedSet<SearchProperty> ALARM_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsAlarm.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsAlarm.class, "alarmAckTime", "Acknowledged Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "alarmAckUser", "Acknowledging User", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "alarmType", "Alarm Type", SearchProperty.SearchPropertyType.INTEGER, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(1), (Object)"Problem").put((Object)String.valueOf(2), (Object)"Resolution").build()), new SearchProperty(OnmsAlarm.class, "applicationDN", "Application DN", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "clearKey", "Clear Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "counter", "Event Counter", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsAlarm.class, "description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "firstAutomationTime", "First Automation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "firstEventTime", "First Event Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "ifIndex", "SNMP Interface Index", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsAlarm.class, null, "isSituation", null, "Is Situation", SearchProperty.SearchPropertyType.BOOLEAN, false, false, SearchProperty.TRUE_OR_FALSE_VALUES), new SearchPropertyBuilder().entityClass(OnmsAlarm.class).id("ipAddr").name("IP Address").type(SearchProperty.SearchPropertyType.IP_ADDRESS).iplike(true).build(), new SearchProperty(OnmsAlarm.class, "lastAutomationTime", "Last Automation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "lastEventTime", "Last Event Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "logMsg", "Log Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "managedObjectInstance", "Managed Object Instance", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "managedObjectType", "Managed Object Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "mouseOverText", "Mouseover Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "operInstruct", "Operator Instructions", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "ossPrimaryKey", "OSS Primary Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "qosAlarmState", "QoS Alarm State", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "reductionKey", "Reduction Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "severity", "Severity", SearchProperty.SearchPropertyType.INTEGER, ONMS_SEVERITIES), new SearchProperty(OnmsAlarm.class, "suppressedTime", "Suppressed Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "suppressedUntil", "Suppressed Until", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAlarm.class, "suppressedUser", "Suppressed User", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "uei", "UEI", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "x733AlarmType", "X.733 Alarm Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAlarm.class, "x733ProbableCause", "X.733 Probable Cause", SearchProperty.SearchPropertyType.INTEGER)));
    static final SortedSet<SearchProperty> APPLICATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsApplication.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsApplication.class, "name", "Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> ASSET_RECORD_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsAssetRecord.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsAssetRecord.class, "additionalhardware", "Additional Hardware", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "admin", "Admin", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "assetNumber", "Asset Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "autoenable", "Auto-enable", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "building", "Building", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "category", "Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "circuitId", "Circuit ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "comment", "Comment", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "connection", "Connection", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "cpu", "CPU", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "dateInstalled", "Date Installed", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "department", "Department", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "displayCategory", "Display Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "division", "Division", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "enable", "Enable", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "floor", "Floor", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd1", "HDD 1", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd2", "HDD 2", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd3", "HDD 3", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd4", "HDD 4", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd5", "HDD 5", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "hdd6", "HDD 6", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "inputpower", "Input Power", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "lastModifiedBy", "Last Modified By", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "lastModifiedDate", "Last Modified Date", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsAssetRecord.class, "lease", "Lease", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "leaseExpires", "Lease Expires", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "maintcontract", "Maintenance Contract", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "maintContractExpiration", "Maintenance Contract Expiration", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "managedObjectInstance", "Managed Object Instance", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "managedObjectType", "Managed Object Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "manufacturer", "Manufacturer", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "modelNumber", "Model Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "notifyCategory", "Notify Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "numpowersupplies", "Number of Power Supplies", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "operatingSystem", "Operating System", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "password", "Password", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "pollerCategory", "Poller Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "port", "Port", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "rack", "Rack", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "rackunitheight", "Rack Unit Height", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "ram", "RAM", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "region", "Region", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "room", "Room", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "serialNumber", "Serial Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "slot", "Slot", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "snmpcommunity", "SNMP Community", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "storagectrl", "Storage Controller", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "supportPhone", "Support Phone", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "thresholdCategory", "Threshold Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "username", "Username", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vendor", "Vendor", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vendorAssetNumber", "Vendor Asset Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vendorFax", "Vendor Fax", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vendorPhone", "Vendor Phone", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vmwareManagedEntityType", "VMware Managed Entity Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vmwareManagedObjectId", "VMware Managed Object ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vmwareManagementServer", "VMware Management Server", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vmwareState", "VMware State", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsAssetRecord.class, "vmwareTopologyInfo", "VMware Topology Information", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> CATEGORY_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsCategory.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsCategory.class, "description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsCategory.class, "name", "Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> DIST_POLLER_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsDistPoller.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsDistPoller.class, "label", "Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsDistPoller.class, "lastUpdated", "Last Updated", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsDistPoller.class, "location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> EVENT_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsEvent.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsEvent.class, "eventAckTime", "Acknowledged Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsEvent.class, "eventAckUser", "Acknowledging User", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventAutoAction", "Autoaction", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventCorrelation", "Correlation", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventCreateTime", "Creation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsEvent.class, "eventDescr", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventDisplay", "Display", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty(OnmsEvent.class, "eventForward", "Forward", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventHost", "Host", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventLog", "Log", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty(OnmsEvent.class, "eventLogGroup", "Log Group", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventLogMsg", "Log Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventMouseOverText", "Mouseover Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventNotification", "Notification", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventOperAction", "Operator Action", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventOperActionMenuText", "Operator Action Menu Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventOperInstruct", "Operator Instructions", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventPathOutage", "Path Outage", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventSeverity", "Severity", SearchProperty.SearchPropertyType.INTEGER, ONMS_SEVERITIES), new SearchProperty(OnmsEvent.class, "eventSnmp", "SNMP", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventSnmpHost", "SNMP Host", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventSource", "Source", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventSuppressedCount", "Suppressed Count", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsEvent.class, "eventTime", "Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsEvent.class, "eventTTicket", "Trouble Ticket ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "eventTTicketState", "Trouble Ticket State", SearchProperty.SearchPropertyType.INTEGER, (Map<String, String>)ImmutableMap.builder().put((Object)"0", (Object)"Off").put((Object)"1", (Object)"On").build()), new SearchProperty(OnmsEvent.class, "eventUei", "UEI", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEvent.class, "ifIndex", "ifIndex", SearchProperty.SearchPropertyType.INTEGER), new SearchPropertyBuilder().entityClass(OnmsEvent.class).id("ipAddr").name("IP Address").type(SearchProperty.SearchPropertyType.IP_ADDRESS).iplike(true).build()));
    static final SortedSet<SearchProperty> EVENT_PARAMETER_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsEventParameter.class, "name", "Name", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEventParameter.class, "type", "Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsEventParameter.class, "value", "Value", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> IF_SERVICE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsMonitoredService.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsMonitoredService.class, "lastFail", "Last Failure Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsMonitoredService.class, "lastGood", "Last Good Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsMonitoredService.class, "notify", "Notify", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty(OnmsMonitoredService.class, "qualifier", "Qualifier", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMonitoredService.class, "source", "Detection Source", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"P", (Object)"Plugin").put((Object)"F", (Object)"Forced").build()), new SearchProperty(OnmsMonitoredService.class, "status", "Management Status", SearchProperty.SearchPropertyType.STRING, OnmsMonitoredService.STATUS_MAP)));
    static final SortedSet<SearchProperty> IP_INTERFACE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsIpInterface.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsIpInterface.class, "ipAddress", "IP Address", SearchProperty.SearchPropertyType.IP_ADDRESS), new SearchProperty(OnmsIpInterface.class, "netMask", "Network Mask", SearchProperty.SearchPropertyType.IP_ADDRESS), new SearchProperty(OnmsIpInterface.class, "ipHostName", "Hostname", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsIpInterface.class, "ipLastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsIpInterface.class, "isManaged", "Management Status", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> LOCATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsMonitoringLocation.class, "locationName", "ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMonitoringLocation.class, "geolocation", "Geographic Address", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMonitoringLocation.class, "latitude", "Latitude", SearchProperty.SearchPropertyType.FLOAT), new SearchProperty(OnmsMonitoringLocation.class, "longitude", "Longitude", SearchProperty.SearchPropertyType.FLOAT), new SearchProperty(OnmsMonitoringLocation.class, "monitoringArea", "Monitoring Area", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMonitoringLocation.class, "priority", "UI Priority", SearchProperty.SearchPropertyType.INTEGER)));
    static final SortedSet<SearchProperty> MINION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsMinion.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsMinion.class, "label", "Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMinion.class, "lastUpdated", "Last Heartbeat Update", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsMinion.class, "location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsMinion.class, "status", "Status", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> NODE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsNode.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsNode.class, "createTime", "Creation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsNode.class, "foreignId", "Foreign ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "foreignSource", "Foreign Source", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "label", "Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "labelSource", "Label Source", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(OnmsNode.NodeLabelSource.ADDRESS.value()), (Object)"IP Address").put((Object)String.valueOf(OnmsNode.NodeLabelSource.HOSTNAME.value()), (Object)"Hostname").put((Object)String.valueOf(OnmsNode.NodeLabelSource.NETBIOS.value()), (Object)"NetBIOS").put((Object)String.valueOf(OnmsNode.NodeLabelSource.SYSNAME.value()), (Object)"SNMP sysName").put((Object)String.valueOf(OnmsNode.NodeLabelSource.UNKNOWN.value()), (Object)"Unknown").put((Object)String.valueOf(OnmsNode.NodeLabelSource.USER.value()), (Object)"User-Defined").build()), new SearchProperty(OnmsNode.class, "lastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsNode.class, "netBiosDomain", "Windows NetBIOS Domain", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "netBiosName", "Windows NetBIOS Name", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "operatingSystem", "Operating System", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "sysContact", "SNMP sysContact", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "sysDescription", "SNMP sysDescription", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "sysLocation", "SNMP sysLocation", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "sysName", "SNMP sysName", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "sysObjectId", "SNMP sysObjectId", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNode.class, "type", "Type", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(OnmsNode.NodeType.ACTIVE.value()), (Object)"Active").put((Object)String.valueOf(OnmsNode.NodeType.DELETED.value()), (Object)"Deleted").put((Object)String.valueOf(OnmsNode.NodeType.UNKNOWN.value()), (Object)"Unknown").build())));
    static final SortedSet<SearchProperty> NOTIFICATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsNotification.class, "notifyId", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsNotification.class, "answeredBy", "Answered By", SearchProperty.SearchPropertyType.STRING), new SearchPropertyBuilder().entityClass(OnmsNotification.class).id("ipAddress").name("IP Address").type(SearchProperty.SearchPropertyType.IP_ADDRESS).iplike(true).build(), new SearchProperty(OnmsNotification.class, "numericMsg", "Numeric Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNotification.class, "pageTime", "Page Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsNotification.class, "queueId", "Queue ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNotification.class, "respondTime", "Responded Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsNotification.class, "subject", "Subject", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsNotification.class, "textMsg", "Text Message", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> OUTAGE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsOutage.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsOutage.class, "ifLostService", "Lost Service Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsOutage.class, "ifRegainedService", "Regained Service Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsOutage.class, "suppressedBy", "Suppressed By User", SearchProperty.SearchPropertyType.STRING), new SearchProperty(OnmsOutage.class, "suppressTime", "Suppressed Time", SearchProperty.SearchPropertyType.TIMESTAMP)));
    static final SortedSet<SearchProperty> SCAN_REPORT_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(ScanReport.class, "id", "ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty(ScanReport.class, "locale", "Locale", SearchProperty.SearchPropertyType.STRING), new SearchProperty(ScanReport.class, "location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING), new SearchProperty(ScanReport.class, "timestamp", "Timestamp", SearchProperty.SearchPropertyType.TIMESTAMP)));
    static final SortedSet<SearchProperty> SERVICE_TYPE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsServiceType.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsServiceType.class, "name", "Service Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> SNMP_INTERFACE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty(OnmsSnmpInterface.class, "id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsSnmpInterface.class, "ifAdminStatus", "Admin Status", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsSnmpInterface.class, "ifIndex", "Interface Index", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsSnmpInterface.class, "ifOperStatus", "Operational Status", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty(OnmsSnmpInterface.class, "ifSpeed", "Interface Speed (Bits per second)", SearchProperty.SearchPropertyType.LONG), new SearchProperty(OnmsSnmpInterface.class, "lastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty(OnmsSnmpInterface.class, "lastSnmpPoll", "Last SNMP Interface Poll", SearchProperty.SearchPropertyType.TIMESTAMP)));
    public static final Set<SearchProperty> ALARM_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> APPLICATION_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> EVENT_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> IF_SERVICE_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> MINION_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> LOCATION_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> NODE_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> NOTIFICATION_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> OUTAGE_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();
    public static final Set<SearchProperty> SCAN_REPORT_SERVICE_PROPERTIES = new LinkedHashSet<SearchProperty>();

    static final Set<SearchProperty> withAliasPrefix(Aliases alias, String namePrefix, Set<SearchProperty> properties) {
        return SearchProperties.withAliasPrefix(alias, namePrefix, properties, true);
    }

    private static final SortedSet<SearchProperty> withAliasPrefix(Aliases alias, String namePrefix, Set<SearchProperty> properties, boolean orderBy) {
        return new TreeSet<SearchProperty>(properties.stream().map(p -> new SearchProperty(p.entityClass, alias.toString(), p.id, namePrefix, p.name, p.type, p.orderBy && orderBy, false, p.values)).collect(Collectors.toSet()));
    }

    private static final Set<SearchProperty> withAliasPrefix(String alias, String namePrefix, Set<SearchProperty> properties) {
        return properties.stream().map(p -> new SearchProperty(p.entityClass, alias, p.id, namePrefix, p.name, p.type, true, false, p.values)).collect(Collectors.toSet());
    }

    static {
        ALARM_SERVICE_PROPERTIES.addAll(ALARM_PROPERTIES);
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, "Category", CATEGORY_PROPERTIES, false));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, "Monitoring System", DIST_POLLER_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.eventParameter, "Event Parameter", EVENT_PARAMETER_PROPERTIES, false));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("lastEvent", "Last Event", EVENT_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, "Node", NODE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, "Service", SERVICE_TYPE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES));
        APPLICATION_SERVICE_PROPERTIES.addAll(APPLICATION_PROPERTIES);
        EVENT_SERVICE_PROPERTIES.addAll(EVENT_PROPERTIES);
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.alarm, "Alarm", ALARM_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, "Category", CATEGORY_PROPERTIES, false));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, "Monitoring System", DIST_POLLER_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.eventParameter, "Event Parameter", EVENT_PARAMETER_PROPERTIES, false));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, "Node", NODE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, "Service", SERVICE_TYPE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(IF_SERVICE_PROPERTIES);
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, "Node", NODE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, "Service", SERVICE_TYPE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES));
        MINION_SERVICE_PROPERTIES.addAll(MINION_PROPERTIES);
        LOCATION_SERVICE_PROPERTIES.addAll(LOCATION_PROPERTIES);
        NODE_SERVICE_PROPERTIES.addAll(NODE_PROPERTIES);
        NODE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        NODE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, "Category", CATEGORY_PROPERTIES, false));
        NODE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES, false));
        NODE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        NODE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES, false));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(NOTIFICATION_PROPERTIES);
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, "Category", CATEGORY_PROPERTIES, false));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, "Monitoring System", DIST_POLLER_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.event, "Event", EVENT_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.eventParameter, "Event Parameter", EVENT_PARAMETER_PROPERTIES, false));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, "Node", NODE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, "Service", SERVICE_TYPE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(OUTAGE_PROPERTIES);
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, "Asset", ASSET_RECORD_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, "Monitoring System", DIST_POLLER_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, "IP Interface", IP_INTERFACE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, "Location", LOCATION_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.monitoredService, "Monitored Service", IF_SERVICE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, "Node", NODE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("serviceLostEvent", "Service Lost Event", EVENT_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("serviceRegainedEvent", "Service Regained Event", EVENT_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, "Service", SERVICE_TYPE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, "SNMP Interface", SNMP_INTERFACE_PROPERTIES));
        SCAN_REPORT_SERVICE_PROPERTIES.addAll(SCAN_REPORT_PROPERTIES);
    }
}

