/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.text.ParseException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.web.rest.v1.InfoDTO;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.config.TicketerConfig;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="infoRestService")
@Path(value="info")
@Transactional
public class InfoRestService
extends OnmsRestService {
    @GET
    @Produces(value={"application/json"})
    public Response getInfo() throws ParseException {
        SystemInfoUtils sysInfoUtils = new SystemInfoUtils();
        InfoDTO info = new InfoDTO();
        info.setDisplayVersion(sysInfoUtils.getDisplayVersion());
        info.setVersion(sysInfoUtils.getVersion());
        info.setPackageName(sysInfoUtils.getPackageName());
        info.setPackageDescription(sysInfoUtils.getPackageDescription());
        info.setTicketerConfig(this.getTicketerConfig());
        return Response.ok().entity((Object)info).build();
    }

    private TicketerConfig getTicketerConfig() {
        TicketerConfig ticketerConfig = new TicketerConfig();
        ticketerConfig.setEnabled("true".equalsIgnoreCase(Vault.getProperty((String)"opennms.alarmTroubleTicketEnabled")));
        if (ticketerConfig.isEnabled()) {
            ticketerConfig.setPlugin(System.getProperty("opennms.ticketer.plugin"));
        }
        return ticketerConfig;
    }
}

