/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.resource.ResourceDTO;
import org.opennms.web.rest.v1.GraphNameCollection;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.PrefabGraphCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="graphRestService")
@Path(value="graphs")
public class GraphRestService
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private GraphDao m_graphDao;
    @Autowired
    private ResourceDao m_resourceDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public GraphNameCollection getGraphNames() {
        LinkedList graphNames = Lists.newLinkedList();
        for (PrefabGraph prefabGraph : this.m_graphDao.getAllPrefabGraphs()) {
            graphNames.add(prefabGraph.getName());
        }
        Collections.sort(graphNames);
        return new GraphNameCollection(graphNames);
    }

    @GET
    @Path(value="{graphName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public PrefabGraph getGraphByName(@PathParam(value="graphName") String graphName) {
        try {
            return this.m_graphDao.getPrefabGraph(graphName);
        }
        catch (ObjectRetrievalFailureException e) {
            throw GraphRestService.getException(Response.Status.NOT_FOUND, "No graph with name '{}' found.", graphName);
        }
    }

    @GET
    @Path(value="for/{resourceId}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public GraphNameCollection getGraphNamesForResource(@PathParam(value="resourceId") String resourceId) {
        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.fromString((String)resourceId));
        if (resource == null) {
            throw GraphRestService.getException(Response.Status.NOT_FOUND, "No resource with id '{}' found.", resourceId);
        }
        return this.getGraphNamesForResource(resource);
    }

    private GraphNameCollection getGraphNamesForResource(OnmsResource resource) {
        LinkedList graphNames = Lists.newLinkedList();
        for (PrefabGraph prefabGraph : this.m_graphDao.getPrefabGraphsForResource(resource)) {
            graphNames.add(prefabGraph.getName());
        }
        Collections.sort(graphNames);
        return new GraphNameCollection(graphNames);
    }

    @GET
    @Path(value="fornode/{nodeCriteria}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public GraphResourceDTO getGraphResourcesForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @DefaultValue(value="-1") @QueryParam(value="depth") int depth) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw GraphRestService.getException(Response.Status.NOT_FOUND, "No node found with criteria '{}'.", nodeCriteria);
        }
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        if (resource == null) {
            throw GraphRestService.getException(Response.Status.NOT_FOUND, "No resource found for node with id {}.", "" + node.getId());
        }
        ResourceVisitor visitor = new ResourceVisitor(this);
        ResourceDTO resourceDTO = ResourceDTO.fromResource((OnmsResource)resource, (int)depth);
        visitor.visit(resourceDTO);
        return new GraphResourceDTO(resourceDTO, visitor.getGraphs());
    }

    public static final class ResourceVisitor {
        private final Map<String, PrefabGraph> m_graphs = Maps.newLinkedHashMap();
        private final GraphRestService m_service;

        public ResourceVisitor(GraphRestService service) {
            this.m_service = service;
        }

        public void visit(ResourceDTO resource) {
            GraphNameCollection graphNames = this.m_service.getGraphNamesForResource(resource.getResource());
            resource.setGraphNames(graphNames.getObjects());
            Iterator iterator = graphNames.iterator();
            while (iterator.hasNext()) {
                String graphName = (String)iterator.next();
                if (this.m_graphs.containsKey(graphName)) continue;
                this.m_graphs.put(graphName, this.m_service.getGraphByName(graphName));
            }
            if (resource.getChildren() != null) {
                for (ResourceDTO r : resource.getChildren()) {
                    this.visit(r);
                }
            }
        }

        public PrefabGraphCollection getGraphs() {
            return new PrefabGraphCollection(this.m_graphs.values());
        }
    }

    @XmlRootElement(name="graph-resource")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class GraphResourceDTO {
        @XmlElement(name="resource")
        private ResourceDTO m_resource;
        @XmlElement(name="prefab-graphs")
        private PrefabGraphCollection m_prefabGraphs;

        private GraphResourceDTO() {
        }

        public GraphResourceDTO(ResourceDTO resource, PrefabGraphCollection graphs) {
            this.m_resource = resource;
            this.m_prefabGraphs = graphs;
        }
    }
}

