/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.BeanUtils;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLReader;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.features.graphml.service.GraphmlRepository;
import org.springframework.stereotype.Component;

@Component
@Path(value="graphml")
public class GraphMLRestService {
    private ServiceRegistry serviceRegistry;

    @POST
    @Path(value="{graph-name}")
    public Response createGraph(@PathParam(value="graph-name") String graphname, GraphmlType graphmlType) throws IOException {
        return this.runWithGraphmlRepositoryBlock(graphmlRepository -> {
            if (graphmlRepository.exists(graphname)) {
                return Response.status((int)500).entity((Object)("Graph with name " + graphname + " already exists")).build();
            }
            try {
                GraphML convertedGraphML = GraphMLReader.convert((GraphmlType)graphmlType);
                String label = (String)convertedGraphML.getProperty("label", (Object)graphname);
                graphmlRepository.save(graphname, label, graphmlType);
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            catch (InvalidGraphException ex) {
                return Response.status((int)500).entity((Object)ex.getMessage()).build();
            }
        });
    }

    @DELETE
    @Path(value="{graph-name}")
    public Response deleteGraph(@PathParam(value="graph-name") String graphname) throws IOException {
        return this.runWithGraphmlRepositoryBlock(graphmlRepository -> {
            if (!graphmlRepository.exists(graphname)) {
                throw new NoSuchElementException("No GraphML file found with name  " + graphname);
            }
            graphmlRepository.delete(graphname);
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="{graph-name}")
    public Response getGraph(@PathParam(value="graph-name") String graphname) throws IOException {
        return this.runWithGraphmlRepositoryBlock(graphmlRepository -> {
            GraphmlType byName = graphmlRepository.findByName(graphname);
            return Response.ok((Object)byName).build();
        });
    }

    private ServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = (ServiceRegistry)BeanUtils.getBean((String)"soaContext", (String)"serviceRegistry", ServiceRegistry.class);
            Objects.requireNonNull(this.serviceRegistry);
        }
        return this.serviceRegistry;
    }

    private Response runWithGraphmlRepositoryBlock(Block block) throws IOException {
        Objects.requireNonNull(block);
        GraphmlRepository graphmlRepository = (GraphmlRepository)this.getServiceRegistry().findProvider(GraphmlRepository.class);
        if (graphmlRepository == null) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"No service registered to handle your query. This is a temporary issue. Please try again later.").build();
        }
        Response response = block.invoke(graphmlRepository);
        Objects.requireNonNull(response);
        return response;
    }

    private static interface Block {
        public Response invoke(GraphmlRepository var1) throws IOException;
    }
}

