/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.netmgt.dao.stats.AlarmStatisticsService;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.v1.AlarmRestServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="alarmStatsRestService")
@Path(value="stats/alarms")
@Transactional
public class AlarmStatsRestService
extends AlarmRestServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmStatsRestService.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @Autowired
    private AlarmStatisticsService m_statisticsService;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public AlarmStatistics getStats(@Context UriInfo uriInfo) {
        return this.getStats(uriInfo, null);
    }

    @GET
    @Path(value="/by-severity")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public AlarmStatisticsBySeverity getStatsForEachSeverity(@Context UriInfo uriInfo, @QueryParam(value="severities") String severitiesString) {
        AlarmStatisticsBySeverity stats = new AlarmStatisticsBySeverity();
        String[] severities = StringUtils.split((String)severitiesString, (String)",");
        if (severities == null || severities.length == 0) {
            severities = OnmsSeverity.names().toArray(EMPTY_STRING_ARRAY);
        }
        for (String severityName : severities) {
            OnmsSeverity severity = OnmsSeverity.get((String)severityName);
            AlarmStatistics stat = this.getStats(uriInfo, severity);
            stat.setSeverity(severity);
            stats.add(stat);
        }
        return stats;
    }

    protected AlarmStatistics getStats(UriInfo uriInfo, OnmsSeverity severity) {
        AlarmStatistics stats = new AlarmStatistics();
        CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)uriInfo.getQueryParameters(), false);
        builder.count();
        if (severity != null) {
            builder.eq("severity", (Object)severity);
        }
        Criteria criteria = builder.toCriteria();
        LOG.debug("criteria = {}", (Object)criteria);
        int count = this.m_statisticsService.getTotalCount(criteria);
        stats.setTotalCount(count);
        stats.setAcknowledgedCount(this.m_statisticsService.getAcknowledgedCount(criteria));
        stats.setNewestAcknowledged(this.getNewestAcknowledged(severity));
        stats.setNewestUnacknowledged(this.getNewestUnacknowledged(severity));
        stats.setOldestAcknowledged(this.getOldestAcknowledged(severity));
        stats.setOldestUnacknowledged(this.getOldestUnacknowledged(severity));
        return stats;
    }

    protected OnmsAlarm getNewestAcknowledged(OnmsSeverity severity) {
        CriteriaBuilder builder = AlarmStatsRestService.getCriteriaBuilder(severity);
        builder.orderBy("lastEventTime").desc();
        builder.orderBy("id").desc();
        builder.limit(Integer.valueOf(1));
        Criteria criteria = builder.toCriteria();
        LOG.debug("getNewestAcknowledged({}) criteria = {}", (Object)severity, (Object)criteria);
        return this.m_statisticsService.getAcknowledged(criteria);
    }

    private OnmsAlarm getNewestUnacknowledged(OnmsSeverity severity) {
        CriteriaBuilder builder = AlarmStatsRestService.getCriteriaBuilder(severity);
        builder.orderBy("lastEventTime").desc();
        builder.orderBy("id").desc();
        builder.limit(Integer.valueOf(1));
        Criteria criteria = builder.toCriteria();
        LOG.debug("getNewestUnacknowledged({}) criteria = {}", (Object)severity, (Object)criteria);
        return this.m_statisticsService.getUnacknowledged(criteria);
    }

    protected OnmsAlarm getOldestAcknowledged(OnmsSeverity severity) {
        CriteriaBuilder builder = AlarmStatsRestService.getCriteriaBuilder(severity);
        builder.orderBy("firstEventTime").asc();
        builder.orderBy("id").asc();
        builder.limit(Integer.valueOf(1));
        Criteria criteria = builder.toCriteria();
        LOG.debug("getOldestAcknowledged({}) criteria = {}", (Object)severity, (Object)criteria);
        return this.m_statisticsService.getAcknowledged(criteria);
    }

    private OnmsAlarm getOldestUnacknowledged(OnmsSeverity severity) {
        CriteriaBuilder builder = AlarmStatsRestService.getCriteriaBuilder(severity);
        builder.orderBy("firstEventTime").asc();
        builder.orderBy("id").asc();
        builder.limit(Integer.valueOf(1));
        Criteria criteria = builder.toCriteria();
        LOG.debug("getOldestUnacknowledged({}) criteria = {}", (Object)severity, (Object)criteria);
        return this.m_statisticsService.getUnacknowledged(criteria);
    }

    protected static CriteriaBuilder getCriteriaBuilder(OnmsSeverity severity) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAlarm.class);
        if (severity != null) {
            builder.eq("severity", (Object)severity);
        }
        builder.fetch("firstEvent", Fetch.FetchType.EAGER);
        builder.fetch("lastEvent", Fetch.FetchType.EAGER);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        return builder;
    }

    @Entity
    @XmlRootElement(name="alarmStatistics")
    public static class AlarmStatistics {
        private int m_totalCount = 0;
        private int m_acknowledgedCount = 0;
        private OnmsSeverity m_severity = null;
        private OnmsAlarm m_newestAcknowledged;
        private OnmsAlarm m_newestUnacknowledged;
        private OnmsAlarm m_oldestAcknowledged;
        private OnmsAlarm m_oldestUnacknowledged;

        public String toString() {
            return new ToStringBuilder((Object)this).append("totalCount", this.m_totalCount).append("acknowledgedCount", this.m_acknowledgedCount).append("unacknowledgedCount", this.getUnacknowledgedCount()).append("newestAcknowledged", (Object)this.m_newestAcknowledged).append("newestUnacknowledged", (Object)this.m_newestUnacknowledged).append("oldestAcknowledged", (Object)this.m_oldestAcknowledged).append("oldestUnacknowledged", (Object)this.m_oldestUnacknowledged).toString();
        }

        @XmlAttribute(name="totalCount")
        public int getTotalCount() {
            return this.m_totalCount;
        }

        public void setTotalCount(int count) {
            this.m_totalCount = count;
        }

        @XmlAttribute(name="acknowledgedCount")
        public int getAcknowledgedCount() {
            return this.m_acknowledgedCount;
        }

        public void setAcknowledgedCount(int count) {
            this.m_acknowledgedCount = count;
        }

        @XmlAttribute(name="unacknowledgedCount")
        public int getUnacknowledgedCount() {
            return this.m_totalCount - this.m_acknowledgedCount;
        }

        public void setUnacknowledgedCount(int count) {
        }

        @XmlAttribute(name="severity")
        public OnmsSeverity getSeverity() {
            return this.m_severity;
        }

        public void setSeverity(OnmsSeverity severity) {
            this.m_severity = severity;
        }

        @XmlElementWrapper(name="newestAcked")
        @XmlElement(name="alarm")
        public List<OnmsAlarm> getNewestAcknowledged() {
            return Collections.singletonList(this.m_newestAcknowledged);
        }

        public void setNewestAcknowledged(OnmsAlarm alarm) {
            this.m_newestAcknowledged = alarm;
        }

        @XmlElementWrapper(name="newestUnacked")
        @XmlElement(name="alarm")
        public List<OnmsAlarm> getNewestUnacknowledged() {
            return Collections.singletonList(this.m_newestUnacknowledged);
        }

        public void setNewestUnacknowledged(OnmsAlarm alarm) {
            this.m_newestUnacknowledged = alarm;
        }

        @XmlElementWrapper(name="oldestAcked")
        @XmlElement(name="alarm")
        public List<OnmsAlarm> getOldestAcknowledged() {
            return Collections.singletonList(this.m_oldestAcknowledged);
        }

        public void setOldestAcknowledged(OnmsAlarm alarm) {
            this.m_oldestAcknowledged = alarm;
        }

        @XmlElementWrapper(name="oldestUnacked")
        @XmlElement(name="alarm")
        public List<OnmsAlarm> getOldestUnacknowledged() {
            return Collections.singletonList(this.m_oldestUnacknowledged);
        }

        public void setOldestUnacknowledged(OnmsAlarm alarm) {
            this.m_oldestUnacknowledged = alarm;
        }
    }

    @Entity
    @XmlRootElement(name="severities")
    public static class AlarmStatisticsBySeverity {
        private List<AlarmStatistics> m_stats = new LinkedList<AlarmStatistics>();

        @XmlElement(name="alarmStatistics")
        public List<AlarmStatistics> getStats() {
            return this.m_stats;
        }

        public void setStats(List<AlarmStatistics> stats) {
            this.m_stats = stats;
        }

        public void add(AlarmStatistics stats) {
            this.m_stats.add(stats);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("alarmStatistics", this.m_stats).toString();
        }
    }
}

