/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmRestServiceBase
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmRestServiceBase.class);
    protected static final Pattern m_severityPattern;

    protected Criteria getCriteria(MultivaluedMap<String, String> params, boolean stripOrdering) {
        CriteriaBuilder cb = this.getCriteriaBuilder(params, stripOrdering);
        Criteria criteria = cb.toCriteria();
        LOG.debug("criteria = {}", (Object)criteria);
        return criteria;
    }

    protected CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params, boolean stripOrdering) {
        this.translateParameters(params);
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAlarm.class);
        cb.fetch("firstEvent", Fetch.FetchType.EAGER);
        cb.fetch("lastEvent", Fetch.FetchType.EAGER);
        cb.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.location", "location", Alias.JoinType.LEFT_JOIN);
        if (params.containsKey((Object)"alarmId")) {
            if (params.containsKey((Object)"id")) {
                throw AlarmRestServiceBase.getException(Response.Status.BAD_REQUEST, "Form parameters contain both the 'alarmId' and 'id' properties!  Pick a side!", new String[0]);
            }
            params.put((Object)"id", params.remove((Object)"alarmId"));
        }
        AlarmRestServiceBase.applyQueryFilters(params, cb);
        if (stripOrdering) {
            cb.clearOrder();
            cb.limit(Integer.valueOf(10));
            cb.offset(Integer.valueOf(0));
        } else {
            cb.orderBy("lastEventTime").desc();
        }
        cb.distinct();
        return cb;
    }

    protected void translateParameters(MultivaluedMap<String, String> params) {
        Matcher m;
        String query;
        params.remove((Object)"severities");
        if (params.containsKey((Object)"nodeId")) {
            String nodeId = (String)params.getFirst((Object)"nodeId");
            params.remove((Object)"nodeId");
            params.add((Object)"node.id", (Object)nodeId);
        }
        if (params.containsKey((Object)"nodeLabel")) {
            String nodeLabel = (String)params.getFirst((Object)"nodeLabel");
            params.remove((Object)"nodeLabel");
            params.add((Object)"node.label", (Object)nodeLabel);
        }
        if ((query = (String)params.getFirst((Object)"query")) != null && (m = m_severityPattern.matcher(query)).find()) {
            String alias = m.group(1);
            String comparator = m.group(2);
            String severity = m.group(3);
            OnmsSeverity onmsSeverity = OnmsSeverity.get((String)severity);
            String newQuery = m.replaceFirst(" " + (alias == null ? "" : alias) + "severity " + comparator + " " + onmsSeverity.getId());
            params.remove((Object)"query");
            params.add((Object)"query", (Object)newQuery);
        }
    }

    static {
        String severities = StringUtils.join((Collection)OnmsSeverity.names(), (String)"|");
        m_severityPattern = Pattern.compile("\\s+(\\{alias\\}.)?severity\\s*(\\!\\=|\\<\\>|\\<\\=|\\>\\=|\\=|\\<|\\>)\\s*'?(" + severities + ")'?");
    }
}

