/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.opennms.web.rest.support.MultivaluedMapImpl;

@Provider
@Consumes(value={"multipart/form-data", "application/octet-stream"})
public class FormPropertiesReader
implements MessageBodyReader<MultivaluedMapImpl> {
    private HttpServletRequest m_httpServletRequest;

    @Context
    public void setHttpServletRequest(HttpServletRequest request) {
        this.m_httpServletRequest = request;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaTypes) {
        return type.isAssignableFrom(MultivaluedMapImpl.class);
    }

    public MultivaluedMapImpl readFrom(Class<MultivaluedMapImpl> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMapImpl result = new MultivaluedMapImpl();
        Enumeration en = this.m_httpServletRequest.getParameterNames();
        while (en.hasMoreElements()) {
            String parmName = (String)en.nextElement();
            String[] parmValue = this.m_httpServletRequest.getParameterValues(parmName);
            result.put(parmName, Arrays.asList(parmValue));
        }
        return result;
    }
}

