/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterfaceList;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.AbstractNodeDependentRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class NodeSnmpInterfacesRestService
extends AbstractNodeDependentRestService<OnmsSnmpInterface, OnmsSnmpInterface, Integer, Integer> {
    @Autowired
    private SnmpInterfaceDao m_ipInterfaceDao;

    protected SnmpInterfaceDao getDao() {
        return this.m_ipInterfaceDao;
    }

    @Override
    protected Class<OnmsSnmpInterface> getDaoClass() {
        return OnmsSnmpInterface.class;
    }

    @Override
    protected Class<OnmsSnmpInterface> getQueryBeanClass() {
        return OnmsSnmpInterface.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass());
        this.updateCriteria(uriInfo, builder);
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsSnmpInterface> createListWrapper(Collection<OnmsSnmpInterface> list) {
        return new OnmsSnmpInterfaceList(list);
    }

    @Override
    protected Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsSnmpInterface snmpInterface) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Node was not found.", new String[0]);
        }
        if (snmpInterface == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "SNMP Interface object cannot be null", new String[0]);
        }
        if (snmpInterface.getIfIndex() == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "SNMP Interface's ifIndex cannot be null", new String[0]);
        }
        node.addSnmpInterface(snmpInterface);
        if (snmpInterface.getPrimaryIpInterface() != null) {
            OnmsIpInterface iface = snmpInterface.getPrimaryIpInterface();
            iface.setSnmpInterface(snmpInterface);
        }
        this.getDao().save((Object)snmpInterface);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, snmpInterface.getIfIndex())).build();
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, OnmsSnmpInterface targetObject, MultivaluedMapImpl params) {
        if (params.getFirst("ifIndex") != null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Cannot change ifIndex.", new String[0]);
        }
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsSnmpInterface intf) {
        intf.getNode().getSnmpInterfaces().remove(intf);
        this.getDao().delete((Object)intf);
    }

    @Override
    protected OnmsSnmpInterface doGet(UriInfo uriInfo, Integer ifIndex) {
        OnmsNode node = this.getNode(uriInfo);
        return node == null ? null : node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
    }
}

