/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class SecurityHelper {
    public static void assertUserReadCredentials(SecurityContext securityContext) {
        String currentUser = securityContext.getUserPrincipal().getName();
        if (securityContext.isUserInRole("ROLE_ADMIN")) {
            return;
        }
        if (securityContext.isUserInRole("ROLE_REST") || securityContext.isUserInRole("ROLE_USER") || securityContext.isUserInRole("ROLE_MOBILE")) {
            return;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is not allowed to read alarms.")).type("text/plain").build());
    }

    public static void assertUserEditCredentials(SecurityContext securityContext, String ackUser) {
        String currentUser = securityContext.getUserPrincipal().getName();
        if (securityContext.isUserInRole("ROLE_ADMIN")) {
            return;
        }
        if (securityContext.isUserInRole("ROLE_READONLY")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is a read-only user!")).type("text/plain").build());
        }
        if ((securityContext.isUserInRole("ROLE_REST") || securityContext.isUserInRole("ROLE_USER") || securityContext.isUserInRole("ROLE_MOBILE")) && ackUser.equals(currentUser)) {
            return;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is not allowed to perform updates to alarms as user '" + ackUser + "'")).type("text/plain").build());
    }
}

