/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.SearchProperty;

public abstract class SearchProperties {
    private static final Map<String, String> ONMS_SEVERITIES = Arrays.stream(OnmsSeverity.values()).collect(Collectors.toMap(s -> String.valueOf(s.getId()), OnmsSeverity::getLabel));
    static final SortedSet<SearchProperty> ALARM_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("alarmAckTime", "Acknowledged Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("alarmAckUser", "Acknowledging User", SearchProperty.SearchPropertyType.STRING), new SearchProperty("alarmType", "Alarm Type", SearchProperty.SearchPropertyType.INTEGER, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(1), (Object)"Problem").put((Object)String.valueOf(2), (Object)"Resolution").build()), new SearchProperty("applicationDN", "Application DN", SearchProperty.SearchPropertyType.STRING), new SearchProperty("clearKey", "Clear Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty("counter", "Event Counter", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty("firstAutomationTime", "First Automation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("firstEventTime", "First Event Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("ifIndex", "SNMP Interface Index", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ipAddr", "IP Address", SearchProperty.SearchPropertyType.IP_ADDRESS), new SearchProperty("lastAutomationTime", "Last Automation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("lastEventTime", "Last Event Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("logMsg", "Log Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty("managedObjectInstance", "Managed Object Instance", SearchProperty.SearchPropertyType.STRING), new SearchProperty("managedObjectType", "Managed Object Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty("mouseOverText", "Mouseover Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty("operInstruct", "Operator Instructions", SearchProperty.SearchPropertyType.STRING), new SearchProperty("ossPrimaryKey", "OSS Primary Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty("qosAlarmState", "QoS Alarm State", SearchProperty.SearchPropertyType.STRING), new SearchProperty("reductionKey", "Reduction Key", SearchProperty.SearchPropertyType.STRING), new SearchProperty("severity", "Severity", SearchProperty.SearchPropertyType.INTEGER, ONMS_SEVERITIES), new SearchProperty("suppressedTime", "Suppressed Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("suppressedUntil", "Suppressed Until", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("suppressedUser", "Suppressed User", SearchProperty.SearchPropertyType.STRING), new SearchProperty("uei", "UEI", SearchProperty.SearchPropertyType.STRING), new SearchProperty("x733AlarmType", "X.733 Alarm Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty("x733ProbableCause", "X.733 Probable Cause", SearchProperty.SearchPropertyType.INTEGER)));
    static final SortedSet<SearchProperty> APPLICATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("name", "Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> ASSET_RECORD_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("additionalhardware", "Additional Hardware", SearchProperty.SearchPropertyType.STRING), new SearchProperty("admin", "Admin", SearchProperty.SearchPropertyType.STRING), new SearchProperty("assetNumber", "Asset Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty("autoenable", "Auto-enable", SearchProperty.SearchPropertyType.STRING), new SearchProperty("building", "Building", SearchProperty.SearchPropertyType.STRING), new SearchProperty("category", "Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty("circuitId", "Circuit ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("comment", "Comment", SearchProperty.SearchPropertyType.STRING), new SearchProperty("connection", "Connection", SearchProperty.SearchPropertyType.STRING), new SearchProperty("cpu", "CPU", SearchProperty.SearchPropertyType.STRING), new SearchProperty("dateInstalled", "Date Installed", SearchProperty.SearchPropertyType.STRING), new SearchProperty("department", "Department", SearchProperty.SearchPropertyType.STRING), new SearchProperty("description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty("displayCategory", "Display Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty("division", "Division", SearchProperty.SearchPropertyType.STRING), new SearchProperty("enable", "Enable", SearchProperty.SearchPropertyType.STRING), new SearchProperty("floor", "Floor", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd1", "HDD 1", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd2", "HDD 2", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd3", "HDD 3", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd4", "HDD 4", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd5", "HDD 5", SearchProperty.SearchPropertyType.STRING), new SearchProperty("hdd6", "HDD 6", SearchProperty.SearchPropertyType.STRING), new SearchProperty("inputpower", "Input Power", SearchProperty.SearchPropertyType.STRING), new SearchProperty("lastModifiedBy", "Last Modified By", SearchProperty.SearchPropertyType.STRING), new SearchProperty("lastModifiedDate", "Last Modified Date", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("lease", "Lease", SearchProperty.SearchPropertyType.STRING), new SearchProperty("leaseExpires", "Lease Expires", SearchProperty.SearchPropertyType.STRING), new SearchProperty("maintcontract", "Maintenance Contract", SearchProperty.SearchPropertyType.STRING), new SearchProperty("maintContractExpiration", "Maintenance Contract Expiration", SearchProperty.SearchPropertyType.STRING), new SearchProperty("managedObjectInstance", "Managed Object Instance", SearchProperty.SearchPropertyType.STRING), new SearchProperty("managedObjectType", "Managed Object Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty("manufacturer", "Manufacturer", SearchProperty.SearchPropertyType.STRING), new SearchProperty("modelNumber", "Model Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty("notifyCategory", "Notify Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty("numpowersupplies", "Number of Power Supplies", SearchProperty.SearchPropertyType.STRING), new SearchProperty("operatingSystem", "Operating System", SearchProperty.SearchPropertyType.STRING), new SearchProperty("password", "Password", SearchProperty.SearchPropertyType.STRING), new SearchProperty("pollerCategory", "Poller Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty("port", "Port", SearchProperty.SearchPropertyType.STRING), new SearchProperty("rack", "Rack", SearchProperty.SearchPropertyType.STRING), new SearchProperty("rackunitheight", "Rack Unit Height", SearchProperty.SearchPropertyType.STRING), new SearchProperty("ram", "RAM", SearchProperty.SearchPropertyType.STRING), new SearchProperty("region", "Region", SearchProperty.SearchPropertyType.STRING), new SearchProperty("room", "Room", SearchProperty.SearchPropertyType.STRING), new SearchProperty("serialNumber", "Serial Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty("slot", "Slot", SearchProperty.SearchPropertyType.STRING), new SearchProperty("snmpcommunity", "SNMP Community", SearchProperty.SearchPropertyType.STRING), new SearchProperty("storagectrl", "Storage Controller", SearchProperty.SearchPropertyType.STRING), new SearchProperty("supportPhone", "Support Phone", SearchProperty.SearchPropertyType.STRING), new SearchProperty("thresholdCategory", "Threshold Category", SearchProperty.SearchPropertyType.STRING), new SearchProperty("username", "Username", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vendor", "Vendor", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vendorAssetNumber", "Vendor Asset Number", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vendorFax", "Vendor Fax", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vendorPhone", "Vendor Phone", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vmwareManagedEntityType", "VMware Managed Entity Type", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vmwareManagedObjectId", "VMware Managed Object ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vmwareManagementServer", "VMware Management Server", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vmwareState", "VMware State", SearchProperty.SearchPropertyType.STRING), new SearchProperty("vmwareTopologyInfo", "VMware Topology Information", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> CATEGORY_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("description", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty("name", "Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> DIST_POLLER_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("label", "Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty("lastUpdated", "Last Updated", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> EVENT_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("eventAckTime", "Acknowledged Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("eventAckUser", "Acknowledging User", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventAutoAction", "Autoaction", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventCorrelation", "Correlation", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventCreateTime", "Creation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("eventDescr", "Description", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventDisplay", "Display", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty("eventForward", "Forward", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventHost", "Host", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventLog", "Log", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty("eventLogGroup", "Log Group", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventLogMsg", "Log Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventMouseOverText", "Mouseover Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventNotification", "Notification", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventOperAction", "Operator Action", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventOperActionMenuText", "Operator Action Menu Text", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventOperInstruct", "Operator Instructions", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventPathOutage", "Path Outage", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventSeverity", "Severity", SearchProperty.SearchPropertyType.INTEGER, ONMS_SEVERITIES), new SearchProperty("eventSnmp", "SNMP", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventSnmpHost", "SNMP Host", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventSource", "Event Source", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventSuppressedCount", "Suppressed Count", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("eventTime", "Event Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("eventTTicket", "Trouble Ticket ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("eventTTicketState", "Trouble Ticket State", SearchProperty.SearchPropertyType.INTEGER, (Map<String, String>)ImmutableMap.builder().put((Object)"0", (Object)"Off").put((Object)"1", (Object)"On").build()), new SearchProperty("eventUei", "UEI", SearchProperty.SearchPropertyType.STRING), new SearchProperty("ifIndex", "ifIndex", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ipAddr", "IP Address", SearchProperty.SearchPropertyType.IP_ADDRESS)));
    static final SortedSet<SearchProperty> IF_SERVICE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("lastFail", "Last Failure Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("lastGood", "Last Good Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("notify", "Notify", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"Y", (Object)"Yes").put((Object)"N", (Object)"No").build()), new SearchProperty("qualifier", "Qualifier", SearchProperty.SearchPropertyType.STRING), new SearchProperty("source", "Detection Source", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)"P", (Object)"Plugin").put((Object)"F", (Object)"Forced").build()), new SearchProperty("status", "Management Status", SearchProperty.SearchPropertyType.STRING, OnmsMonitoredService.STATUS_MAP)));
    static final SortedSet<SearchProperty> IP_INTERFACE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ipAddress", "IP Address", SearchProperty.SearchPropertyType.IP_ADDRESS), new SearchProperty("ipHostName", "Hostname", SearchProperty.SearchPropertyType.STRING), new SearchProperty("ipLastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("isManaged", "Management Status", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> LOCATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("locationName", "ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("geolocation", "Geographic Address", SearchProperty.SearchPropertyType.STRING), new SearchProperty("latitude", "Latitude", SearchProperty.SearchPropertyType.FLOAT), new SearchProperty("longitude", "Longitude", SearchProperty.SearchPropertyType.FLOAT), new SearchProperty("monitoringArea", "Monitoring Area", SearchProperty.SearchPropertyType.STRING), new SearchProperty("priority", "Priority in UI", SearchProperty.SearchPropertyType.INTEGER)));
    static final SortedSet<SearchProperty> MINION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("label", "Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty("lastUpdated", "Last Heartbeat Update", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING), new SearchProperty("status", "Status", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> NODE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("createTime", "Creation Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("foreignId", "Foreign ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("foreignSource", "Foreign Source", SearchProperty.SearchPropertyType.STRING), new SearchProperty("label", "Node Label", SearchProperty.SearchPropertyType.STRING), new SearchProperty("labelSource", "Label Source", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(OnmsNode.NodeLabelSource.ADDRESS.value()), (Object)"IP Address").put((Object)String.valueOf(OnmsNode.NodeLabelSource.HOSTNAME.value()), (Object)"Hostname").put((Object)String.valueOf(OnmsNode.NodeLabelSource.NETBIOS.value()), (Object)"NetBIOS").put((Object)String.valueOf(OnmsNode.NodeLabelSource.SYSNAME.value()), (Object)"SNMP sysName").put((Object)String.valueOf(OnmsNode.NodeLabelSource.UNKNOWN.value()), (Object)"Unknown").put((Object)String.valueOf(OnmsNode.NodeLabelSource.USER.value()), (Object)"User-Defined").build()), new SearchProperty("lastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("netBiosDomain", "Windows NetBIOS Domain", SearchProperty.SearchPropertyType.STRING), new SearchProperty("netBiosName", "Windows NetBIOS Name", SearchProperty.SearchPropertyType.STRING), new SearchProperty("operatingSystem", "Operating System", SearchProperty.SearchPropertyType.STRING), new SearchProperty("sysContact", "SNMP sysContact", SearchProperty.SearchPropertyType.STRING), new SearchProperty("sysDescription", "SNMP sysDescription", SearchProperty.SearchPropertyType.STRING), new SearchProperty("sysLocation", "SNMP sysLocation", SearchProperty.SearchPropertyType.STRING), new SearchProperty("sysName", "SNMP sysName", SearchProperty.SearchPropertyType.STRING), new SearchProperty("sysObjectId", "SNMP sysObjectId", SearchProperty.SearchPropertyType.STRING), new SearchProperty("type", "Type", SearchProperty.SearchPropertyType.STRING, (Map<String, String>)ImmutableMap.builder().put((Object)String.valueOf(OnmsNode.NodeType.ACTIVE.value()), (Object)"Active").put((Object)String.valueOf(OnmsNode.NodeType.DELETED.value()), (Object)"Deleted").put((Object)String.valueOf(OnmsNode.NodeType.UNKNOWN.value()), (Object)"Unknown").build())));
    static final SortedSet<SearchProperty> NOTIFICATION_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("notifyId", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("answeredBy", "Answered By", SearchProperty.SearchPropertyType.STRING), new SearchProperty("ipAddress", "IP Address", SearchProperty.SearchPropertyType.IP_ADDRESS), new SearchProperty("numericMsg", "Numeric Message", SearchProperty.SearchPropertyType.STRING), new SearchProperty("pageTime", "Page Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("queueId", "Queue ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("respondTime", "Responded Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("subject", "Subject", SearchProperty.SearchPropertyType.STRING), new SearchProperty("textMsg", "Text Message", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> OUTAGE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ifLostService", "Lost Service Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("ifRegainedService", "Regained Service Time", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("suppressedBy", "Suppressed By User", SearchProperty.SearchPropertyType.STRING), new SearchProperty("suppressTime", "Suppressed Time", SearchProperty.SearchPropertyType.TIMESTAMP)));
    static final SortedSet<SearchProperty> SCAN_REPORT_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.STRING), new SearchProperty("locale", "Locale", SearchProperty.SearchPropertyType.STRING), new SearchProperty("location", "Monitoring Location", SearchProperty.SearchPropertyType.STRING), new SearchProperty("timestamp", "Timestamp", SearchProperty.SearchPropertyType.TIMESTAMP)));
    static final SortedSet<SearchProperty> SERVICE_TYPE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("name", "Service Name", SearchProperty.SearchPropertyType.STRING)));
    static final SortedSet<SearchProperty> SNMP_INTERFACE_PROPERTIES = new TreeSet<SearchProperty>(Arrays.asList(new SearchProperty("id", "ID", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ifAdminStatus", "Admin status", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ifIndex", "Interface index", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ifOperStatus", "Operational status", SearchProperty.SearchPropertyType.INTEGER), new SearchProperty("ifSpeed", "Bits-per-second Interface Speed", SearchProperty.SearchPropertyType.LONG), new SearchProperty("lastCapsdPoll", "Last Provisioning Scan", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("lastSnmpPoll", "Last SNMP Interface Poll", SearchProperty.SearchPropertyType.TIMESTAMP), new SearchProperty("netMask", "Network Mask", SearchProperty.SearchPropertyType.IP_ADDRESS)));
    public static final SortedSet<SearchProperty> ALARM_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
    public static final SortedSet<SearchProperty> APPLICATION_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> EVENT_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> IF_SERVICE_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> MINION_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> LOCATION_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> NOTIFICATION_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> OUTAGE_SERVICE_PROPERTIES;
    public static final SortedSet<SearchProperty> SCAN_REPORT_SERVICE_PROPERTIES;

    static final Set<SearchProperty> withAliasPrefix(Aliases alias, Set<SearchProperty> properties) {
        return SearchProperties.withAliasPrefix(alias, properties, true);
    }

    private static final SortedSet<SearchProperty> withAliasPrefix(Aliases alias, Set<SearchProperty> properties, boolean orderBy) {
        return new TreeSet<SearchProperty>(properties.stream().map(p -> new SearchProperty(alias.prop(p.id), p.name, p.type, orderBy, p.values)).collect(Collectors.toSet()));
    }

    private static final Set<SearchProperty> withAliasPrefix(String alias, Set<SearchProperty> properties) {
        return properties.stream().map(p -> new SearchProperty(alias + "." + p.id, p.name, p.type, p.values)).collect(Collectors.toSet());
    }

    static {
        ALARM_SERVICE_PROPERTIES.addAll(ALARM_PROPERTIES);
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, ASSET_RECORD_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, CATEGORY_PROPERTIES, false));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, DIST_POLLER_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, IP_INTERFACE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("lastEvent", EVENT_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, LOCATION_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, NODE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, SERVICE_TYPE_PROPERTIES));
        ALARM_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, SNMP_INTERFACE_PROPERTIES));
        APPLICATION_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        APPLICATION_SERVICE_PROPERTIES.addAll(APPLICATION_PROPERTIES);
        EVENT_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        EVENT_SERVICE_PROPERTIES.addAll(EVENT_PROPERTIES);
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.alarm, ALARM_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, ASSET_RECORD_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, CATEGORY_PROPERTIES, false));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, DIST_POLLER_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, IP_INTERFACE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, LOCATION_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, NODE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, SERVICE_TYPE_PROPERTIES));
        EVENT_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, SNMP_INTERFACE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        IF_SERVICE_SERVICE_PROPERTIES.addAll(IF_SERVICE_PROPERTIES);
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, ASSET_RECORD_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, IP_INTERFACE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, LOCATION_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, NODE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, SERVICE_TYPE_PROPERTIES));
        IF_SERVICE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, SNMP_INTERFACE_PROPERTIES));
        MINION_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        MINION_SERVICE_PROPERTIES.addAll(MINION_PROPERTIES);
        LOCATION_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        LOCATION_SERVICE_PROPERTIES.addAll(LOCATION_PROPERTIES);
        NOTIFICATION_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        NOTIFICATION_SERVICE_PROPERTIES.addAll(NOTIFICATION_PROPERTIES);
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, ASSET_RECORD_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.category, CATEGORY_PROPERTIES, false));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, DIST_POLLER_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.event, EVENT_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, IP_INTERFACE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, LOCATION_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, NODE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, SERVICE_TYPE_PROPERTIES));
        NOTIFICATION_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, SNMP_INTERFACE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        OUTAGE_SERVICE_PROPERTIES.addAll(OUTAGE_PROPERTIES);
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.assetRecord, ASSET_RECORD_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.distPoller, DIST_POLLER_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.ipInterface, IP_INTERFACE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.location, LOCATION_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.node, NODE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("serviceLostEvent", EVENT_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix("serviceRegainedEvent", EVENT_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.serviceType, SERVICE_TYPE_PROPERTIES));
        OUTAGE_SERVICE_PROPERTIES.addAll(SearchProperties.withAliasPrefix(Aliases.snmpInterface, SNMP_INTERFACE_PROPERTIES));
        SCAN_REPORT_SERVICE_PROPERTIES = new TreeSet<SearchProperty>();
        SCAN_REPORT_SERVICE_PROPERTIES.addAll(SCAN_REPORT_PROPERTIES);
    }
}

