/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.net.InetAddress;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.StringCriteriaBehavior;

public abstract class CriteriaBehaviors {
    public static final DateFormat SEARCH_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final Map<String, CriteriaBehavior<?>> ALARM_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> ASSET_RECORD_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> DIST_POLLER_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> EVENT_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> IP_INTERFACE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORED_SERVICE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORING_LOCATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_CATEGORY_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NOTIFICATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> OUTAGE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> REDUCTION_KEY_MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SERVICE_TYPE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SNMP_INTERFACE_BEHAVIORS = new HashMap();

    public static Date parseDate(String string) {
        try {
            return SEARCH_DATE_FORMAT.parse(string);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unparseable date: " + string, e);
        }
    }

    public static final Map<String, CriteriaBehavior<?>> withAliasPrefix(Aliases alias, Map<String, CriteriaBehavior<?>> behaviors) {
        HashMap retval = new HashMap();
        for (Map.Entry<String, CriteriaBehavior<?>> entry : behaviors.entrySet()) {
            retval.put(alias.prop(entry.getKey()), entry.getValue());
        }
        return retval;
    }

    public static final Map<String, CriteriaBehavior<?>> withAliasPrefix(String alias, Map<String, CriteriaBehavior<?>> behaviors) {
        HashMap retval = new HashMap();
        for (Map.Entry<String, CriteriaBehavior<?>> entry : behaviors.entrySet()) {
            retval.put(alias + "." + entry.getKey(), entry.getValue());
        }
        return retval;
    }

    static {
        ALARM_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put("alarmAckTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("alarmType", new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put("counter", new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put("firstAutomationTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("firstEventTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put("ipAddr", new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        ALARM_BEHAVIORS.put("lastAutomationTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("lastEventTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("severity", new CriteriaBehavior<OnmsSeverity>(OnmsSeverity::get));
        ALARM_BEHAVIORS.put("suppressedTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("suppressedUntil", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put("troubleTicketState", new CriteriaBehavior<TroubleTicketState>(TroubleTicketState::valueOf));
        ALARM_BEHAVIORS.put("x733ProbableCause", new CriteriaBehavior<Integer>(Integer::parseInt));
        ASSET_RECORD_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        ASSET_RECORD_BEHAVIORS.put("lastModifiedDate", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        DIST_POLLER_BEHAVIORS.put("lastUpdated", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put("eventAckTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put("eventCreateTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put("eventSeverity", new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put("eventSuppressedCount", new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put("eventTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put("eventTTicketState", new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put("ipAddr", new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        IP_INTERFACE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        IP_INTERFACE_BEHAVIORS.put("ipLastCapsdPoll", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        IP_INTERFACE_BEHAVIORS.put("ipAddress", new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        MONITORING_LOCATION_BEHAVIORS.put("latitude", new CriteriaBehavior<Float>(Float::parseFloat));
        MONITORING_LOCATION_BEHAVIORS.put("longitude", new CriteriaBehavior<Float>(Float::parseFloat));
        MONITORING_LOCATION_BEHAVIORS.put("priority", new CriteriaBehavior<Long>(Long::parseLong));
        NODE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        NODE_BEHAVIORS.put("createTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        NODE_BEHAVIORS.put("lastCapsdPoll", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        CriteriaBehavior<Integer> categoryId = new CriteriaBehavior<Integer>(Aliases.category.prop("id"), Integer::parseInt, (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql("{alias}.nodeid in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql("{alias}.nodeid not in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.id: " + c.toString());
                }
            }
        });
        categoryId.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put("id", categoryId);
        StringCriteriaBehavior categoryName = new StringCriteriaBehavior(Aliases.category.prop("name"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.name: " + c.toString());
                }
            }
        });
        categoryName.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put("name", categoryName);
        StringCriteriaBehavior categoryDescription = new StringCriteriaBehavior(Aliases.category.prop("description"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.description: " + c.toString());
                }
            }
        });
        categoryDescription.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put("description", categoryDescription);
        NOTIFICATION_BEHAVIORS.put("notifyId", new CriteriaBehavior<Integer>(Integer::parseInt));
        NOTIFICATION_BEHAVIORS.put("pageTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        NOTIFICATION_BEHAVIORS.put("respondTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        OUTAGE_BEHAVIORS.put("ifLostService", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put("ifRegainedService", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put("suppressTime", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SERVICE_TYPE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put("id", new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put("ifAdminStatus", new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put("ifIndex", new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put("ifOperStatus", new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put("ifSpeed", new CriteriaBehavior<Long>(Long::parseLong));
        SNMP_INTERFACE_BEHAVIORS.put("lastCapsdPoll", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SNMP_INTERFACE_BEHAVIORS.put("lastSnmpPoll", new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SNMP_INTERFACE_BEHAVIORS.put("netMask", new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
    }
}

