/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.opennms.web.rest.v2.NodeCategoriesRestService;
import org.opennms.web.rest.v2.NodeHardwareInventoryRestService;
import org.opennms.web.rest.v2.NodeIpInterfacesRestService;
import org.opennms.web.rest.v2.NodeSnmpInterfacesRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="nodes")
@Transactional
public class NodeRestService
extends AbstractDaoRestService<OnmsNode, SearchBean, Integer, String> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestService.class);
    @Autowired
    private MonitoringLocationDao m_locationDao;
    @Autowired
    private NodeDao m_dao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    protected NodeDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsNode> getDaoClass() {
        return OnmsNode.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class, Aliases.node.toString());
        builder.alias("assetRecord", Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("categories", Aliases.category.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces", Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("location", Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("snmpInterfaces", Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.ipInterface.prop("monitoredServices"), Aliases.monitoredService.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.monitoredService.prop("serviceType"), Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.orderBy("label").desc();
        builder.distinct();
        return builder;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.ASSET_RECORD_BEHAVIORS);
        map.putAll(CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS);
        map.putAll(CriteriaBehaviors.IP_INTERFACE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.MONITORED_SERVICE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS);
        return map;
    }

    @Override
    protected JaxbListWrapper<OnmsNode> createListWrapper(Collection<OnmsNode> list) {
        return new OnmsNodeList(list);
    }

    @Override
    public Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsNode object) {
        if (object == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Node object cannot be null", new String[0]);
        }
        if (object.getLocation() == null) {
            OnmsMonitoringLocation location = this.m_locationDao.getDefaultLocation();
            LOG.debug("doCreate: Assigning new node to default location: {}", (Object)location.getLocationName());
            object.setLocation(location);
        }
        Integer id = (Integer)this.getDao().save((Object)object);
        Event e = EventUtils.createNodeAddedEvent((String)"Rest", (int)id, (String)object.getLabel(), (OnmsNode.NodeLabelSource)object.getLabelSource());
        this.sendEvent(e);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, id)).build();
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, OnmsNode targetObject, MultivaluedMapImpl params) {
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsNode node) {
        this.getDao().delete((Object)node);
        Event e = EventUtils.createDeleteNodeEvent((String)"ReST", (long)node.getId().intValue(), (long)-1L);
        this.sendEvent(e);
    }

    @Override
    protected OnmsNode doGet(UriInfo uriInfo, String id) {
        return this.getDao().get(id);
    }

    @Path(value="{nodeCriteria}/ipinterfaces")
    public NodeIpInterfacesRestService getIpInterfaceResource(@Context ResourceContext context) {
        return (NodeIpInterfacesRestService)context.getResource(NodeIpInterfacesRestService.class);
    }

    @Path(value="{nodeCriteria}/snmpinterfaces")
    public NodeSnmpInterfacesRestService getSnmpInterfaceResource(@Context ResourceContext context) {
        return (NodeSnmpInterfacesRestService)context.getResource(NodeSnmpInterfacesRestService.class);
    }

    @Path(value="{nodeCriteria}/hardwareInventory")
    public NodeHardwareInventoryRestService getHardwareInventoryResource(@Context ResourceContext context) {
        return (NodeHardwareInventoryRestService)context.getResource(NodeHardwareInventoryRestService.class);
    }

    @Path(value="{nodeCriteria}/categories")
    public NodeCategoriesRestService getCategoriesResource(@Context ResourceContext context) {
        return (NodeCategoriesRestService)context.getResource(NodeCategoriesRestService.class);
    }
}

