/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.v2.AbstractNodeDependentRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class NodeCategoriesRestService
extends AbstractNodeDependentRestService<OnmsCategory, OnmsCategory, Integer, String> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCategoriesRestService.class);
    @Autowired
    private CategoryDao m_dao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;

    protected CategoryDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsCategory> getDaoClass() {
        return OnmsCategory.class;
    }

    @Override
    protected Class<OnmsCategory> getQueryBeanClass() {
        return OnmsCategory.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        return new CriteriaBuilder(this.getDaoClass()).distinct();
    }

    @Override
    protected JaxbListWrapper<OnmsCategory> createListWrapper(Collection<OnmsCategory> list) {
        return new OnmsCategoryCollection(list);
    }

    @Override
    @GET
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response get(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new OnmsCategoryCollection((Collection)node.getCategories())).build();
    }

    @Override
    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public Response getCount(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)node.getCategories().size()).build();
    }

    public Response updateMany(@Context UriInfo uriInfo, @Context SearchContext searchContext, MultivaluedMapImpl params) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    public Response deleteMany(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @Override
    protected Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsCategory source) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Node was not found.", new String[0]);
        }
        if (source == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Category object cannot be null", new String[0]);
        }
        if (source.getName() == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Category's name cannot be null", new String[0]);
        }
        OnmsCategory category = this.getCategory(source.getName());
        node.addCategory(category);
        this.m_nodeDao.saveOrUpdate((Object)node);
        Event event = EventUtils.createNodeCategoryMembershipChangedEvent((String)"ReST", (Integer)node.getId(), (String)node.getLabel(), (String[])new String[]{category.getName()}, null);
        this.sendEvent(event);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, category.getName())).build();
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, OnmsCategory targetObject, MultivaluedMapImpl params) {
        if (params.getFirst("name") != null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Cannot rename category.", new String[0]);
        }
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsCategory category) {
        this.getNode(uriInfo).removeCategory(category);
        this.getDao().delete((Object)category);
        OnmsNode node = this.getNode(uriInfo);
        Event event = EventUtils.createNodeCategoryMembershipChangedEvent((String)"ReST", (Integer)node.getId(), (String)node.getLabel(), null, (String[])new String[]{category.getName()});
        this.sendEvent(event);
    }

    @Override
    protected OnmsCategory doGet(UriInfo uriInfo, String categoryName) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            return null;
        }
        Optional<OnmsCategory> optional = node.getCategories().stream().filter(c -> c.getName().equals(categoryName)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    private OnmsCategory getCategory(final String categoryName) {
        OnmsCategory category = (OnmsCategory)new CreateIfNecessaryTemplate<OnmsCategory, CategoryDao>(this.m_transactionManager, this.m_dao){

            protected OnmsCategory query() {
                return ((CategoryDao)this.m_dao).findByName(categoryName);
            }

            protected OnmsCategory doInsert() {
                LOG.info("getCategory: creating category {}", (Object)categoryName);
                OnmsCategory c = new OnmsCategory(categoryName);
                ((CategoryDao)this.m_dao).saveOrUpdate((Object)c);
                return c;
            }
        }.execute();
        return category;
    }
}

