/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.IpLikeCriteriaBehavior;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="events")
@Transactional
public class EventRestService
extends AbstractDaoRestService<OnmsEvent, SearchBean, Integer, Integer> {
    @Autowired
    private EventDao m_dao;

    protected EventDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsEvent> getDaoClass() {
        return OnmsEvent.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass(), Aliases.event.toString());
        builder.alias("alarm", Aliases.alarm.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("distPoller", Aliases.distPoller.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("ipInterfaces"), Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.ipInterface.prop("ipAddress"), (Object)Aliases.event.prop("ipAddr")), Restrictions.isNull((String)Aliases.ipInterface.prop("ipAddress"))}));
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("snmpInterfaces"), Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.snmpInterface.prop("ifIndex"), (Object)Aliases.event.prop("ifIndex")), Restrictions.isNull((String)Aliases.snmpInterface.prop("ifIndex"))}));
        builder.orderBy("eventTime").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsEvent> createListWrapper(Collection<OnmsEvent> list) {
        return new OnmsEventCollection(list);
    }

    @Override
    protected Map<String, String> getSearchBeanPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("event.uei", "event.eventUei");
        return map;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.EVENT_BEHAVIORS);
        map.putAll(CriteriaBehaviors.ALARM_BEHAVIORS);
        map.putAll(CriteriaBehaviors.DIST_POLLER_BEHAVIORS);
        map.putAll(CriteriaBehaviors.NODE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.ASSET_RECORD_BEHAVIORS);
        map.putAll(CriteriaBehaviors.IP_INTERFACE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS);
        map.putAll(CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS);
        map.put("ipAddr", new IpLikeCriteriaBehavior("ipAddr"));
        map.put(Aliases.event.prop("ipAddr"), new IpLikeCriteriaBehavior("ipAddr"));
        return map;
    }

    @Override
    protected OnmsEvent doGet(UriInfo uriInfo, Integer id) {
        return (OnmsEvent)this.getDao().get((Serializable)id);
    }

    @Override
    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@Context SecurityContext securityContext, @Context UriInfo uriInfo, Event event) {
        if (event.getTime() == null) {
            event.setTime(new Date());
        }
        if (event.getSource() == null) {
            event.setSource("ReST");
        }
        this.sendEvent(event);
        return Response.noContent().build();
    }
}

