/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.IpLikeCriteriaBehavior;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.SecurityHelper;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.opennms.web.svclayer.TroubleTicketProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="alarms")
@Transactional
public class AlarmRestService
extends AbstractDaoRestService<OnmsAlarm, SearchBean, Integer, Integer> {
    @Autowired
    private AlarmDao m_dao;
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Autowired
    private AlarmRepository m_repository;
    @Autowired
    private TroubleTicketProxy m_troubleTicketProxy;

    protected AlarmDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsAlarm> getDaoClass() {
        return OnmsAlarm.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass(), Aliases.alarm.toString());
        builder.fetch("lastEvent", Fetch.FetchType.EAGER);
        builder.alias("lastEvent", "lastEvent", Alias.JoinType.LEFT_JOIN);
        builder.alias("distPoller", Aliases.distPoller.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("ipInterfaces"), Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.ipInterface.prop("ipAddress"), (Object)Aliases.alarm.prop("ipAddr")), Restrictions.isNull((String)Aliases.ipInterface.prop("ipAddress"))}));
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("snmpInterfaces"), Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.snmpInterface.prop("ifIndex"), (Object)Aliases.alarm.prop("ifIndex")), Restrictions.isNull((String)Aliases.snmpInterface.prop("ifIndex"))}));
        builder.orderBy("lastEventTime").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsAlarm> createListWrapper(Collection<OnmsAlarm> list) {
        return new OnmsAlarmCollection(list);
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.ALARM_BEHAVIORS);
        map.putAll(CriteriaBehaviors.DIST_POLLER_BEHAVIORS);
        map.putAll(CriteriaBehaviors.NODE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.ASSET_RECORD_BEHAVIORS);
        map.putAll(CriteriaBehaviors.IP_INTERFACE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS);
        map.putAll(CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS);
        map.putAll(CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS);
        map.put("ipAddr", new IpLikeCriteriaBehavior("ipAddr"));
        map.put(Aliases.alarm.prop("ipAddr"), new IpLikeCriteriaBehavior("ipAddr"));
        return map;
    }

    @Override
    protected OnmsAlarm doGet(UriInfo uriInfo, Integer id) {
        return (OnmsAlarm)this.getDao().get((Serializable)id);
    }

    @Override
    protected Response doUpdate(SecurityContext securityContext, UriInfo uriInfo, OnmsAlarm alarm, MultivaluedMapImpl params) {
        boolean isProcessAck = true;
        String ackValue = (String)params.getFirst("ack");
        String escalateValue = (String)params.getFirst("escalate");
        String clearValue = (String)params.getFirst("clear");
        String ackUserValue = (String)params.getFirst("ackUser");
        String ticketIdValue = (String)params.getFirst("ticketId");
        String ticketStateValue = (String)params.getFirst("ticketState");
        String ackUser = ackUserValue == null ? securityContext.getUserPrincipal().getName() : ackUserValue;
        SecurityHelper.assertUserEditCredentials(securityContext, ackUser);
        OnmsAcknowledgment acknowledgement = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
        acknowledgement.setAckAction(AckAction.UNSPECIFIED);
        if (ackValue != null) {
            if (Boolean.parseBoolean(ackValue)) {
                acknowledgement.setAckAction(AckAction.ACKNOWLEDGE);
            } else {
                acknowledgement.setAckAction(AckAction.UNACKNOWLEDGE);
            }
        } else if (escalateValue != null) {
            if (Boolean.parseBoolean(escalateValue)) {
                acknowledgement.setAckAction(AckAction.ESCALATE);
            }
        } else if (clearValue != null) {
            if (Boolean.parseBoolean(clearValue)) {
                acknowledgement.setAckAction(AckAction.CLEAR);
            }
        } else if (StringUtils.isNotBlank((CharSequence)ticketIdValue)) {
            isProcessAck = false;
            alarm.setTTicketId(ticketIdValue);
        } else if (EnumUtils.isValidEnum(TroubleTicketState.class, (String)ticketStateValue)) {
            isProcessAck = false;
            alarm.setTTicketState(TroubleTicketState.valueOf((String)ticketStateValue));
        } else {
            throw this.getException(Response.Status.BAD_REQUEST, "Must supply one of the 'ack', 'escalate', or 'clear' parameters, set to either 'true' or 'false'.", new String[0]);
        }
        if (isProcessAck) {
            this.m_ackDao.processAck(acknowledgement);
        } else {
            this.getDao().saveOrUpdate((Object)alarm);
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{id}/memo")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateMemo(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId, MultivaluedMapImpl params) {
        String user = params.containsKey("user") ? (String)params.getFirst("user") : securityContext.getUserPrincipal().getName();
        SecurityHelper.assertUserEditCredentials(securityContext, user);
        String body = (String)params.getFirst("body");
        if (body == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Body cannot be null.", new String[0]);
        }
        this.m_repository.updateStickyMemo(alarmId, body, user);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{id}/journal")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateJournal(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId, MultivaluedMapImpl params) {
        String user = params.containsKey("user") ? (String)params.getFirst("user") : securityContext.getUserPrincipal().getName();
        SecurityHelper.assertUserEditCredentials(securityContext, user);
        String body = (String)params.getFirst("body");
        if (body == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Body cannot be null.", new String[0]);
        }
        this.m_repository.updateReductionKeyMemo(alarmId, body, user);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{id}/memo")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response removeMemo(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId) {
        SecurityHelper.assertUserEditCredentials(securityContext, securityContext.getUserPrincipal().getName());
        this.m_repository.removeStickyMemo(alarmId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{id}/journal")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response removeJournal(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId) {
        SecurityHelper.assertUserEditCredentials(securityContext, securityContext.getUserPrincipal().getName());
        this.m_repository.removeReductionKeyMemo(alarmId.intValue());
        return Response.noContent().build();
    }

    @POST
    @Path(value="{id}/ticket/create")
    public Response createTicket(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId) throws Exception {
        SecurityHelper.assertUserEditCredentials(securityContext, securityContext.getUserPrincipal().getName());
        return this.runIfTicketerPluginIsEnabled(() -> {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("user", securityContext.getUserPrincipal().getName());
            this.m_troubleTicketProxy.createTicket(alarmId, parameters);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        });
    }

    @POST
    @Path(value="{id}/ticket/update")
    public Response updateTicket(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId) throws Exception {
        SecurityHelper.assertUserEditCredentials(securityContext, securityContext.getUserPrincipal().getName());
        return this.runIfTicketerPluginIsEnabled(() -> {
            this.m_troubleTicketProxy.updateTicket(alarmId);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        });
    }

    @POST
    @Path(value="{id}/ticket/close")
    public Response closeTicket(@Context SecurityContext securityContext, @PathParam(value="id") Integer alarmId) throws Exception {
        SecurityHelper.assertUserEditCredentials(securityContext, securityContext.getUserPrincipal().getName());
        return this.runIfTicketerPluginIsEnabled(() -> {
            this.m_troubleTicketProxy.closeTicket(alarmId);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        });
    }

    private Response runIfTicketerPluginIsEnabled(Callable<Response> callable) throws Exception {
        if (!this.isTicketerPluginEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"AlarmTroubleTicketer is not enabled. Cannot perform operation").build();
        }
        Objects.requireNonNull(callable);
        Response response = callable.call();
        return response;
    }

    private boolean isTicketerPluginEnabled() {
        return "true".equalsIgnoreCase(Vault.getProperty((String)"opennms.alarmTroubleTicketEnabled"));
    }
}

