/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.net.InetAddress;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.StringCriteriaBehavior;

public abstract class CriteriaBehaviors {
    public static final DateFormat SEARCH_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final Map<String, CriteriaBehavior<?>> ALARM_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> ASSET_RECORD_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> DIST_POLLER_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> EVENT_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> IP_INTERFACE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORED_SERVICE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> MONITORING_LOCATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NODE_CATEGORY_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> NOTIFICATION_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> OUTAGE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> REDUCTION_KEY_MEMO_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SERVICE_TYPE_BEHAVIORS = new HashMap();
    public static final Map<String, CriteriaBehavior<?>> SNMP_INTERFACE_BEHAVIORS = new HashMap();

    public static Date parseDate(String string) {
        try {
            return SEARCH_DATE_FORMAT.parse(string);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unparseable date: " + string, e);
        }
    }

    static {
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("alarmAckTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("alarmType"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("counter"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("firstAutomationTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("firstEventTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("ifIndex"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("ipAddr"), new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("lastAutomationTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("lastEventTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("severity"), new CriteriaBehavior<OnmsSeverity>(OnmsSeverity::get));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("suppressedTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("suppressedUntil"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("troubleTicketState"), new CriteriaBehavior<TroubleTicketState>(TroubleTicketState::valueOf));
        ALARM_BEHAVIORS.put(Aliases.alarm.prop("x733ProbableCause"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ASSET_RECORD_BEHAVIORS.put(Aliases.assetRecord.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        ASSET_RECORD_BEHAVIORS.put(Aliases.assetRecord.prop("lastModifiedDate"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        DIST_POLLER_BEHAVIORS.put(Aliases.distPoller.prop("lastUpdated"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventAckTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventCreateTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventSeverity"), new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventSuppressedCount"), new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        EVENT_BEHAVIORS.put(Aliases.event.prop("eventTTicketState"), new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put(Aliases.event.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put(Aliases.event.prop("ifIndex"), new CriteriaBehavior<Integer>(Integer::parseInt));
        EVENT_BEHAVIORS.put(Aliases.event.prop("ipAddr"), new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        IP_INTERFACE_BEHAVIORS.put(Aliases.ipInterface.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        IP_INTERFACE_BEHAVIORS.put(Aliases.ipInterface.prop("lastCapsdPoll"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        IP_INTERFACE_BEHAVIORS.put(Aliases.ipInterface.prop("ipAddress"), new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
        MONITORING_LOCATION_BEHAVIORS.put(Aliases.location.prop("latitude"), new CriteriaBehavior<Float>(Float::parseFloat));
        MONITORING_LOCATION_BEHAVIORS.put(Aliases.location.prop("longitude"), new CriteriaBehavior<Float>(Float::parseFloat));
        MONITORING_LOCATION_BEHAVIORS.put(Aliases.location.prop("priority"), new CriteriaBehavior<Long>(Long::parseLong));
        NODE_BEHAVIORS.put(Aliases.node.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        NODE_BEHAVIORS.put(Aliases.node.prop("createTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        CriteriaBehavior<Integer> categoryId = new CriteriaBehavior<Integer>(Aliases.category.prop("id"), Integer::parseInt, (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql("{alias}.nodeid in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql("{alias}.nodeid not in (select category_node.nodeid from category_node where category_node.categoryid = ?)", v, SqlRestriction.Type.INTEGER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.id: " + c.toString());
                }
            }
        });
        categoryId.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put(Aliases.category.prop("id"), categoryId);
        StringCriteriaBehavior categoryName = new StringCriteriaBehavior(Aliases.category.prop("name"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categoryname %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.name: " + c.toString());
                }
            }
        });
        categoryName.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put(Aliases.category.prop("name"), categoryName);
        StringCriteriaBehavior categoryDescription = new StringCriteriaBehavior(Aliases.category.prop("description"), (b, v, c, w) -> {
            switch (c) {
                case EQUALS: {
                    b.sql(String.format("{alias}.nodeid in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                case NOT_EQUALS: {
                    b.sql(String.format("{alias}.nodeid not in (select category_node.nodeid from category_node, categories where category_node.categoryid = categories.categoryid and categories.categorydescription %s ?)", w ? "like" : "="), v, SqlRestriction.Type.STRING);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal condition type when filtering category.description: " + c.toString());
                }
            }
        });
        categoryDescription.setSkipProperty(true);
        NODE_CATEGORY_BEHAVIORS.put(Aliases.category.prop("description"), categoryDescription);
        NOTIFICATION_BEHAVIORS.put(Aliases.notification.prop("notifyId"), new CriteriaBehavior<Integer>(Integer::parseInt));
        NOTIFICATION_BEHAVIORS.put(Aliases.notification.prop("pageTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        NOTIFICATION_BEHAVIORS.put(Aliases.notification.prop("respondTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put(Aliases.outage.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        OUTAGE_BEHAVIORS.put(Aliases.outage.prop("ifLostService"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put(Aliases.outage.prop("ifRegainedService"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        OUTAGE_BEHAVIORS.put(Aliases.outage.prop("suppressTime"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SERVICE_TYPE_BEHAVIORS.put(Aliases.serviceType.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("id"), new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("ifAdminStatus"), new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("ifIndex"), new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("ifOperStatus"), new CriteriaBehavior<Integer>(Integer::parseInt));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("ifSpeed"), new CriteriaBehavior<Long>(Long::parseLong));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("lastCapsdPoll"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("lastSnmpPoll"), new CriteriaBehavior<Date>(CriteriaBehaviors::parseDate));
        SNMP_INTERFACE_BEHAVIORS.put(Aliases.snmpInterface.prop("netMask"), new CriteriaBehavior<InetAddress>(InetAddressUtils::addr));
    }
}

