/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.util.Collection;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="nodes")
@Transactional
public class NodeRestService
extends AbstractDaoRestService<OnmsNode, Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestService.class);
    @Autowired
    private MonitoringLocationDao m_locationDao;
    @Autowired
    private NodeDao m_dao;

    protected NodeDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsNode> getDaoClass() {
        return OnmsNode.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder() {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("categories", "category", Alias.JoinType.LEFT_JOIN);
        builder.alias("assetRecord", "assetRecord", Alias.JoinType.LEFT_JOIN);
        builder.alias("location", "location", Alias.JoinType.LEFT_JOIN);
        builder.alias("ipInterfaces.monitoredServices.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        builder.orderBy("label").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsNode> createListWrapper(Collection<OnmsNode> list) {
        return new OnmsNodeList(list);
    }

    @Override
    public Response doCreate(UriInfo uriInfo, OnmsNode object) {
        if (object.getLocation() == null) {
            OnmsMonitoringLocation location = this.m_locationDao.getDefaultLocation();
            LOG.debug("addNode: Assigning new node to default location: {}", (Object)location.getLocationName());
            object.setLocation(location);
        }
        return super.doCreate(uriInfo, object);
    }
}

