/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.resource.ResourceDTO;
import org.opennms.netmgt.model.resource.ResourceDTOCollection;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="resourceRestService")
@Path(value="resources")
public class ResourceRestService
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private ResourceDao m_resourceDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTOCollection getResources(@DefaultValue(value="1") @QueryParam(value="depth") int depth) {
        LinkedList resources = Lists.newLinkedList();
        for (OnmsResource resource : this.m_resourceDao.findTopLevelResources()) {
            resources.add(ResourceDTO.fromResource((OnmsResource)resource, (int)depth));
        }
        return new ResourceDTOCollection((Collection)resources);
    }

    @GET
    @Path(value="{resourceId}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTO getResourceById(@PathParam(value="resourceId") String resourceId, @DefaultValue(value="-1") @QueryParam(value="depth") int depth) {
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        if (resource == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource with id '{}' found.", resourceId);
        }
        return ResourceDTO.fromResource((OnmsResource)resource, (int)depth);
    }

    @DELETE
    @Path(value="{resourceId}")
    @Transactional(readOnly=false)
    public void deleteResourceById(@PathParam(value="resourceId") String resourceId) {
        boolean found = this.m_resourceDao.deleteResourceById(resourceId);
        if (!found) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource with id '{}' found.", resourceId);
        }
    }

    @GET
    @Path(value="fornode/{nodeCriteria}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional(readOnly=true)
    public ResourceDTO getResourceForNode(@PathParam(value="nodeCriteria") String nodeCriteria, @DefaultValue(value="-1") @QueryParam(value="depth") int depth) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No node found with criteria '{}'.", nodeCriteria);
        }
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        if (resource == null) {
            throw ResourceRestService.getException(Response.Status.NOT_FOUND, "No resource found for node with id {}.", "" + node.getId());
        }
        return ResourceDTO.fromResource((OnmsResource)resource, (int)depth);
    }
}

