/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.support.PropertyUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="assetSuggestionsRestService")
@Path(value="assets")
public class AssetSuggestionsRestService
extends OnmsRestService
implements InitializingBean {
    private static final Set<String> BLACK_LIST = new HashSet<String>();
    @Autowired
    protected AssetRecordDao m_assetDao;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_assetDao, (String)"AssetRecordDao is required.");
    }

    @GET
    @Path(value="suggestions")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Suggestions getAssetSuggestions() {
        Suggestions suggestions = new Suggestions();
        List distinctAssetProperties = this.m_assetDao.getDistinctProperties();
        List attributes = PropertyUtils.getProperties((Object)new OnmsAssetRecord()).stream().filter(a -> !BLACK_LIST.contains(a)).collect(Collectors.toList());
        distinctAssetProperties.forEach(record -> {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)record);
            attributes.forEach(attribute -> {
                SuggestionList list;
                Object value;
                if (!suggestions.containsKey(attribute)) {
                    suggestions.put(attribute, new SuggestionList());
                }
                if ((value = wrapper.getPropertyValue(attribute)) != null && !(list = (SuggestionList)((Object)((Object)((Object)suggestions.get(attribute))))).contains(value.toString())) {
                    list.add(value.toString());
                }
            });
        });
        return suggestions;
    }

    static {
        BLACK_LIST.add("class");
        BLACK_LIST.add("geolocation");
        BLACK_LIST.add("lastModifiedDate");
        BLACK_LIST.add("lastModifiedBy");
    }

    @XmlRootElement(name="suggestions")
    public static class SuggestionList
    extends JaxbListWrapper<String> {
        public SuggestionList() {
        }

        public SuggestionList(Collection<? extends String> c) {
            super(c);
        }

        @XmlElement(name="suggestion")
        public List<String> getSuggestions() {
            List elements = this.getObjects();
            Collections.sort(elements);
            return elements;
        }
    }

    @XmlRootElement(name="suggestions")
    public static class Suggestions
    extends TreeMap<String, SuggestionList> {
        @XmlElementWrapper(name="mappings")
        public Map<String, SuggestionList> getSuggestions() {
            return this;
        }
    }
}

