/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsNotificationCollection;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.IpLikeCriteriaBehavior;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="notifications")
@Transactional
public class NotificationRestService
extends AbstractDaoRestService<OnmsNotification, SearchBean, Integer, Integer> {
    @Autowired
    private NotificationDao m_dao;

    protected NotificationDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsNotification> getDaoClass() {
        return OnmsNotification.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNotification.class, Aliases.notification.toString());
        builder.alias("event", Aliases.event.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("node", Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.event.prop("distPoller"), Aliases.distPoller.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("ipInterfaces"), Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)Aliases.ipInterface.prop("ipAddress"), (Object)Aliases.notification.prop("ipAddress")), Restrictions.isNull((String)Aliases.ipInterface.prop("ipAddress"))}));
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("snmpInterfaces"), Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eqProperty((String)Aliases.snmpInterface.prop("ifIndex"), (Object)Aliases.event.prop("ifIndex")), Restrictions.isNull((String)Aliases.snmpInterface.prop("ifIndex"))}));
        builder.orderBy("notifyId").desc();
        return builder;
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.NOTIFICATION_SERVICE_PROPERTIES;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.NOTIFICATION_BEHAVIORS);
        map.put("ipAddress", new IpLikeCriteriaBehavior("interfaceId"));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.notification, CriteriaBehaviors.NOTIFICATION_BEHAVIORS));
        map.put(Aliases.notification.prop("ipAddress"), new IpLikeCriteriaBehavior("interfaceId"));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.event, CriteriaBehaviors.EVENT_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.node, CriteriaBehaviors.NODE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.serviceType, CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.assetRecord, CriteriaBehaviors.ASSET_RECORD_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.distPoller, CriteriaBehaviors.DIST_POLLER_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.ipInterface, CriteriaBehaviors.IP_INTERFACE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.location, CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.category, CriteriaBehaviors.NODE_CATEGORY_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.snmpInterface, CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS));
        return map;
    }

    @Override
    protected JaxbListWrapper<OnmsNotification> createListWrapper(Collection<OnmsNotification> list) {
        return new OnmsNotificationCollection(list);
    }

    @Override
    protected OnmsNotification doGet(UriInfo uriInfo, Integer id) {
        return (OnmsNotification)this.getDao().get((Serializable)id);
    }
}

