/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.opennms.netmgt.config.poller.outages.Outages;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="scheduledOutagesRestService")
@Path(value="sched-outages")
public class ScheduledOutagesRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledOutagesRestService.class);
    @Autowired
    protected PollOutagesConfigFactory m_pollOutagesConfigFactory;
    @Autowired
    protected CollectdConfigFactory m_collectdConfigFactory;
    @Autowired
    @Qualifier(value="eventProxy")
    protected EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Outages getOutages() {
        Outages outages = new Outages();
        outages.setOutages(this.m_pollOutagesConfigFactory.getOutages());
        return outages;
    }

    @GET
    @Path(value="{outageName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Outage getOutage(@PathParam(value="outageName") String outageName) throws IllegalArgumentException {
        Outage outage = this.m_pollOutagesConfigFactory.getOutage(outageName);
        if (outage == null) {
            throw ScheduledOutagesRestService.getException(Response.Status.NOT_FOUND, "Scheduled outage {} was not found.", outageName);
        }
        return outage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response saveOrUpdateOutage(@Context UriInfo uriInfo, Outage newOutage) {
        this.writeLock();
        try {
            if (newOutage == null) {
                throw ScheduledOutagesRestService.getException(Response.Status.BAD_REQUEST, "Outage object can't be null", new String[0]);
            }
            Outage oldOutage = this.m_pollOutagesConfigFactory.getOutage(newOutage.getName());
            if (oldOutage == null) {
                LOG.debug("saveOrUpdateOutage: adding outage {}", (Object)newOutage.getName());
                this.m_pollOutagesConfigFactory.addOutage(newOutage);
            } else {
                LOG.debug("saveOrUpdateOutage: updating outage {}", (Object)newOutage.getName());
                this.m_pollOutagesConfigFactory.replaceOutage(oldOutage, newOutage);
            }
            try {
                this.m_pollOutagesConfigFactory.saveCurrent();
            }
            catch (Exception e) {
                throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't save or update the scheduled outage {} because, {}", newOutage.getName(), e.getMessage());
            }
            this.sendConfigChangedEvent();
            Response response = oldOutage == null ? Response.created((URI)ScheduledOutagesRestService.getRedirectUri(uriInfo, newOutage.getName())).build() : Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}")
    public Response deleteOutage(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            LOG.debug("deleteOutage: deleting outage {}", (Object)outageName);
            this.updateCollectd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updatePollerd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updateThreshd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updateNotifd(ConfigAction.REMOVE, outageName);
            try {
                this.m_pollOutagesConfigFactory.removeOutage(outageName);
                this.m_pollOutagesConfigFactory.saveCurrent();
            }
            catch (Exception e) {
                throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't delete the scheduled outage {} because, {}", outageName, e.getMessage());
            }
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{outageName}/collectd/{packageName}")
    public Response addOutageToCollector(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateCollectd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{outageName}/collectd/{packageName}")
    public Response removeOutageFromCollector(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateCollectd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{outageName}/pollerd/{packageName}")
    public Response addOutageToPoller(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updatePollerd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{outageName}/pollerd/{packageName}")
    public Response removeOutageFromPoller(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updatePollerd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{outageName}/threshd/{packageName}")
    public Response addOutageToThresholder(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateThreshd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/threshd/{packageName}")
    public Response removeOutageFromThresholder(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateThreshd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't delete the scheduled outage {} because, {}", outageName, e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{outageName}/notifd")
    public Response addOutageToNotifications(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            this.updateNotifd(ConfigAction.ADD, outageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/notifd")
    public Response removeOutageFromNotifications(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            this.updateNotifd(ConfigAction.REMOVE, outageName);
            this.sendConfigChangedEvent();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="{outageName}/nodeInOutage/{nodeId}")
    @Produces(value={"text/plain"})
    public String isNodeInOutage(@PathParam(value="outageName") String outageName, @PathParam(value="nodeId") Integer nodeId) {
        Outage outage = this.getOutage(outageName);
        Boolean inOutage = this.m_pollOutagesConfigFactory.isNodeIdInOutage((long)nodeId.intValue(), outage) && this.m_pollOutagesConfigFactory.isCurTimeInOutage(outage);
        return inOutage.toString();
    }

    @GET
    @Path(value="nodeInOutage/{nodeId}")
    @Produces(value={"text/plain"})
    public String isNodeInOutage(@PathParam(value="nodeId") int nodeId) {
        for (Outage outage : this.m_pollOutagesConfigFactory.getOutages()) {
            if (!this.m_pollOutagesConfigFactory.isNodeIdInOutage((long)nodeId, outage) || !this.m_pollOutagesConfigFactory.isCurTimeInOutage(outage)) continue;
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    @GET
    @Path(value="{outageName}/interfaceInOutage/{ipAddr}")
    @Produces(value={"text/plain"})
    public String isInterfaceInOutage(@PathParam(value="outageName") String outageName, @PathParam(value="ipAddr") String ipAddr) {
        ScheduledOutagesRestService.validateAddress(ipAddr);
        Outage outage = this.getOutage(outageName);
        Boolean inOutage = this.m_pollOutagesConfigFactory.isInterfaceInOutage(ipAddr, outage) && this.m_pollOutagesConfigFactory.isCurTimeInOutage(outage);
        return inOutage.toString();
    }

    @GET
    @Path(value="interfaceInOutage/{ipAddr}")
    @Produces(value={"text/plain"})
    public String isInterfaceInOutage(@PathParam(value="ipAddr") String ipAddr) {
        for (Outage outage : this.m_pollOutagesConfigFactory.getOutages()) {
            if (!this.m_pollOutagesConfigFactory.isInterfaceInOutage(ipAddr, outage) || !this.m_pollOutagesConfigFactory.isCurTimeInOutage(outage)) continue;
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private static void validateAddress(String ipAddress) {
        boolean valid = false;
        try {
            valid = InetAddressUtils.addr((String)ipAddress) != null;
        }
        catch (Exception e) {
            valid = false;
        }
        if (!valid) {
            throw ScheduledOutagesRestService.getException(Response.Status.BAD_REQUEST, "Malformed IP Address {}", ipAddress);
        }
    }

    private void updateCollectd(ConfigAction action, String outageName, String packageName) {
        Object pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = this.getCollectdPackage(packageName)).getOutageCalendars().contains(outageName)) {
            pkg.addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = this.getCollectdPackage(packageName);
            pkg.removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (org.opennms.netmgt.config.collectd.Package pkg2 : this.m_collectdConfigFactory.getCollectdConfig().getPackages()) {
                pkg2.removeOutageCalendar(outageName);
            }
        }
        try {
            this.m_collectdConfigFactory.saveCurrent();
        }
        catch (Exception e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't save collector's configuration: {}", e.getMessage());
        }
    }

    private org.opennms.netmgt.config.collectd.Package getCollectdPackage(String packageName) {
        org.opennms.netmgt.config.collectd.Package pkg = this.m_collectdConfigFactory.getPackage(packageName);
        if (pkg == null) {
            throw ScheduledOutagesRestService.getException(Response.Status.NOT_FOUND, "Collector package {} does not exist.", packageName);
        }
        return pkg;
    }

    private void updatePollerd(ConfigAction action, String outageName, String packageName) {
        Object pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = ScheduledOutagesRestService.getPollerdPackage(packageName)).getOutageCalendars().contains(outageName)) {
            pkg.addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = ScheduledOutagesRestService.getPollerdPackage(packageName);
            pkg.removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (Package pkg2 : PollerConfigFactory.getInstance().getConfiguration().getPackages()) {
                pkg2.removeOutageCalendar(outageName);
            }
        }
        try {
            PollerConfigFactory.getInstance().save();
        }
        catch (Exception e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't save poller's configuration: {}", e.getMessage());
        }
    }

    private static Package getPollerdPackage(String packageName) {
        Package pkg = PollerConfigFactory.getInstance().getPackage(packageName);
        if (pkg == null) {
            throw ScheduledOutagesRestService.getException(Response.Status.NOT_FOUND, "Poller package {} does not exist.", packageName);
        }
        return pkg;
    }

    private void updateThreshd(ConfigAction action, String outageName, String packageName) {
        Object pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = ScheduledOutagesRestService.getThreshdPackage(packageName)).getOutageCalendars().contains(outageName)) {
            pkg.addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = ScheduledOutagesRestService.getThreshdPackage(packageName);
            pkg.removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (org.opennms.netmgt.config.threshd.Package pkg2 : ThreshdConfigFactory.getInstance().getConfiguration().getPackages()) {
                pkg2.removeOutageCalendar(outageName);
            }
        }
        try {
            ThreshdConfigFactory.getInstance().saveCurrent();
        }
        catch (Exception e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't save thresholds configuration: {}", e.getMessage());
        }
    }

    private static org.opennms.netmgt.config.threshd.Package getThreshdPackage(String packageName) {
        org.opennms.netmgt.config.threshd.Package pkg = ThreshdConfigFactory.getInstance().getPackage(packageName);
        if (pkg == null) {
            throw ScheduledOutagesRestService.getException(Response.Status.NOT_FOUND, "Threshold package {} does not exist.", packageName);
        }
        return pkg;
    }

    private void updateNotifd(ConfigAction action, String outageName) {
        this.getOutage(outageName);
        try {
            NotifdConfigFactory factory = NotifdConfigFactory.getInstance();
            if (action.equals((Object)ConfigAction.ADD)) {
                factory.getConfiguration().addOutageCalendar(outageName);
            }
            if (action.equals((Object)ConfigAction.REMOVE) || action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
                factory.getConfiguration().removeOutageCalendar(outageName);
            }
            factory.saveCurrent();
        }
        catch (Exception e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't save notifications configuration: {}", e.getMessage());
        }
    }

    private void sendConfigChangedEvent() {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/schedOutagesChanged", "ReST");
        try {
            this.m_eventProxy.send(builder.getEvent());
        }
        catch (Throwable e) {
            throw ScheduledOutagesRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Can't send event {} : {}", builder.getEvent().getUei(), e.getMessage());
        }
    }

    private static enum ConfigAction {
        ADD,
        REMOVE,
        REMOVE_FROM_ALL;

    }
}

