/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaBuilderSearchVisitor<T, Q>
extends AbstractSearchConditionVisitor<Q, CriteriaBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(CriteriaBuilderSearchVisitor.class);
    public static final String NULL_VALUE = "\u0000";
    public static final Date NULL_DATE_VALUE = new Date(0L);
    private final Class<T> m_class;
    private final CriteriaBuilder m_criteriaBuilder;
    private final Map<String, CriteriaBehavior<?>> m_criteriaBehaviors;

    public CriteriaBuilderSearchVisitor(CriteriaBuilder criteriaBuilder, Class<T> clazz) {
        this(criteriaBuilder, clazz, null);
    }

    public CriteriaBuilderSearchVisitor(CriteriaBuilder criteriaBuilder, Class<T> clazz, Map<String, CriteriaBehavior<?>> behaviors) {
        super(null);
        this.m_class = clazz;
        this.m_criteriaBuilder = criteriaBuilder;
        this.m_criteriaBehaviors = behaviors;
        this.setWildcardStringMatch(true);
    }

    public void visit(SearchCondition<Q> sc) {
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                Object value;
                String name = this.getRealPropertyName(statement.getProperty());
                AbstractSearchConditionVisitor.ClassValue clsValue = this.getPrimitiveFieldClass(statement, name, statement.getValue().getClass(), statement.getValueType(), statement.getValue());
                boolean isWildcard = false;
                if (String.class.equals((Object)clsValue.getCls()) && SearchUtils.containsWildcard((String)((String)clsValue.getValue()))) {
                    isWildcard = true;
                    clsValue.setValue((Object)SearchUtils.toSqlWildcardString((String)((String)clsValue.getValue()), (boolean)false));
                }
                if (this.m_criteriaBehaviors != null && this.m_criteriaBehaviors.containsKey(name)) {
                    CriteriaBehavior<?> behavior = this.m_criteriaBehaviors.get(name);
                    name = behavior.getPropertyName() == null ? name : behavior.getPropertyName();
                    value = NULL_VALUE.equals((String)clsValue.getValue()) ? null : behavior.convert((String)clsValue.getValue());
                    behavior.beforeVisit(this.m_criteriaBuilder, value, sc.getConditionType(), isWildcard);
                    if (behavior.shouldSkipProperty()) {
                        return;
                    }
                } else {
                    value = clsValue.getValue();
                }
                switch (sc.getConditionType()) {
                    case EQUALS: {
                        if (isWildcard) {
                            this.m_criteriaBuilder.like(name, value);
                            break;
                        }
                        if (value == null || NULL_VALUE.equals(value) || NULL_DATE_VALUE.equals(value)) {
                            this.m_criteriaBuilder.isNull(name);
                            break;
                        }
                        this.m_criteriaBuilder.eq(name, value);
                        break;
                    }
                    case NOT_EQUALS: {
                        if (isWildcard) {
                            this.m_criteriaBuilder.not().like(name, value);
                            break;
                        }
                        if (value == null || NULL_VALUE.equals(value) || NULL_DATE_VALUE.equals(value)) {
                            this.m_criteriaBuilder.isNotNull(name);
                            break;
                        }
                        this.m_criteriaBuilder.or(new Restriction[]{Restrictions.ne((String)name, (Object)value), Restrictions.isNull((String)name)});
                        break;
                    }
                    case LESS_THAN: {
                        this.m_criteriaBuilder.lt(name, value);
                        break;
                    }
                    case GREATER_THAN: {
                        this.m_criteriaBuilder.gt(name, value);
                        break;
                    }
                    case LESS_OR_EQUALS: {
                        this.m_criteriaBuilder.le(name, value);
                        break;
                    }
                    case GREATER_OR_EQUALS: {
                        this.m_criteriaBuilder.ge(name, value);
                        break;
                    }
                }
            }
        } else {
            ArrayList<AllRestriction> subRestrictions = new ArrayList<AllRestriction>();
            for (SearchCondition condition : sc.getSearchConditions()) {
                Collection restrictions;
                CriteriaBuilder builder = null;
                try {
                    builder = (CriteriaBuilder)this.m_criteriaBuilder.getClass().getConstructor(Class.class).newInstance(this.m_class);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.warn("Could not create " + this.m_criteriaBuilder.getClass().getSimpleName() + "; falling back to CriteriaBuilder: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    builder = new CriteriaBuilder(this.m_class);
                }
                CriteriaBuilderSearchVisitor<T, Q> newVisitor = new CriteriaBuilderSearchVisitor<T, Q>(builder, this.m_class, this.m_criteriaBehaviors);
                condition.accept(newVisitor);
                Criteria newCriteria = newVisitor.getQuery().toCriteria();
                Collection aliases = newCriteria.getAliases();
                if (aliases != null) {
                    for (Alias alias : aliases) {
                        this.m_criteriaBuilder.alias(alias);
                    }
                }
                if ((restrictions = newCriteria.getRestrictions()) == null || restrictions.size() <= 0) continue;
                Object subRestriction = restrictions.size() > 1 ? Restrictions.all((Collection)restrictions) : (Restriction)restrictions.iterator().next();
                LOG.info(subRestriction.toString());
                subRestrictions.add((AllRestriction)subRestriction);
            }
            switch (sc.getConditionType()) {
                case OR: {
                    LOG.info("OR criteria");
                    this.m_criteriaBuilder.or(subRestrictions.toArray(new Restriction[0]));
                    break;
                }
                case AND: {
                    LOG.info("AND criteria");
                    this.m_criteriaBuilder.and(subRestrictions.toArray(new Restriction[0]));
                    break;
                }
            }
        }
    }

    public CriteriaBuilder getQuery() {
        return this.m_criteriaBuilder;
    }
}

