/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.opennms.core.criteria.CriteriaBuilder;

public class CriteriaBehavior<T> {
    private final String m_criteriaPropertyName;
    private final BeforeVisit m_beforeVisit;
    private final Function<String, T> m_converter;
    private boolean m_skipProperty = false;

    public CriteriaBehavior(Function<String, T> converter) {
        this(null, converter, (b, v, c, w) -> {});
    }

    public CriteriaBehavior(String name, Function<String, T> converter) {
        this(name, converter, (b, v, c, w) -> {});
    }

    public CriteriaBehavior(String name, Function<String, T> converter, BeforeVisit beforeVisit) {
        this.m_criteriaPropertyName = name;
        this.m_converter = converter;
        this.m_beforeVisit = beforeVisit;
    }

    public String getPropertyName() {
        return this.m_criteriaPropertyName;
    }

    public Function<String, T> getConverter() {
        return this.m_converter;
    }

    public void beforeVisit(CriteriaBuilder builder, Object value, ConditionType c, boolean isWildcard) {
        this.m_beforeVisit.accept(builder, value, c, isWildcard);
    }

    public T convert(String value) {
        return this.m_converter.apply(value);
    }

    public void setSkipProperty(boolean skip) {
        this.m_skipProperty = skip;
    }

    public boolean shouldSkipProperty() {
        return this.m_skipProperty;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("criteriaPropertyName", (Object)this.m_criteriaPropertyName).append("converter", this.m_converter).append("beforeVisit", (Object)this.m_beforeVisit).append("skipProperty", this.m_skipProperty).build();
    }

    @FunctionalInterface
    public static interface BeforeVisit {
        public void accept(CriteriaBuilder var1, Object var2, ConditionType var3, boolean var4);
    }
}

